/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class FrmFileWriterFromDirectory {
    public static void main(String[] args) throws IOException {
        String frmDirectory = args[0];
        String targetFrm = args[1];
        File targetFrmFile = new File(targetFrm);
        try (FrmFileWriter writer = new FrmFileWriter(targetFrmFile.getAbsolutePath());){
            FrmFileWriterFromDirectory.addFile(writer, frmDirectory, "manifest.frmm");
            FrmFileWriterFromDirectory.addFile(writer, frmDirectory, "build.mf");
            FrmFileWriterFromDirectory.addFiles(Paths.get(frmDirectory, new String[0]), Paths.get(frmDirectory, new String[0]), writer);
        }
    }

    private static void addFile(FrmFileWriter writer, String frmDirectory, String fileName) throws IOException {
        File file = new File(frmDirectory, fileName);
        if (file.exists()) {
            writer.addFile(fileName, file);
        }
    }

    private static void addFiles(Path baseDir, Path dir, FrmFileWriter writer) throws IOException {
        for (Path path : Files.list(dir).collect(Collectors.toList())) {
            if (path.toFile().isDirectory()) {
                writer.addDirectory(baseDir.relativize(path).toString(), path.toFile());
                FrmFileWriterFromDirectory.addFiles(baseDir, path, writer);
                continue;
            }
            if (path.toString().endsWith("build.mf") || path.toString().endsWith("manifest.frmm")) continue;
            writer.addFile(baseDir.relativize(path).toString(), path.toFile());
        }
    }
}

