/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.zip.ArchiveEntry;
import com.streamscape.lib.zip.ArchiveOutputStream;
import com.streamscape.lib.zip.TarArchiveOutputStream;
import com.streamscape.lib.zip.ZipArchiveOutputStream;
import com.streamscape.lib.zip.ZipEncArchiveOutputStream;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.cache.CacheMissException;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFile;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.runtime.mf.operation.repository.ImportOperation;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.utils.Utils;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FrmFileWriter
extends FrmFile {
    String filename;
    File frmFile;
    ArchiveOutputStream archive;
    TFCache cache;
    boolean withoutData;
    boolean ignoreAddFileErrors;
    List<String> failedFiles = new ArrayList<String>();
    private static final List<String> SPECIAL_ENTRIES = new ArrayList<String>(Arrays.asList(File.separator + "security" + File.separator, File.separator + "serializer" + File.separator, File.separator + "mf" + File.separator));
    private boolean ddxAdded = false;
    private static final Set<String> ROOT_DIR_EXCLUSIONS = new HashSet<String>(Arrays.asList(""));

    public FrmFileWriter(String filename) throws IOException {
        this(filename, Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]));
    }

    public FrmFileWriter(String filename, OutputStream output) throws IOException {
        this(filename, output, true, null);
    }

    public FrmFileWriter(String filename, OutputStream output, boolean asZip, String password) throws IOException {
        this.filename = filename;
        this.frmFile = new File(filename).getAbsoluteFile();
        this.archive = asZip ? (password != null ? new ZipEncArchiveOutputStream(output, password) : new ZipArchiveOutputStream(output)) : new TarArchiveOutputStream(output);
    }

    public void setTFCache(TFCache cache) {
        this.cache = cache;
    }

    public void setWithoutData(boolean withoutData) {
        this.withoutData = withoutData;
    }

    public void addFile(String entryName, File file) throws IOException {
        SLOperationLogger.log(this, String.format("Adding entry '%s'...", entryName.replace(File.separatorChar, '/')));
        this.archive.putArchiveEntry(this.archive.createArchiveEntry(file, entryName.replace(File.separatorChar, '/')));
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int count;
            while ((count = input.read(this.BUFFER)) > 0) {
                this.archive.write(this.BUFFER, 0, count);
            }
        }
        catch (Exception exception) {
            if (!this.ignoreAddFileErrors) {
                throw exception;
            }
            this.failedFiles.add(file.toString());
        }
        this.archive.closeArchiveEntry();
        SLOperationLogger.log(this, " Done.\n");
    }

    public boolean addFile(String entryName) throws IOException {
        try {
            SLOperationLogger.log(this, String.format("Adding entry '%s'...", entryName.replace(File.separatorChar, '/')));
            this.archive.putArchiveEntry(this.archive.createArchiveEntry(new File(entryName), entryName.replace(File.separatorChar, '/')));
            String tfcacheRelativePath = FrmFileWriter.getCacheRelativePath(entryName);
            if (entryName.startsWith(FrmEntityType.ARCHIVE.getRelativePath())) {
                tfcacheRelativePath = FrmFileWriter.getCacheRelativePath(tfcacheRelativePath);
                byte[] archiveContent = this.cache.getArchive(tfcacheRelativePath);
                this.archive.write(archiveContent, 0, archiveContent.length);
            } else {
                try {
                    RandomAccessFile file = this.cache.getEntityAsFile(tfcacheRelativePath);
                    if (file != null) {
                        int count;
                        file.seek(0L);
                        while ((count = file.read(this.BUFFER)) > 0) {
                            this.archive.write(this.BUFFER, 0, count);
                        }
                    }
                }
                catch (CacheMissException error) {
                    if (FrmFileWriter.isSpecialEntry(entryName)) {
                        Object obj = this.cache.loadSystemObject(tfcacheRelativePath);
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        this.cache.saveSystemObject(obj, output);
                        this.archive.write(output.toByteArray());
                        this.archive.closeArchiveEntry();
                        SLOperationLogger.log(this, " Done.\n");
                        return true;
                    }
                    return false;
                }
            }
            this.archive.closeArchiveEntry();
            SLOperationLogger.log(this, " Done.\n");
            return true;
        }
        catch (Exception error) {
            throw new IOException(error);
        }
    }

    private static boolean isSpecialEntry(String entryName) {
        return SPECIAL_ENTRIES.stream().anyMatch(entryName::contains);
    }

    public void addFile(String entryName, byte[] data) throws IOException {
        int count;
        SLOperationLogger.log(this, String.format("Adding entry '%s'...", entryName.replace(File.separatorChar, '/')));
        this.archive.putArchiveEntry(this.archive.createArchiveEntry(new File(entryName), entryName.replace(File.separatorChar, '/')));
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        while ((count = input.read(this.BUFFER)) > 0) {
            this.archive.write(this.BUFFER, 0, count);
        }
        this.archive.closeArchiveEntry();
        SLOperationLogger.log(this, " Done.\n");
    }

    public void addDirectory(String entryName, File dir) throws IOException {
        this.archive.putArchiveEntry(this.archive.createArchiveEntry(dir, entryName.replace(File.separatorChar, '/')));
        this.archive.closeArchiveEntry();
    }

    public void generate(File sourceDir, File ddxDir, FrmManifest manifest, FeedbackSender feedbackSender) throws Exception {
        for (FrmEntityType type : FrmEntityType.values()) {
            manifest.getExcludeEntities().putIfAbsent(type, new HashSet());
            manifest.getIncludeEntities().putIfAbsent(type, new HashSet());
        }
        FrmFileWriter.sendFeedback(feedbackSender, "Processing working directory...\n");
        this.processRootDir(sourceDir, manifest);
        this.addDeploymentDescriptor(ddxDir, feedbackSender);
        FrmFileWriter.sendFeedback(feedbackSender, "Processing .tfcache directory...\n");
        this.processDir(sourceDir, FrmEntityType.CLIENT_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.EXT_ARCHIVE, manifest);
        this.processDir(sourceDir, FrmEntityType.ARCHIVE, manifest);
        this.processDir(sourceDir, FrmEntityType.GVAR, manifest);
        this.processDir(sourceDir, FrmEntityType.JDBC_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.TRANSPORT_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.PACKAGE, manifest);
        this.processDir(sourceDir, FrmEntityType.SEMANTIC_TYPE, manifest);
        this.processDir(sourceDir, FrmEntityType.EVENT_PROTOTYPE, manifest);
        this.processDir(sourceDir, FrmEntityType.SERVICE, manifest);
        this.processDirWithNamespaces(sourceDir, FrmEntityType.MLCACHE, manifest);
        this.processDirWithNamespaces(sourceDir, FrmEntityType.ARTIFACT, manifest);
        this.processDirWithNamespaces(sourceDir, FrmEntityType.OBJECT, manifest);
        FrmFileWriter.sendFeedback(feedbackSender, "Processing .dscache directory...\n");
        if (this.withoutData) {
            this.extractDataspaceMetadata(sourceDir);
        } else {
            this.processDirWithNamespaces(sourceDir, FrmEntityType.DATASPACE, manifest);
        }
        FrmFileWriter.sendFeedback(feedbackSender, "Processing .htcache directory...\n");
        this.processHtCacheDir(sourceDir, manifest);
    }

    void addDeploymentDescriptor(File ddxDir, FeedbackSender feedbackSender) throws Exception {
        if (ddxDir != null && !this.ddxAdded) {
            FrmFileWriter.sendFeedback(feedbackSender, "Adding deployment descriptor...\n");
            this.addFile("stdeploy.jar", new File(ddxDir, "stdeploy.jar"));
        }
    }

    private static void sendFeedback(FeedbackSender feedbackSender, String message) throws Exception {
        if (feedbackSender != null) {
            feedbackSender.send(message);
        }
    }

    public void extractDataspaceMetadata(File sourceDir) {
        try {
            File dir = new File(sourceDir, FrmEntityType.DATASPACE.getRelativePath());
            this.addDirectory(FrmEntityType.DATASPACE.getRelativePath(), dir);
            String entityName = FrmEntityType.DATASPACE.getRelativePath() + File.separator + "dtspace.log";
            File logFile = new File(String.valueOf(sourceDir) + File.separator + entityName);
            String realEntryName = entityName.replace(File.separatorChar, '/');
            ArchiveEntry entry = this.archive.createArchiveEntry(logFile, realEntryName);
            this.archive.putArchiveEntry(entry);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            SqlUtils.extractDataspaceMetadata(logFile.getAbsolutePath(), output);
            this.archive.write(output.toByteArray());
            this.archive.closeArchiveEntry();
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to extract dataspace metadata. " + error.getMessage());
        }
    }

    public void extractDataspaceFlobs(File sourceDir, List<String> locations, FrmManifest manifest) {
        try {
            Predicate workingDirectoryInclusionPredicate = this.getPredicate("", FrmEntityType.WORKING_DIR, manifest);
            Path dataspacePath = Paths.get(sourceDir.getAbsolutePath(), FrmEntityType.DATASPACE.getRelativePath()).toAbsolutePath();
            Path tfcachePath = Paths.get(sourceDir.getAbsolutePath(), new String[0]).toAbsolutePath();
            for (String location : locations) {
                File[] files;
                Path absoluteLocation = dataspacePath.resolve(location).normalize().toAbsolutePath();
                if (absoluteLocation.startsWith(dataspacePath) || !absoluteLocation.startsWith(tfcachePath)) continue;
                Path relativeLocation = tfcachePath.relativize(absoluteLocation);
                if (workingDirectoryInclusionPredicate != null && workingDirectoryInclusionPredicate.check(new FrmEntity(relativeLocation.toString(), ""))) continue;
                this.addDirectory(relativeLocation.toString(), absoluteLocation.toFile());
                for (File file : files = FileIOUtils.directoryList(absoluteLocation.toString(), "")) {
                    if (!file.isFile()) continue;
                    this.addFile(new File(relativeLocation.toString(), file.getName()).getPath(), file);
                }
            }
        }
        catch (Exception error) {
            Trace.logError(this, "Unable to add FLOB files. " + error.getMessage());
        }
    }

    public void processTfCache(File sourceDir, FrmManifest manifest, TFCache cache) throws IOException, UtilitiesException {
        for (FrmEntityType type : FrmEntityType.values()) {
            manifest.getExcludeEntities().putIfAbsent(type, new HashSet());
            manifest.getIncludeEntities().putIfAbsent(type, new HashSet());
        }
        this.processDir(sourceDir, FrmEntityType.CLIENT_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.EXT_ARCHIVE, manifest);
        this.processDir(sourceDir, FrmEntityType.ARCHIVE, manifest);
        this.processDir(sourceDir, FrmEntityType.GVAR, manifest);
        this.processDir(sourceDir, FrmEntityType.JDBC_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.TRANSPORT_FACTORY, manifest);
        this.processDir(sourceDir, FrmEntityType.PACKAGE, manifest);
        this.processDir(sourceDir, FrmEntityType.SEMANTIC_TYPE, manifest);
        this.processDir(sourceDir, FrmEntityType.EVENT_PROTOTYPE, manifest);
        this.processDir(sourceDir, FrmEntityType.SERVICE, manifest);
        this.processDirWithNamespaces(sourceDir, FrmEntityType.ARTIFACT, manifest);
        this.processDirWithNamespaces(sourceDir, FrmEntityType.OBJECT, manifest);
    }

    public void processHtCacheDir(File sourceDir, FrmManifest manifest) throws UtilitiesException, IOException {
        File dir = new File(sourceDir.getAbsolutePath(), FrmEntityType.HTTP_ACCEPTOR.getRelativePath());
        if (dir.exists()) {
            for (String namespace : FileIOUtils.directorySublist(dir.getAbsolutePath(), false)) {
                this.processHttpAcceptorDirWithNamespaces(dir, namespace, manifest);
            }
        }
    }

    public void processRootDir(File workingDir, FrmManifest manifest) throws UtilitiesException, IOException {
        if (this.processDir(workingDir, "", FrmEntityType.WORKING_DIR, manifest, true)) {
            for (String subdir : FileIOUtils.directorySublist(workingDir.getAbsolutePath(), false)) {
                if (ROOT_DIR_EXCLUSIONS.contains(subdir)) continue;
                this.processDirWithNamespaces(workingDir, new File(subdir).getName(), FrmEntityType.WORKING_DIR, manifest);
            }
        }
    }

    private boolean processHttpAcceptorDir(File workingDir, String namespace, FrmManifest manifest) throws UtilitiesException, IOException {
        File[] files;
        File dir = new File(workingDir, namespace);
        if (!dir.exists()) {
            return false;
        }
        this.addDirectory(FrmEntityType.HTTP_ACCEPTOR.getRelativePath() + (String)(!namespace.isEmpty() ? File.separator + namespace : ""), dir);
        Predicate fileInclusionPredicate = this.getPredicate(namespace, FrmEntityType.HTTP_ACCEPTOR, manifest);
        if (fileInclusionPredicate == null) {
            return false;
        }
        for (File file : files = FileIOUtils.directoryList(dir.getAbsolutePath(), "")) {
            String entryName = FrmEntityType.HTTP_ACCEPTOR.getRelativePath() + (String)(!namespace.isEmpty() ? File.separator + namespace : "") + File.separator + file.getName();
            if (!fileInclusionPredicate.check(new FrmEntity(file.getName(), namespace))) continue;
            this.addFile(entryName, file);
        }
        return true;
    }

    public void processDirWithNamespaces(File workingDir, FrmEntityType type, FrmManifest manifest) throws UtilitiesException, IOException {
        this.processDirWithNamespaces(workingDir, "", type, manifest);
    }

    private void processDirWithNamespaces(File workingDir, String namespace, FrmEntityType type, FrmManifest manifest) throws UtilitiesException, IOException {
        if (this.processDir(workingDir, namespace, type, manifest, false)) {
            String separator = !namespace.isEmpty() ? File.separator : "";
            for (String subdir : FileIOUtils.directorySublist(workingDir.getAbsolutePath() + File.separator + type.getRelativePath() + separator + namespace, true)) {
                this.processDirWithNamespaces(workingDir, namespace + separator + new File(subdir).getName(), type, manifest);
            }
        }
    }

    private void processHttpAcceptorDirWithNamespaces(File acceptorDir, String namespace, FrmManifest manifest) throws UtilitiesException, IOException {
        if (this.processHttpAcceptorDir(acceptorDir, namespace, manifest)) {
            String separator = !namespace.isEmpty() ? File.separator : "";
            for (String subdir : FileIOUtils.directorySublist(acceptorDir.getAbsolutePath() + separator + namespace, true)) {
                this.processHttpAcceptorDirWithNamespaces(acceptorDir, namespace + separator + new File(subdir).getName(), manifest);
            }
        }
    }

    private boolean processDir(File workingDir, FrmEntityType type, FrmManifest manifest) throws UtilitiesException, IOException {
        return this.processDir(workingDir, "", type, manifest, false);
    }

    public static FrmEntity convertFrmEntity(FrmEntityType entityType, FrmEntity entity) {
        if (entityType == FrmEntityType.EVENT_PROTOTYPE) {
            entity = new FrmEntity(ImportOperation.convertEventPrototypeFileToId(entity.getName()), entity.getNamespace());
        } else if (entityType == FrmEntityType.MLCACHE) {
            entity = new FrmEntity(new File(entity.getName()).getName(), FrmFileReader.toFrmPath(new File(entity.getName()).getParent()));
        } else if (entityType == FrmEntityType.OBJECT) {
            entity = new FrmEntity(new File(entity.getName()).getName(), FrmFileReader.toFrmPath(new File(entity.getName()).getParent()));
        }
        return entity;
    }

    private boolean processDir(File workingDir, String namespace, FrmEntityType type, FrmManifest manifest, boolean isRootDir) throws UtilitiesException, IOException {
        Predicate fileInclusionPredicate;
        String typePath;
        String string = typePath = isRootDir ? "" : type.getPath(namespace);
        if (type == FrmEntityType.OBJECT && typePath.startsWith(FrmEntityType.EVENT_PROTOTYPE.getRelativePath())) {
            return false;
        }
        File dir = new File(workingDir, typePath);
        if (!dir.exists()) {
            return false;
        }
        boolean dirAdded = isRootDir;
        if (type != FrmEntityType.WORKING_DIR) {
            dirAdded = this.addDir(typePath, dir);
        }
        if ((fileInclusionPredicate = this.getPredicate(namespace, type, manifest)) == null) {
            return false;
        }
        ArrayList<String> subdirectories = new ArrayList<String>();
        subdirectories.add("");
        if (type == FrmEntityType.EVENT_PROTOTYPE) {
            Predicate fileInclusionPredicateFinal = fileInclusionPredicate;
            fileInclusionPredicate = e -> fileInclusionPredicateFinal.check(FrmFileWriter.convertFrmEntity(type, e));
            this.addSubdir(typePath, dir, "AdvisoryDatagramFactory", subdirectories);
            this.addSubdir(typePath, dir, "EventDatagramFactory", subdirectories);
            this.addSubdir(typePath, dir, "ExceptionDatagramFactory", subdirectories);
            this.addSubdir(typePath, dir, "OpaqueDatagramFactory", subdirectories);
        }
        File mnodeObjectDir = new File(workingDir, ManagementNode.NAMESPACE_PATH);
        File mnodeObject = this.excludeMNodeObject && dir.equals(mnodeObjectDir) ? new File(mnodeObjectDir, "ManagementNode.xdo") : null;
        for (String subdirectory : subdirectories) {
            for (File file : FileIOUtils.directoryList(new File(dir, subdirectory).getAbsolutePath(), "")) {
                String noTypeFilename;
                String entryName;
                if (!this.isFileValid(file, isRootDir, mnodeObject) || this.processMnodeObject(workingDir, file, entryName = typePath + (String)(subdirectory.length() > 0 ? subdirectory + File.separator : "") + file.getName())) continue;
                String fullFilename = file.getName();
                String noExtFilename = fullFilename.endsWith(".xdo") ? fullFilename.substring(0, fullFilename.length() - 4) : null;
                String string2 = noTypeFilename = noExtFilename != null && noExtFilename.contains(".") ? noExtFilename.substring(noExtFilename.indexOf(".") + 1) : null;
                if (!fileInclusionPredicate.check(new FrmEntity(fullFilename, namespace)) && (noExtFilename == null || !fileInclusionPredicate.check(new FrmEntity(noExtFilename, namespace))) && (noTypeFilename == null || !fileInclusionPredicate.check(new FrmEntity(noTypeFilename, namespace)))) continue;
                if (this.cache != null) {
                    if (this.addFile(entryName)) continue;
                    this.addFile(entryName, file);
                    continue;
                }
                if (!dirAdded) {
                    dirAdded = this.addDir(typePath, dir);
                }
                this.addFile(entryName, file);
                if (!isRootDir || this.ddxAdded || !file.getName().equals("stdeploy.jar")) continue;
                this.ddxAdded = true;
            }
        }
        return true;
    }

    private boolean processMnodeObject(File workingDir, File file, String entryName) {
        File mnodeObjectFile;
        if (!this.excludeMNodeObject && file.equals(mnodeObjectFile = FrmFileWriter.getMnodeObjectFile(workingDir))) {
            this.updateManagementNodeObject(entryName, mnodeObjectFile);
            return true;
        }
        return false;
    }

    private void updateManagementNodeObject(String entryName, File mnodeObjectFile) {
        try {
            XSerializer serializer = XSerializerFactory.getInstance().getDefaultSerializer();
            if (this.cache != null) {
                RandomAccessFile artifact = this.cache.getEntityAsFile(FrmFileWriter.getCacheRelativePath(entryName));
                byte[] bytes = new byte[(int)artifact.length()];
                artifact.readFully(bytes);
                ManagementNode managementNode = (ManagementNode)serializer.deserialize(bytes);
                this.addMnodeObject(entryName, managementNode, serializer);
            } else {
                ManagementNode managementNode = (ManagementNode)Utils.readObjectFromXML(mnodeObjectFile.getPath());
                this.addMnodeObject(entryName, managementNode, serializer);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            Trace.logError(this, "Updating ManagementNode object failed.");
        }
    }

    private static File getMnodeObjectFile(File workingDir) {
        File mnodeObjectDir = new File(workingDir, ManagementNode.NAMESPACE_PATH);
        return new File(mnodeObjectDir, "ManagementNode.xdo");
    }

    private void addMnodeObject(String entryName, ManagementNode managementNode, XSerializer serializer) throws Exception {
        managementNode.setCheckedOut(true);
        byte[] bytes = serializer.serialize(managementNode).getBytes();
        this.addFile(entryName, bytes);
    }

    private void addSubdir(String typePath, File dir, String subdirName, List<String> result) throws IOException {
        result.add(subdirName);
        this.addDir(typePath + subdirName, new File(dir, subdirName));
    }

    private boolean isFileValid(File file, boolean isRootDir, File mnodeObject) {
        return !(isRootDir && file.equals(this.frmFile) || mnodeObject != null && file.equals(mnodeObject));
    }

    private boolean addDir(String typePath, File dir) throws IOException {
        this.addDirectory(typePath, dir);
        return true;
    }

    private static String getCacheRelativePath(String entryName) {
        int index = entryName.indexOf(File.separator);
        return index != -1 ? entryName.substring(index + 1) : entryName;
    }

    private Predicate getPredicate(String namespace, FrmEntityType type, FrmManifest manifest) {
        boolean excludeAll;
        Set<FrmEntity> includes = manifest.getIncludeEntities().get((Object)type);
        if (includes == null || includes.size() == 0) {
            return null;
        }
        boolean includeAll = this.matchAll(includes, namespace);
        Set<FrmEntity> excludes = manifest.getExcludeEntities().get((Object)type);
        boolean bl = excludeAll = excludes != null && this.matchAll(excludes, namespace);
        if (excludeAll && (includeAll || includes.isEmpty())) {
            return null;
        }
        if (excludeAll && !includeAll && !includes.isEmpty()) {
            return entity -> FrmEntity.contains(includes, entity, type);
        }
        if (includeAll && !excludeAll && FrmFileWriter.noExcludes(excludes)) {
            return entity -> true;
        }
        if (includeAll && !excludeAll && !FrmFileWriter.noExcludes(excludes)) {
            return entity -> excludes == null || !FrmEntity.contains(excludes, entity, type);
        }
        if (!includeAll && !excludeAll) {
            return entity -> FrmEntity.contains(includes, entity, type) && (excludes == null || !FrmEntity.contains(excludes, entity, type));
        }
        return entryName -> true;
    }

    private boolean matchAll(Set<FrmEntity> entities, String namespace) {
        if (entities.contains(FrmManifest.ALL) || entities.contains(new FrmEntity("*", namespace))) {
            return true;
        }
        if (!namespace.isEmpty()) {
            Object subNamespace = "";
            for (String token : StringUtils.split(FrmEntity.unify(namespace), '/')) {
                if (entities.contains(new FrmEntity("*", (String)(subNamespace = (String)subNamespace + token)))) {
                    return true;
                }
                subNamespace = (String)subNamespace + "/";
            }
        }
        return false;
    }

    private static boolean noExcludes(Set<FrmEntity> excludes) {
        return excludes == null || excludes.isEmpty();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.archive.close();
        }
        catch (IOException error) {
            Trace.logError(this, "Unable to close FRM file correctly. " + error.getMessage());
        }
    }

    public void setIgnoreAddFileErrors(boolean ignoreAddFileErrors) {
        this.ignoreAddFileErrors = ignoreAddFileErrors;
    }

    public List<String> getFailedFiles() {
        return this.failedFiles;
    }

    static {
        ROOT_DIR_EXCLUSIONS.add(".tfcache");
        ROOT_DIR_EXCLUSIONS.add(".dscache");
        ROOT_DIR_EXCLUSIONS.add(".htcache");
        ROOT_DIR_EXCLUSIONS.add(".mlcache");
    }

    public static interface FeedbackSender {
        public void send(String var1) throws Exception;
    }

    static interface Predicate {
        public boolean check(FrmEntity var1);
    }
}

