/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.lib.zip.ArchiveEntry;
import com.streamscape.lib.zip.ArchiveInputStream;
import com.streamscape.lib.zip.TarArchiveInputStream;
import com.streamscape.lib.zip.ZipArchiveInputStream;
import com.streamscape.runtime.mf.operation.frm.FrmFile;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class FrmFileReader
extends FrmFile {
    ArchiveInputStream archive;

    public FrmFileReader(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public FrmFileReader(InputStream input) throws IOException {
        this(input, true);
    }

    public FrmFileReader(InputStream input, boolean asZip) {
        this.archive = asZip ? new ZipArchiveInputStream(input) : new TarArchiveInputStream(input);
    }

    public byte[] getFile(String name) throws IOException {
        ArchiveEntry entry;
        name = name.replace(File.separatorChar, '/');
        while ((entry = this.archive.getNextArchiveEntry()) != null) {
            if (!entry.getName().equals(name)) continue;
            return this.read();
        }
        throw new IOException("File '" + name + "' does not exist in Fabric Resource Module.");
    }

    public byte[] read() throws IOException {
        int count;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((count = this.archive.read(this.BUFFER)) > 0) {
            output.write(this.BUFFER, 0, count);
        }
        return output.toByteArray();
    }

    public String getNextEntryPath() throws IOException {
        ArchiveEntry entry = this.archive.getNextArchiveEntry();
        return entry != null ? entry.getName().replace('/', File.separatorChar) : null;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.archive.getNextArchiveEntry();
    }

    public byte[] getNextFile() throws IOException {
        int count;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((count = this.archive.read(this.BUFFER)) > 0) {
            output.write(this.BUFFER, 0, count);
        }
        return output.toByteArray();
    }

    public void extractTo(File targetDir) throws IOException {
        this.extractTo(targetDir, null);
    }

    public void extractTo(File targetDir, Set<String> excludedEntries) throws IOException {
        this.extractTo(targetDir, excludedEntries, null);
    }

    public void extractTo(File targetDir, Set<String> excludedEntries, FileWriter errorLog) throws IOException {
        ArchiveEntry archiveEntry;
        targetDir = targetDir.getCanonicalFile();
        HashSet<Path> excludedPaths = null;
        if (excludedEntries != null || this.excludeMNodeObject) {
            excludedPaths = new HashSet<Path>();
            if (this.excludeMNodeObject) {
                FrmFileReader.addExcludedPath(targetDir, ManagementNode.OBJECT_PATH, excludedPaths);
            }
            if (excludedEntries != null) {
                for (String string : excludedEntries) {
                    FrmFileReader.addExcludedPath(targetDir, string, excludedPaths);
                }
            }
        }
        boolean isCorrupted = true;
        while ((archiveEntry = this.archive.getNextArchiveEntry()) != null) {
            isCorrupted = false;
            if (archiveEntry.isDirectory()) {
                File dir = new File(targetDir, archiveEntry.getName().replace('/', File.separatorChar)).getCanonicalFile();
                if (this.isExcluded(dir, excludedPaths) || dir.exists()) continue;
                dir.mkdirs();
                continue;
            }
            File resultFile = new File(targetDir, archiveEntry.getName().replace('/', File.separatorChar)).getCanonicalFile();
            if (this.isExcluded(resultFile, excludedPaths)) continue;
            if (!resultFile.getParentFile().exists()) {
                resultFile.getParentFile().mkdirs();
            }
            try {
                int count;
                FileOutputStream output = new FileOutputStream(resultFile);
                while ((count = this.archive.read(this.BUFFER)) > 0) {
                    ((OutputStream)output).write(this.BUFFER, 0, count);
                }
                ((OutputStream)output).close();
            }
            catch (IOException exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Extracting file '" + resultFile.getAbsolutePath() + "' skipped.");
                if (errorLog == null) continue;
                errorLog.write("\nERROR: " + exception.getMessage() + "\n");
                errorLog.write("ERROR: Extracting file '" + resultFile.getAbsolutePath() + "' skipped.\n");
            }
        }
        if (isCorrupted) {
            throw new IOException("Archive is empty or corrupted, or password is not valid.");
        }
    }

    private static void addExcludedPath(File targetDir, String entryName, Set<Path> result) {
        result.add(Paths.get(targetDir.getAbsolutePath(), entryName).normalize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isExcluded(File file, Set<Path> excludedPaths) {
        Path path = file.toPath();
        if (excludedPaths == null) return false;
        if (excludedPaths.contains(path)) return true;
        if (!excludedPaths.stream().anyMatch(path::startsWith)) return false;
        return true;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.archive.close();
        }
        catch (IOException error) {
            Trace.logError(this, "Unable to close FRM file correctly. " + error.getMessage());
        }
    }

    public static String toFrmPath(String path) {
        return path.replace(File.separatorChar, '/');
    }
}

