/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.zip.zip4j.core.ZipFile;
import com.streamscape.lib.zip.zip4j.exception.ZipException;
import com.streamscape.lib.zip.zip4j.progress.ProgressMonitor;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;

public class FrmFile
implements AutoCloseable {
    public static final String FRM_FILE_EXT = ".frm";
    public static final String MNODE_SCRIPT = "mnode.slang";
    public static final String TNODE_SCRIPT = "tnode.slang";
    public static final String MANIFEST = "manifest.frmm";
    public static final String BUILD_MANIFEST = "build.mf";
    public static final char FRM_FILE_SEPARATOR = '/';
    protected byte[] BUFFER = new byte[65536];
    protected boolean excludeMNodeObject = true;

    FrmFile() {
    }

    @Override
    public void close() {
        this.BUFFER = null;
    }

    public void setExcludeMNodeObject(boolean value) {
        this.excludeMNodeObject = value;
    }

    public static void extract(File frmFile, File targetDir) throws IOException {
        FrmFile.extract(frmFile, targetDir, true, null, null);
    }

    public static void extract(File frmFile, File targetDir, boolean asZip, String password, Consumer<Integer> progress) throws IOException {
        if (asZip) {
            try {
                ZipFile zipFile = new ZipFile(frmFile);
                if (zipFile.isEncrypted()) {
                    if (password == null) {
                        throw new IOException("ZIP is encrypted. Password must be specified.");
                    }
                    zipFile.setPassword(password);
                }
                if (progress != null) {
                    ProgressMonitor progressMonitor = zipFile.getProgressMonitor();
                    FabricThreadManager.getInstance().createThread("SLANG.ZIPProgressMonitor", "Handles unpacking process.", () -> {
                        try {
                            Thread.sleep(500L);
                            while (progressMonitor.getState() == 1) {
                                int done = progressMonitor.getPercentDone();
                                progress.accept(done);
                                if (done >= 99) {
                                    progress.accept(100);
                                    break;
                                }
                                Thread.sleep(500L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }).start();
                }
                zipFile.extractAll(targetDir.toString());
            }
            catch (ZipException exception) {
                Trace.logException(FrmFile.class, exception, true);
                if (exception.getMessage().contains("Wrong Password")) {
                    throw new IOException("Wrong password.");
                }
                throw new IOException("Failed to unzip file: " + frmFile.toString());
            }
        }
        try (FrmFileReader reader = new FrmFileReader(new FileInputStream(frmFile), asZip);){
            reader.extractTo(targetDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractGzip(File frmFile, File targetDir) throws Exception {
        File tmpFile = new File(frmFile.getParentFile(), UUID.randomUUID().toString());
        try {
            try (GZIPInputStream stream = new GZIPInputStream(new FileInputStream(frmFile));
                 FileOutputStream tmpOut = new FileOutputStream(tmpFile);){
                FileIOUtils.copy((InputStream)stream, (OutputStream)tmpOut);
            }
            try (FrmFileReader reader = new FrmFileReader(new FileInputStream(tmpFile), false);){
                reader.extractTo(targetDir);
            }
        }
        finally {
            tmpFile.delete();
        }
    }
}

