/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public enum FrmEntityType {
    CLIENT_FACTORY(".tfcache/clients", ".cfo", "client-factory", "client factory"),
    JDBC_FACTORY(".tfcache/jdbc", ".dfo", "db-factory", "db connection factory"),
    TRANSPORT_FACTORY(".tfcache/transports", ".tfo", "msg-factory", "message factory"),
    SERVICE(".tfcache/services", ".sco", "service", "service"),
    PACKAGE(".tfcache/pkg", ".pkg", "package", "package"),
    ARCHIVE(".tfcache/lib", ".jar", "archive", "archive"),
    EXT_ARCHIVE(".tfcache/ext", ".jar", "ext-archive", "extension archive"),
    SEMANTIC_TYPE(".tfcache/types", ".type", "semantic-type", "semantic type"),
    GVAR(".tfcache/globals", "", "gvar", "global variable"),
    OBJECT(".tfcache/objects", "", "object", "object"),
    ARTIFACT(".tfcache/artifacts", "", "artifact", "artifact"),
    DATASPACE(".dscache", "", "dataspace", "dataspace"),
    HTTP_ACCEPTOR(".htcache", "", "http-acceptor", "HTTP acceptor"),
    WORKING_DIR("", "", "working-dir", "working directory"),
    FILE_DESCRIPTOR(FrmEntityType.OBJECT.relativePath + "/file/descriptor", ".xdo", "file-descriptor", "file descriptor"),
    JOB(FrmEntityType.OBJECT.relativePath + "/sys/scheduler/jobs", ".xdo", "job", "job"),
    TASKLIST(FrmEntityType.OBJECT.relativePath + "/sys/scheduler/tasklists", ".xdo", "tasklist", "task list"),
    EVENT_PROTOTYPE(FrmEntityType.OBJECT.relativePath + "/sys/datagram/prototype", ".xdo", "event-prototype", "event prototype"),
    ALL("N/A", "", "all", "all"),
    SEMANTIC_TYPES_WITH_ANCESTOR("N/A", "", "semantic-types-with-ancestor", "semantic type"),
    MLCACHE(".mlcache", "", "mlcache", "mlcache"),
    FACETS("", "", "facets", "facets"),
    ASPECTS("", "", "aspects", "aspects");

    private static final Map<String, FrmEntityType> PATH_TO_TYPE;
    private static final Map<String, FrmEntityType> SLANG_NAME_TO_TYPE;
    private String relativePath;
    private String extension;
    private String slangName;
    private String printName;

    private FrmEntityType(String relativePath, String extension, String slangName, String printName) {
        this.relativePath = relativePath;
        this.extension = extension;
        this.slangName = slangName;
        this.printName = printName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getExtension() {
        return this.extension;
    }

    public String stripExtension(String entityName) {
        if (this != ARCHIVE && this != EXT_ARCHIVE && entityName.endsWith(this.extension)) {
            return entityName.substring(0, entityName.length() - this.extension.length());
        }
        return entityName;
    }

    public String getSlangName() {
        return this.slangName;
    }

    public String getPrintName() {
        return this.printName;
    }

    public static FrmEntityType pathToType(String path) {
        return PATH_TO_TYPE.get(path);
    }

    public static FrmEntityType fromEntityPath(String path) {
        FrmEntityType type = PATH_TO_TYPE.get(path = FrmEntityType.toEntityOSPath(path));
        if (type != null) {
            return type;
        }
        for (FrmEntityType value : FrmEntityType.values()) {
            if (!path.startsWith(value.getRelativePath()) || value.getExtension().length() != 0 && !path.endsWith(value.getExtension()) || type != null && type.getRelativePath().length() >= value.getRelativePath().length()) continue;
            type = value;
        }
        if (type == null) {
            type = ALL;
        }
        return type;
    }

    public static FrmEntityType slangNameToType(String slangName) {
        return SLANG_NAME_TO_TYPE.get(slangName.toLowerCase());
    }

    public File getDirectory(File parent) {
        return new File(parent, this.getRelativePath());
    }

    String getPath(String namespace) {
        return (String)(this == WORKING_DIR ? namespace : this.getRelativePath() + (String)(!namespace.isEmpty() ? File.separator + namespace : "")) + File.separator;
    }

    public static String toEntityOSPath(String path) {
        path = path.replace('/', File.separatorChar);
        while (path.startsWith(String.valueOf(File.separatorChar))) {
            path = path.substring(1);
        }
        return path;
    }

    static {
        PATH_TO_TYPE = new HashMap<String, FrmEntityType>();
        SLANG_NAME_TO_TYPE = new HashMap<String, FrmEntityType>();
        for (FrmEntityType type : FrmEntityType.values()) {
            type.relativePath = type.relativePath.replace('/', File.separatorChar);
            PATH_TO_TYPE.put(type.getRelativePath(), type);
            SLANG_NAME_TO_TYPE.put(type.getSlangName(), type);
        }
    }
}

