/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DropFrmManifestOperation
extends AbstractFrmOperation<RuntimeContext> {
    public static final String NAME = "drop frm manifest";

    public DropFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP FRM MANIFEST").addActionParameter(new IdentifierParameter("ManifestName"));
        this.syntax.setDescription("Drops the specified Fabric Resource Module manifest in the current node.");
        this.syntax.setExamples("drop frm manifest TestManifest");
        this.syntax.addCompletionCommand("list frm manifests");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ManifestName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String filePath = "resources/" + definition.getManifestName() + ".frmm";
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile(filePath)) {
            return new SLResponse("Manifest not found.", false);
        }
        ((RuntimeContext)this.callable).getRepositoryAccessor().deleteFile(filePath);
        return new SLResponse();
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    String manifest = rowSet.getString(1);
                    completions.add(manifest);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String moduleName;

        public Definition(String moduleName) {
            super(DropFrmManifestOperation.NAME);
            this.moduleName = moduleName;
        }

        public String getManifestName() {
            return this.moduleName;
        }
    }
}

