/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.zip.ArchiveEntry;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Function;

public class DescribeFrmOperation<T extends SLCallable>
extends AbstractFrmOperation<T> {
    public static final String NAME = "describe frm";

    public DescribeFrmOperation(Function<String, AbstractParameter> pathParameterSupplier) {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE FRM").addParameter(pathParameterSupplier.apply("FrmPath"));
        this.syntax.addModifier(((ChoiceModifier)new ChoiceModifier(false).setSyntaxHint(SyntaxHint.SPACE)).addPossibleValues("ENTRIES", "MANIFEST", "BUILD MANIFEST"));
        this.syntax.setDescription("Describes the specified Fabric Resource Module file.");
        this.syntax.setExamples("describe frm './myfrm.frm'\ndescribe frm './myfrm.frm' entries\ndescribe frm './myfrm.frm' build manifest");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("FrmPath").getValue(), statement.existsModifier("ENTRIES"), statement.existsModifier("MANIFEST"), statement.existsModifier("BUILD MANIFEST"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        try (FileSystem fileSystem = new FileSystemProvider(this.callable instanceof RuntimeContext ? (RuntimeContext)this.callable : null).createFileSystem(this.callable instanceof RuntimeContext ? session : null, definition.frmPath);){
            SLResponse sLResponse;
            block13: {
                if (!fileSystem.exists(definition.frmPath)) {
                    throw new Exception("File not found.");
                }
                InputStream inputStream = fileSystem.open(definition.frmPath);
                try {
                    FrmFileReader reader = new FrmFileReader(new BufferedInputStream(inputStream, 0x400000));
                    sLResponse = this.describeFrm(fileSystem, reader, definition);
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return sLResponse;
        }
    }

    private SLResponse describeFrm(FileSystem fileSystem, FrmFileReader reader, Definition definition) throws Exception {
        RowSet rowSet = null;
        if (definition.manifest) {
            ArchiveEntry entry;
            while ((entry = reader.getNextEntry()) != null) {
                if (!entry.getName().endsWith("manifest.frmm")) continue;
                return new SLResponse(new String(reader.read()));
            }
            throw new Exception("Manifest not found in FRM file.");
        }
        if (definition.buildManifest) {
            ArchiveEntry entry;
            while ((entry = reader.getNextEntry()) != null) {
                if (!entry.getName().endsWith("build.mf")) continue;
                return new SLResponse(new String(reader.read()));
            }
            throw new Exception("Build manifest not found in FRM file.");
        }
        if (definition.entries) {
            Object entry;
            ArrayList<ArchiveEntry> entries = new ArrayList<ArchiveEntry>();
            FrmManifest manifest = null;
            while ((entry = reader.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                entries.add((ArchiveEntry)entry);
                if (!entry.getName().endsWith("manifest.frmm")) continue;
                manifest = (FrmManifest)DescribeFrmOperation.getSerializer().deserialize(reader.read());
            }
            rowSet = new RowSet(DescribeFrmOperation.createResultDescriptor("Entry Name", "Entry Type", "Size"));
            for (ArchiveEntry entry2 : entries) {
                DescribeFrmOperation.addValues(rowSet, new Object[]{FrmFileReader.toFrmPath(entry2.getName()), FrmEntityType.fromEntityPath(entry2.getName()), SizeUnit.convertToBestFractional(entry2.getSize(), SizeUnit.BYTES).toStringWithPrecision(2)});
            }
        } else {
            rowSet = new RowSet(DescribeFrmOperation.createSimpleResultDescriptor());
            DescribeFrmOperation.addValues(rowSet, "File Name", new File(definition.frmPath).getName());
            DescribeFrmOperation.addValues(rowSet, "File Size", SizeUnit.convertToBestFractional(fileSystem.getInfo(definition.frmPath).getSize(), SizeUnit.BYTES).toStringWithPrecision(2));
            boolean containsManifest = false;
            boolean containsBuildManifest = false;
            int entriesCount = 0;
            ArchiveEntry entry = null;
            while ((entry = reader.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ++entriesCount;
                containsManifest = containsManifest || entry.getName().endsWith("manifest.frmm");
                containsBuildManifest = containsBuildManifest || entry.getName().endsWith("build.mf");
            }
            DescribeFrmOperation.addValues(rowSet, "Entries Count", entriesCount);
            DescribeFrmOperation.addValues(rowSet, "Contains FRM Manifest", containsManifest);
            DescribeFrmOperation.addValues(rowSet, "Contains Build Manifest", containsBuildManifest);
        }
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String frmPath;
        private final boolean entries;
        private final boolean manifest;
        private boolean buildManifest;

        public Definition(String frmPath, boolean entries, boolean manifest, boolean buildManifest) {
            super(DescribeFrmOperation.NAME);
            this.frmPath = frmPath;
            this.entries = entries;
            this.manifest = manifest;
            this.buildManifest = buildManifest;
        }
    }
}

