/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractDescribeFrmManifestOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import java.util.List;

public class DescribeFrmManifestOperation
extends AbstractDescribeFrmManifestOperation<RuntimeContext> {
    public static final String NAME = "describe frm manifest";

    public DescribeFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE FRM MANIFEST").addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().setSyntaxHint(SyntaxHint.SPACE)).addParameter(new LocalPathParameter("ManifestPath"))).addParameter(new IdentifierParameter("ManifestName")));
        this.syntax.setDescription("Describes the specified Fabric Resource Module manifest.");
        this.syntax.setExamples("describe frm manifest TestManifest\ndescribe frm manifest 'c:/StreamScape/TestManifest.frmm'");
        this.syntax.addCompletionCommand("list frm manifests");
    }

    @Override
    protected byte[] getManifest(String name) throws Exception {
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile("resources")) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().createDirectory("resources");
        }
        String filePath = "resources/" + name + ".frmm";
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile(filePath)) {
            throw new Exception("Manifest not found.");
        }
        return ((RuntimeContext)this.callable).getRepositoryAccessor().getFileContentBytes(filePath);
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    completions.add(rowSet.getString(1));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }
}

