/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractCreateFrmManifestOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.Map;
import java.util.Set;

public class CreateFrmManifestOperation
extends AbstractCreateFrmManifestOperation<RuntimeContext> {
    public static final String NAME = "create frm manifest";

    public CreateFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE FRM MANIFEST").addActionParameter(new IdentifierParameter("ManifestName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("EXPIRATION").setRequired(false)).addParameter(new NumericParameter("expiration"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addParameter(((SetParameter)new SetParameter("OperationsSet").setRequired(false)).addParameter(new EnumParameter("OperationType").addPossibleValue("exclude").addPossibleValue("include").setCaseSensitive(false)).addParameter(this.createEntityTypeParameter()).addParameter(new ExpressionParameter("EntityName")).addParameter((AbstractParameter)new StringParameter("EntityNamespace").setRequired(false)));
        this.syntax.setDescription("Creates a new Fabric Resource Module manifest.\n\nAsterisk sign (*) can be used to refer to all entities of a particular type (e.g. all services or all JDBC factories).\nFor entities which support namespace (artifact, object) or subdirectories (working_dir) asterisk represents all objects\nwhich this namespace (or subdirectory) includes.\nFor HTTP_ACCEPTOR type, entity name should refer to the acceptor name and entity namespace can contain namespace\nalong with entity name. E.g. the rule (exclude http_acceptor Default 'webapps') specifies that all entities\nof Default HTTP acceptor in 'webapps' namespace will be excluded from the FRM.\n\nType ALL is used only in the global rules, such as (include all *) and (exclude all *).\nRule (include all *) means that the result FRM will contain all files from the working directory.\nRule (exclude all *) means that the result FRM will contain nothing.\n\nDefault manifest includes all files from .tfcache, .dscache and .htcache, but does not include other files from the working directory.\nTo generate FRM containing only few specific entities, the rule (exclude all *) can be used in a manifest.\nE.g. the rule (exclude all *, include service *) specified that the FRM will contain only service entities.\nDataspace FLOB files will be included into frm if node is running and FLOB directory located under working directory only.\n\nManifest is placed in the 'artifacts/resources' directory of the repository.");
        this.syntax.setExamples("create frm manifest TestManifest\ncreate frm manifest TestManifest (exclude service *)\ncreate frm manifest TestManifest (exclude object * 'db')\ncreate frm manifest TestManifest (exclude http-acceptor Default)\ncreate frm manifest TestManifest (exclude http-acceptor Default 'webapps')\ncreate frm manifest TestManifest (exclude all *, include service *)\ncreate frm manifest TestManifest (include working-dir *)\ncreate frm manifest TestManifest (exclude all *, include semantic-types-with-ancestor mytypes)\ncreate frm manifest TestManifest (exclude all *, include event-prototype my.event)\ncreate frm manifest TestManifest (include working-dir * 'subdir')\ncreate frm manifest TestManifest (include mlcache *)\ncreate frm manifest TestManifest (include mlcache TXCluster)\ncreate frm manifest TestManifest (include mlcache *, exclude mlcache TXCluster)\ncreate frm manifest TestManifest (include object HTTPRequest.myRequest.xdo 'http/request/MyDataspace_docs')\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = (Definition)super.convertDslToSl(statement);
        if (statement.existsModifier("EXPIRATION")) {
            definition.setExpiration(Long.valueOf(statement.getParameter("expiration").getValue()));
        }
        if (statement.existsParameter("FrmManifestPath")) {
            definition.setPath(statement.getParameter("FrmManifestPath").getValue());
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile("resources")) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().createDirectory("resources");
        }
        String filePath = "resources/" + definition.getManifestName() + ".frmm";
        if (((RuntimeContext)this.callable).getRepositoryAccessor().existsFile(filePath)) {
            return new SLResponse("Manifest '" + definition.getManifestName() + "' already exists.", false);
        }
        ((RuntimeContext)this.callable).getRepositoryAccessor().createFile(filePath, CreateFrmManifestOperation.getSerializer().serialize(this.getManifest(statement, session)).getBytes(), definition.getExpiration());
        return new SLResponse();
    }

    @Override
    protected AbstractCreateFrmManifestOperation.Definition createDefinition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
        return new Definition(manifestName, hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
    }

    public static class Definition
    extends AbstractCreateFrmManifestOperation.Definition {
        protected Definition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
            super(CreateFrmManifestOperation.NAME, manifestName, hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
        }
    }
}

