/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.ds.CheckpointManager;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.loader.Helper;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dataspace.Store;
import com.streamscape.sef.dispatcher.AbstractBackupNodeOperation;
import com.streamscape.sef.dispatcher.AbstractFrmNodeOperation;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.DSLStatement;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BackupNodeOperation
extends AbstractBackupNodeOperation<RuntimeContext> {
    private static final String NAME = "backup";
    private static final String ALIAS = "backup node";
    private static final Field STORE_FIELD;

    public BackupNodeOperation() {
        super(NAME, ALIAS);
        this.syntax.setDescription("Backs up the current node into the Fabric Resource Module file.");
        this.syntax.setExamples("backup at 'C:/Streamscape/resources/Node.frm'\nbackup manifest TestManifest at 'C:/Streamscape/resources/Node.frm' no data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SLResponse execute(AbstractFrmNodeOperation.Definition statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.checkFullPathAllowed(session.getSLSessionData().getSLFileSessionContext() == SLFileSessionContext.SERVER && new File(definition.getFrmPath()).isAbsolute());
        File workingDir = new File(((RuntimeContext)this.callable).getStartupDir());
        File frmFile = new File(workingDir, "tmp.frm");
        frmFile.delete();
        try {
            this.generateFrm(definition, session, workingDir, BackupNodeOperation.getManifest((RuntimeContext)this.callable, definition.getManifestName()), frmFile);
            if (!definition.isTransient) {
                BackupNodeOperation.downloadFrm(session, frmFile, BackupNodeOperation.createFrmPath(definition.getFrmPath()));
            }
        }
        finally {
            if (!definition.isTransient) {
                frmFile.delete();
            }
        }
        Utils.sleep(100L);
        return new SLResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFrm(Definition definition, MFSession session, File workingDir, FrmManifest manifest, File frmFile) throws Exception {
        OutputStream output = null;
        File manifestFile = null;
        try {
            FrmFileWriter writer;
            block37: {
                this.raiseSLMessage("\nGenerating Resource Module...\n", session);
                output = BackupNodeOperation.openFrmOutputStream(frmFile);
                manifestFile = new File(workingDir, "manifest.frmm");
                Utils.writeObjectToXML(manifest, manifestFile.getAbsolutePath());
                writer = new FrmFileWriter(frmFile.getAbsolutePath(), output, true, definition.getPassword());
                if (definition.isTransient) {
                    writer.setExcludeMNodeObject(false);
                }
                writer.setIgnoreAddFileErrors(true);
                this.raiseSLMessage("\nProcessing working directory...\n", session);
                writer.processRootDir(workingDir, manifest);
                String ddxLocation = System.getProperty("streamscape.runtime.deployment.dir");
                if (ddxLocation != null) {
                    writer.addDeploymentDescriptor(new File(ddxLocation), message -> this.raiseSLMessage(message, session));
                }
                this.raiseSLMessage("\nProcessing .tfcache directory...\n", session);
                TFCache cache = Helper.getTfCache();
                if (cache == null) {
                    throw new Exception("Unable to get access to TFCache.");
                }
                try {
                    writer.setTFCache(cache);
                    cache.beginXLocked((FabricComponent)this.callable, 2000L);
                    writer.processTfCache(workingDir, manifest, cache);
                    cache.endXLocked();
                    writer.setTFCache(null);
                }
                finally {
                    if (cache.inXact()) {
                        cache.abortXLocked();
                    }
                }
                this.raiseSLMessage("\nProcessing .dscache directory...\n", session);
                ArrayList<String> flobLocations = new ArrayList<String>();
                if (!definition.isWithoutData()) {
                    try (Connection connection = ((RuntimeContext)this.callable).getDataspaceManager().getJDBCConnection("SYS_FLOBS", session.getOwner().getSecurityContext());){
                        Statement statement = connection.createStatement();
                        statement.execute("select LOCATION_PATH from FLOB_LOCATIONS");
                        ResultSet resultSet = statement.getResultSet();
                        while (resultSet.next()) {
                            flobLocations.add(resultSet.getString(1));
                        }
                    }
                    catch (Exception exception) {
                        this.raiseSLMessageError(exception, session);
                        this.raiseSLMessageError("Extracting dataspace FLOBs failed.\n", session);
                    }
                }
                Store store = (Store)STORE_FIELD.get(((RuntimeContext)this.callable).getDataspaceManager());
                boolean datastoreLocked = false;
                CheckpointManager checkpointManager = ((DataspaceStore)store).getCheckpointManager();
                try {
                    FabricThread checkpointThread = FabricThreadManager.getInstance().createThread("SLANG.BackupNode:Checkpoint", "Performs checkpoint.", () -> checkpointManager.getCheckpointExecutor().executeCheckpoint(null, definition.isWithoutDefrag(), false, 20000L));
                    CountDownLatch lockWait = store.lock();
                    if (lockWait == null) {
                        this.raiseSLMessageError("Extracting dataspace data failed.\n", session);
                        break block37;
                    }
                    try {
                        datastoreLocked = true;
                        checkpointThread.start();
                        if (lockWait.await(60000L, TimeUnit.MILLISECONDS)) {
                            if (definition.isWithoutData()) {
                                writer.extractDataspaceMetadata(workingDir);
                            } else {
                                writer.processDirWithNamespaces(workingDir, FrmEntityType.DATASPACE, manifest);
                                writer.extractDataspaceFlobs(workingDir, flobLocations, manifest);
                            }
                        } else {
                            this.raiseSLMessageError("Extracting dataspace data failed.\n", session);
                        }
                    }
                    finally {
                        store.unlock();
                        datastoreLocked = false;
                    }
                    if (checkpointThread.isRunning()) {
                        checkpointThread.join();
                    }
                }
                finally {
                    if (datastoreLocked) {
                        store.unlock();
                    }
                }
            }
            this.raiseSLMessage("\nProcessing .htcache directory...\n", session);
            writer.processHtCacheDir(workingDir, manifest);
            BackupNodeOperation.addScripts(definition, session, writer);
            writer.close();
            this.raiseSLMessage("\nResource Module generated.\n", session);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (manifestFile != null) {
                manifestFile.delete();
            }
        }
    }

    @Override
    protected Definition createDefinition(DSLStatement statement, String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
        return new Definition(frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
    }

    static {
        try {
            STORE_FIELD = DataspaceManager.class.getDeclaredField("store");
            STORE_FIELD.setAccessible(true);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Initialization of BackupNodeOperation failed.");
        }
    }

    public static class Definition
    extends AbstractBackupNodeOperation.Definition {
        private boolean isTransient = false;

        Definition(String frmPath, boolean isAsync, String manifestName, boolean withoutData, boolean withoutDefrag, String password) {
            super(BackupNodeOperation.NAME, null, frmPath, isAsync, manifestName, withoutData, withoutDefrag, password);
        }

        public Definition(AbstractBackupNodeOperation.Definition other) {
            this(other.getFrmPath(), other.isAsync(), other.getManifestName(), other.isWithoutData(), other.isWithoutDefrag(), other.getPassword());
            this.setMnodeScript(other.getMnodeScript());
            this.setTnodeScript(other.getTnodeScript());
            this.isTransient = true;
        }
    }
}

