/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlterFrmManifestOperation
extends AbstractFrmOperation<RuntimeContext> {
    public static final String NAME = "alter frm manifest";

    public AlterFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER FRM MANIFEST").addActionParameter(new IdentifierParameter("ManifestName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EXPIRATION", false).addParameter(new NumericParameter("expiration"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addParameter(((SetParameter)new SetParameter("OperationsSet").setRequired(false)).addParameter(new EnumParameter("OperationType").addPossibleValue("exclude").addPossibleValue("include").setCaseSensitive(false)).addParameter(this.createEntityTypeParameter()).addParameter(new ExpressionParameter("EntityName")).addParameter((AbstractParameter)new StringParameter("EntityNamespace").setRequired(false)));
        this.syntax.setDescription("Updates the specified Fabric Resource Module manifest.\n\nAsterisk sign (*) can be used to refer to all entities of a particular type (e.g. all services or all JDBC factories).\nFor entities which support namespace (artifact, object) or subdirectories (working_dir) asterisk represents all objects\nwhich this namespace (or subdirectory) includes.\nFor HTTP_ACCEPTOR type, entity name should refer to the acceptor name and entity namespace can contain namespace\nalong with entity name. E.g. the rule (exclude http_acceptor Default 'webapps') specifies that all entities\nof Default HTTP acceptor in 'webapps' namespace will be excluded from the FRM.\n\nType ALL is used only in the global rules, such as (include all *) and (exclude all *).\nRule (include all *) means that the result FRM will contain all files from the working directory.\nRule (exclude all *) means that the result FRM will contain nothing.\n\nDefault manifest includes all files from .tfcache, .dscache and .htcache, but does not include other files from the working directory.\nTo generate FRM containing only few specific entities, the rule (exclude all *) can be used in a manifest.\nE.g. the rule (exclude all *, include service *) specified that the FRM will contain only service entities.\nDataspace FLOB files will be included into frm if node is running and FLOB directory located under working directory only.\n\nManifest is placed in the 'artifacts/resources' directory of the repository.");
        this.syntax.setExamples("alter frm manifest TestManifest (exclude service 'TestService.Service1')\nalter frm manifest TestManifest (exclude service *,exclude gvar *)\nalter frm manifest TestManifest (exclude http-acceptor Default)\nalter frm manifest TestManifest (exclude object 'sys/datagram/prototype/EventDatagramFactory/*')\nalter frm manifest TestManifest (include working-dir *)\nalter frm manifest TestManifest (include working-dir * 'subdir')");
        this.syntax.addCompletionCommand("list frm manifests");
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    completions.add(rowSet.getString(1));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        boolean hasGlobalInclude = false;
        boolean hasGlobalExclude = false;
        HashMap<FrmEntityType, Set<FrmEntity>> includeEntities = new HashMap<FrmEntityType, Set<FrmEntity>>();
        HashMap<FrmEntityType, Set<FrmEntity>> excludeEntities = new HashMap<FrmEntityType, Set<FrmEntity>>();
        StatementSetValue operations = statement.getSet("OperationsSet");
        if (operations.isPresent()) {
            for (int i = 0; i < operations.size(); ++i) {
                Set<FrmEntity> entities;
                FrmEntity entity;
                FrmEntityType type;
                StatementValueList entityValue = operations.getElement(i);
                String operationType = entityValue.getParameter("OperationType").getValue();
                String entityName = entityValue.getParameter("EntityName").getValue();
                String namespace = "";
                if (entityValue.getParameter("EntityNamespace").isPresent()) {
                    namespace = entityValue.getParameter("EntityNamespace").getValue();
                }
                if ((type = FrmEntityType.slangNameToType(entityValue.getParameter("EntityType").getValue())) == FrmEntityType.ALL) {
                    if (!entityName.equals("*")) continue;
                    if (operationType.equalsIgnoreCase("include")) {
                        hasGlobalInclude = true;
                        continue;
                    }
                    hasGlobalExclude = true;
                    continue;
                }
                if (type == FrmEntityType.HTTP_ACCEPTOR) {
                    int index;
                    String context = entityName;
                    entityName = "*";
                    if (namespace.length() > 0 && (index = namespace.lastIndexOf(47)) != -1 && index != namespace.trim().length() - 1) {
                        namespace = entityName.substring(0, index);
                        entityName = entityName.substring(index + 1);
                    }
                    entity = new FrmEntity(entityName, namespace);
                    entity.setContext(context);
                } else {
                    entity = new FrmEntity(entityName, namespace);
                }
                if (operationType.equalsIgnoreCase("include")) {
                    entities = (HashSet<FrmEntity>)includeEntities.get((Object)type);
                    if (entities == null) {
                        entities = new HashSet<FrmEntity>();
                        includeEntities.put(type, entities);
                    }
                    entities.add(entity);
                    continue;
                }
                entities = (Set)excludeEntities.get((Object)type);
                if (entities == null) {
                    entities = new HashSet();
                    excludeEntities.put(type, entities);
                }
                entities.add(entity);
            }
        }
        if (statement.existsModifier("EXPIRATION")) {
            return new Definition(statement.getParameter("ManifestName").getValue(), hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities, Long.valueOf(statement.getParameter("expiration").getValue()));
        }
        return new Definition(statement.getParameter("ManifestName").getValue(), hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile("resources")) {
            return new SLResponse("Resource artifacts area does not exist.", false);
        }
        String filePath = "resources/" + definition.getManifestName() + ".frmm";
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile(filePath)) {
            return new SLResponse("Manifest not found.", false);
        }
        XSerializer serializer = AlterFrmManifestOperation.getSerializer();
        FrmManifest manifest = (FrmManifest)serializer.deserialize(((RuntimeContext)this.callable).getRepositoryAccessor().getFileContentBytes(filePath));
        if (definition.hasGlobalInclude) {
            if (!definition.hasGlobalExclude) {
                manifest.includeAll();
            }
        } else if (definition.hasGlobalExclude) {
            manifest.excludeAll();
        }
        for (Map.Entry<FrmEntityType, Set<FrmEntity>> entities : definition.getIncludeEntities().entrySet()) {
            for (FrmEntity entity : entities.getValue()) {
                manifest.includeEntity(entities.getKey(), entity);
            }
        }
        for (Map.Entry<FrmEntityType, Set<FrmEntity>> entities : definition.getExcludeEntities().entrySet()) {
            for (FrmEntity entity : entities.getValue()) {
                manifest.excludeEntity(entities.getKey(), entity);
            }
        }
        ((RuntimeContext)this.callable).getRepositoryAccessor().updateFile(filePath, serializer.serialize(manifest).getBytes());
        if (definition.getExpiration() > 0L) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().setFileExpiration(filePath, definition.getExpiration());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String manifestName;
        private long expiration = 0L;
        private boolean hasGlobalInclude;
        private Map<FrmEntityType, Set<FrmEntity>> includeEntities;
        private boolean hasGlobalExclude;
        private Map<FrmEntityType, Set<FrmEntity>> excludeEntities;

        public Definition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
            this(manifestName, hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities, 0L);
        }

        public Definition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities, long expiration) {
            super(AlterFrmManifestOperation.NAME);
            this.manifestName = manifestName;
            this.expiration = expiration;
            this.includeEntities = includeEntities;
            this.excludeEntities = excludeEntities;
        }

        public String getManifestName() {
            return this.manifestName;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public boolean hasGlobalInclude() {
            return this.hasGlobalInclude;
        }

        public Map<FrmEntityType, Set<FrmEntity>> getIncludeEntities() {
            return this.includeEntities;
        }

        public Map<FrmEntityType, Set<FrmEntity>> getExcludeEntities() {
            return this.excludeEntities;
        }

        public boolean hasGlobalExclude() {
            return this.hasGlobalExclude;
        }
    }
}

