/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.frm;

import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCreateFrmManifestOperation<T extends SLCallable>
extends AbstractFrmOperation<T> {
    protected static final String DESCRIPTION = "Asterisk sign (*) can be used to refer to all entities of a particular type (e.g. all services or all JDBC factories).\nFor entities which support namespace (artifact, object) or subdirectories (working_dir) asterisk represents all objects\nwhich this namespace (or subdirectory) includes.\nFor HTTP_ACCEPTOR type, entity name should refer to the acceptor name and entity namespace can contain namespace\nalong with entity name. E.g. the rule (exclude http_acceptor Default 'webapps') specifies that all entities\nof Default HTTP acceptor in 'webapps' namespace will be excluded from the FRM.\n\nType ALL is used only in the global rules, such as (include all *) and (exclude all *).\nRule (include all *) means that the result FRM will contain all files from the working directory.\nRule (exclude all *) means that the result FRM will contain nothing.\n\nDefault manifest includes all files from .tfcache, .dscache and .htcache, but does not include other files from the working directory.\nTo generate FRM containing only few specific entities, the rule (exclude all *) can be used in a manifest.\nE.g. the rule (exclude all *, include service *) specified that the FRM will contain only service entities.\nDataspace FLOB files will be included into frm if node is running and FLOB directory located under working directory only.";

    protected FrmManifest getManifest(SLStatement statement, MFSession session) throws Exception {
        Definition definition = (Definition)statement;
        FrmManifest manifest = new FrmManifest();
        if (definition.hasGlobalInclude) {
            if (!definition.hasGlobalExclude) {
                manifest.includeAll();
            }
        } else if (definition.hasGlobalExclude) {
            manifest.excludeAll();
        }
        for (Map.Entry<FrmEntityType, Set<FrmEntity>> entities : definition.getIncludeEntities().entrySet()) {
            for (FrmEntity entity : entities.getValue()) {
                manifest.includeEntity(entities.getKey(), entity);
            }
        }
        for (Map.Entry<FrmEntityType, Set<FrmEntity>> entities : definition.getExcludeEntities().entrySet()) {
            for (FrmEntity entity : entities.getValue()) {
                manifest.excludeEntity(entities.getKey(), entity);
            }
        }
        return manifest;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        boolean hasGlobalInclude = false;
        boolean hasGlobalExclude = false;
        HashMap<FrmEntityType, Set<FrmEntity>> includeEntities = new HashMap<FrmEntityType, Set<FrmEntity>>();
        HashMap<FrmEntityType, Set<FrmEntity>> excludeEntities = new HashMap<FrmEntityType, Set<FrmEntity>>();
        StatementSetValue operations = statement.getSet("OperationsSet");
        if (operations.isPresent()) {
            for (int i = 0; i < operations.size(); ++i) {
                Set<FrmEntity> entities;
                FrmEntity entity;
                FrmEntityType type;
                StatementValueList entityValue = operations.getElement(i);
                String operationType = entityValue.getParameter("OperationType").getValue();
                Object entityName = entityValue.getParameter("EntityName").getValue();
                String namespace = "";
                if (entityValue.existsParameter("EntityNamespace")) {
                    namespace = entityValue.getParameter("EntityNamespace").getValue();
                }
                if ((type = FrmEntityType.slangNameToType(entityValue.getParameter("EntityType").getValue())) == FrmEntityType.ALL) {
                    if (!((String)entityName).equals("*")) continue;
                    if (operationType.equalsIgnoreCase("include")) {
                        hasGlobalInclude = true;
                        continue;
                    }
                    hasGlobalExclude = true;
                    continue;
                }
                if (type == FrmEntityType.HTTP_ACCEPTOR) {
                    int index;
                    String context = entityName;
                    entityName = "*";
                    if (namespace.length() > 0 && (index = namespace.lastIndexOf(47)) != -1 && index != namespace.trim().length() - 1) {
                        entityName = namespace.substring(index + 1);
                        namespace = namespace.substring(0, index);
                    }
                    entity = new FrmEntity((String)entityName, namespace);
                    entity.setContext(context);
                } else {
                    if (type != FrmEntityType.EVENT_PROTOTYPE && type.getExtension() != null && type.getExtension().length() > 0 && !((String)entityName).equals("*") && !((String)entityName).endsWith(type.getExtension())) {
                        entityName = (String)entityName + type.getExtension();
                    }
                    entity = new FrmEntity((String)entityName, namespace);
                }
                if (operationType.equalsIgnoreCase("include")) {
                    entities = (HashSet<FrmEntity>)includeEntities.get((Object)type);
                    if (entities == null) {
                        entities = new HashSet<FrmEntity>();
                        includeEntities.put(type, entities);
                    }
                    entities.add(entity);
                    continue;
                }
                entities = (Set)excludeEntities.get((Object)type);
                if (entities == null) {
                    entities = new HashSet();
                    excludeEntities.put(type, entities);
                }
                entities.add(entity);
            }
        }
        return this.createDefinition(statement.getParameter("ManifestName").getValue(), hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
    }

    protected abstract Definition createDefinition(String var1, boolean var2, Map<FrmEntityType, Set<FrmEntity>> var3, boolean var4, Map<FrmEntityType, Set<FrmEntity>> var5);

    public static class Definition
    extends AbstractSLStatement {
        private String manifestName;
        private long expiration = 0L;
        private String path;
        private boolean hasGlobalInclude;
        private Map<FrmEntityType, Set<FrmEntity>> includeEntities;
        private boolean hasGlobalExclude;
        private Map<FrmEntityType, Set<FrmEntity>> excludeEntities;

        protected Definition(String name, String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
            super(name);
            this.manifestName = manifestName;
            this.hasGlobalInclude = hasGlobalInclude;
            this.includeEntities = includeEntities;
            this.hasGlobalExclude = hasGlobalExclude;
            this.excludeEntities = excludeEntities;
        }

        public String getManifestName() {
            return this.manifestName;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long expiration) {
            this.expiration = expiration;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean hasGlobalInclude() {
            return this.hasGlobalInclude;
        }

        public Map<FrmEntityType, Set<FrmEntity>> getIncludeEntities() {
            return this.includeEntities;
        }

        public Map<FrmEntityType, Set<FrmEntity>> getExcludeEntities() {
            return this.excludeEntities;
        }

        public boolean hasGlobalExclude() {
            return this.hasGlobalExclude;
        }
    }
}

