/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.file;

import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.runtime.mf.operation.file.AbstractFileDescriptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListFileDescriptorsOperation
extends AbstractFileDescriptorOperation {
    public static final String NAME = "list file descriptors";

    public ListFileDescriptorsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST FILE DESCRIPTORS");
        this.syntax.setDescription("Returns a list of file descriptors in the node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListFileDescriptorsOperation.createResultDescriptor());
        for (String name : FileDescriptorRepositoryUtils.listFileDescriptors()) {
            FileDescriptor descriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(name);
            result.addToRowSet(new Object[]{name, descriptor.getDescription(), descriptor.getFileFormat().toString(), descriptor.getKeyFieldStart() + " - " + descriptor.getKeyFieldEnd(), descriptor.getRecordGroupKey(), descriptor.getRecords().size(), descriptor.isSystem() ? "x" : ""});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListFileDescriptorsOperation.addColumn(result, "Name");
        ListFileDescriptorsOperation.addColumn(result, "Description");
        ListFileDescriptorsOperation.addColumn(result, "File Format");
        ListFileDescriptorsOperation.addColumn(result, "Key Field Positions");
        ListFileDescriptorsOperation.addColumn(result, "Record Group Key");
        ListFileDescriptorsOperation.addColumn(result, "Records Count");
        ListFileDescriptorsOperation.addColumn(result, "Is System");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListFileDescriptorsOperation.NAME);
        }
    }
}

