/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.file;

import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.runtime.mf.operation.file.AbstractFileDescriptorOperation;
import com.streamscape.runtime.mf.operation.file.DescribeFileDescriptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class DropFileDescriptorOperation
extends AbstractFileDescriptorOperation {
    public static final String NAME = "drop file descriptor";

    public DropFileDescriptorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP FILE DESCRIPTOR").addActionParameter((SyntaxParameter)new IdentifierParameter("DescriptorName").setCompletionAdviser(new DescribeFileDescriptorOperation.FileDescriptorAdviser()));
        this.syntax.setDescription("Drops specified file descriptor");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("DescriptorName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        if (!FileDescriptorRepositoryUtils.existsFileDescriptor(((Definition)definition).descriptorName)) {
            throw new Exception("File descriptor with name '" + ((Definition)definition).descriptorName + "' doesn't exist.");
        }
        FileDescriptorRepositoryUtils.removeFileDescriptor(((Definition)definition).descriptorName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        String descriptorName;

        public Definition(String descriptorName) {
            super(DropFileDescriptorOperation.NAME);
            this.descriptorName = descriptorName;
        }
    }
}

