/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.file;

import com.streamscape.Trace;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.file.FileFormat;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordSubTypeGroupDefinition;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.SubRecordField;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.operation.file.AbstractFileDescriptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DescribeFileDescriptorOperation
extends AbstractFileDescriptorOperation {
    public static final String NAME = "describe file descriptor";

    public DescribeFileDescriptorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE FILE DESCRIPTOR").addActionParameter((SyntaxParameter)new IdentifierParameter("FileDescriptorName").setCompletionAdviser(new FileDescriptorAdviser()));
        SyntaxHint choiceSyntaxHint = new SyntaxHint("   ", true);
        ChoiceModifier choice = (ChoiceModifier)new ChoiceModifier("RecordChoice").setRequired(false);
        choice.addModifier((AbstractModifier)new Modifier("RECORD TYPES").setSyntaxHint(choiceSyntaxHint));
        choice.addModifier((AbstractModifier)new Modifier("RECORD").setSyntaxHint(choiceSyntaxHint));
        choice.addModifier((AbstractModifier)new Modifier("RECORD FIELDS").setSyntaxHint(choiceSyntaxHint));
        choice.addModifier((AbstractModifier)((Modifier)new Modifier("RECORD FIELD").setSyntaxHint(choiceSyntaxHint)).addParameter((SyntaxParameter)((StringParameter)new StringParameter("FieldName").setName("OneRecordFieldName")).setCompletionAdviser(new FileDescriptorFieldAdviser(this))));
        CompoundModifier record = new CompoundModifier("RecordCompound");
        record.addModifier((AbstractModifier)new Modifier("RECORD TYPE").addParameter((SyntaxParameter)new StringParameter("RecordKey").setCompletionAdviser(new FileDescriptorRecordAdviser(this))));
        BlockModifier subRecords = (BlockModifier)new BlockModifier("sub").setRequired(false);
        ChoiceModifier subRecordField = new ChoiceModifier("SubRecordSubFiedlChoice");
        subRecordField.addModifier((AbstractModifier)new Modifier("RECORD TYPE").addParameter((SyntaxParameter)new StringParameter("RecordKey").setCompletionAdviser(new FileDescriptorSubRecordAdviser(this))));
        subRecordField.addModifier((AbstractModifier)new Modifier("FIELD").addParameter((SyntaxParameter)new StringParameter("FieldName").setCompletionAdviser(new FileDescriptorFieldAdviser(this))));
        subRecords.addModifier((AbstractModifier)new RepeatableModifier("SubRecordFieldLine").addModifier(subRecordField));
        record.addModifier(subRecords);
        ChoiceModifier fieldChoice = (ChoiceModifier)new ChoiceModifier("FieldChoice").setRequired(false);
        fieldChoice.addModifier(new Modifier("FIELDS"));
        fieldChoice.addModifier((AbstractModifier)new Modifier("FIELD").addParameter((SyntaxParameter)new StringParameter("FieldName").setCompletionAdviser(new FileDescriptorFieldAdviser(this))));
        fieldChoice.addModifier(new Modifier("SUBRECORD TYPES"));
        fieldChoice.addModifier((AbstractModifier)new Modifier("SUBRECORD TYPE").addParameter((SyntaxParameter)new StringParameter("SubRecordKey").setCompletionAdviser(new FileDescriptorSubRecordAdviser(this))));
        record.addModifier(fieldChoice);
        choice.addModifier((AbstractModifier)record.setSyntaxHint(choiceSyntaxHint));
        this.syntax.addModifier(choice);
        this.syntax.setDescription("Describes specified file descriptor.");
        this.syntax.setExamples("describe file descriptor EmployeesDescriptor\n\ndescribe file descriptor CsvDescriptor record\n\ndescribe file descriptor CsvDescriptor record fields\n\ndescribe file descriptor CsvDescriptor record field 'NameField'\n\ndescribe file descriptor CsvDescriptor record field 'NameField'\n\ndescribe file descriptor MultiPositionalDescriptor record types\n\ndescribe file descriptor MultiPositionalDescriptor record type 'typekey1'\n\ndescribe file descriptor MultiPositionalDescriptor record type 'typekey1'\n\ndescribe file descriptor MultiPositionalDescriptor record type 'typekey1' fields\n\ndescribe file descriptor MultiPositionalDescriptor record type 'typekey1' field 'NameField'\n\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(statement.getParameter("FileDescriptorName").getValue(), statement.getModifier("RECORD TYPES").isPresent(), statement.getParameter("RecordKey").getValue(), statement.getModifier("FIELDS").isPresent() | statement.getModifier("SUBRECORD TYPES").isPresent(), statement.getParameter("FieldName").isPresent() ? statement.getParameter("FieldName").getValue() : statement.getParameter("SubRecordKey").getValue(), statement.getModifier("RECORD").isPresent(), statement.getModifier("RECORD FIELDS").isPresent(), statement.getParameter("OneRecordFieldName").getValue());
        StatementBlockValue sub = statement.getBlock("sub");
        if (sub.isPresent()) {
            ArrayList<String> subs = new ArrayList<String>();
            for (int i = 0; i < sub.getLinesCount(); ++i) {
                StatementValueList line = sub.getLineByIndex(i);
                if (line.getParameter("RecordKey").isPresent()) {
                    subs.add("RECORD" + line.getParameter("RecordKey").getValue());
                    continue;
                }
                if (!line.getParameter("FieldName").isPresent()) continue;
                subs.add("FIELD" + line.getParameter("FieldName").getValue());
            }
            definition.subs = subs;
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        FileDescriptor descriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(definition.descriptorName);
        if (descriptor == null) {
            throw new Exception("File descriptor '" + definition.descriptorName + "' doesn't exist.");
        }
        if (descriptor.getFileFormat() == FileFormat.POSITIONAL_MULTI_RECORD_TYPE && (definition.record || definition.recordFields || definition.oneRecordFieldName != null)) {
            throw new Exception("RECORD/RECORD FIELDS/RECORD FILED modifiers cannot be specified POSITIONAL_MULTI_RECORD_TYPE file descriptor.");
        }
        if (definition.record || definition.recordFields || definition.oneRecordFieldName != null) {
            if (descriptor.getRecords().size() > 1) {
                throw new Exception("RECORD/RECORD FIELDS/RECORD FILED modifiers cannot be specified for file descriptor that contains more than one record.");
            }
            if (descriptor.getRecords().size() == 1) {
                if (definition.recordFields) {
                    definition.fields = true;
                }
                if (definition.oneRecordFieldName != null) {
                    definition.fieldName = definition.oneRecordFieldName;
                }
                definition.recordKey = descriptor.getRecords().get(0).getTypeKey();
            }
        }
        if (definition.records) {
            return this.describeRecords(descriptor, descriptor.getRecords());
        }
        if (definition.recordKey != null) {
            return this.describeRecord(definition, descriptor);
        }
        return this.describe(definition.descriptorName, descriptor);
    }

    private SLResponse describe(String name, FileDescriptor descriptor) throws Exception {
        RowSet result = new RowSet(DescribeFileDescriptorOperation.createResultDescriptorNameValue());
        result.addToRowSet(new Object[]{"Name", name});
        result.addToRowSet(new Object[]{"Description", descriptor.getDescription()});
        result.addToRowSet(new Object[]{"File Format", descriptor.getFileFormat().toString()});
        result.addToRowSet(new Object[]{"Skip First Line", descriptor.isSkipFirstLine() ? "true" : "false"});
        result.addToRowSet(new Object[]{"Start At Line", descriptor.getStartAtLine()});
        result.addToRowSet(new Object[]{"End At Line", descriptor.getEndAtLine()});
        if (descriptor.getFileFormat() == FileFormat.DELIMITED) {
            result.addToRowSet(new Object[]{"Delimiter", descriptor.getDelimiter()});
            result.addToRowSet(new Object[]{"Lines Delimiter", descriptor.getLinesDelimiter() != null ? descriptor.getLinesDelimiter() : "n/a"});
            result.addToRowSet(new Object[]{"Quote", Character.valueOf(descriptor.getQuoteSymbol())});
            result.addToRowSet(new Object[]{"Quote Escape", Character.valueOf(descriptor.getQuoteEscapeSymbol())});
            result.addToRowSet(new Object[]{"Ignore Inner Quotes", descriptor.isIgnoreInnerQuotes()});
        } else if (descriptor.getFileFormat() == FileFormat.CSV) {
            result.addToRowSet(new Object[]{"Delimiter", ","});
            result.addToRowSet(new Object[]{"Lines Delimiter", descriptor.getLinesDelimiter() != null ? descriptor.getLinesDelimiter() : "n/a"});
            result.addToRowSet(new Object[]{"Quote", Character.valueOf(descriptor.getQuoteSymbol())});
            result.addToRowSet(new Object[]{"Quote Escape", descriptor.getQuoteEscapeSymbol() != '\u0000' ? Character.valueOf(descriptor.getQuoteEscapeSymbol()) : ""});
            result.addToRowSet(new Object[]{"Ignore Inner Quotes", descriptor.isIgnoreInnerQuotes()});
        } else if (descriptor.getFileFormat() == FileFormat.DELIMITED_REGEXP) {
            result.addToRowSet(new Object[]{"Lines Regexp", descriptor.getRegexp().replaceAll("\t", "\\t")});
        } else if (this.isRecordOrMultiRecordType(descriptor)) {
            result.addToRowSet(new Object[]{"Key Field Position", descriptor.getKeyFieldStart() + " - " + descriptor.getKeyFieldEnd()});
            result.addToRowSet(new Object[]{"Record Group Key", descriptor.getRecordGroupKey()});
        }
        result.addToRowSet(new Object[]{"Auto Trim Whitespaces", descriptor.isAutotrimWhitespaces()});
        result.addToRowSet(new Object[]{"Null Indicator", descriptor.getNullIndicator() == null ? "not set" : (descriptor.getNullIndicator().length() == 0 ? "empty string" : descriptor.getNullIndicator())});
        result.addToRowSet(new Object[]{"Total Record Types", descriptor.getRecords().size()});
        result.addToRowSet(new Object[]{"Is System", descriptor.isSystem()});
        return new SLResponse(result);
    }

    private SLResponse describeRecords(FileDescriptor descriptor, Collection<FileDescriptorRecord> records) throws Exception {
        RowSet result = new RowSet(this.createResultDescriptorRecords(descriptor));
        for (FileDescriptorRecord record : records) {
            AbstractRecordTypeDefinition recordTypeDefinition;
            if (record instanceof RecordTypeDefinition) {
                recordTypeDefinition = (RecordTypeDefinition)record;
                if (this.isRecordOrMultiRecordType(descriptor)) {
                    result.addToRowSet(new Object[]{recordTypeDefinition.getTypeKey() != null ? recordTypeDefinition.getTypeKey() : "", recordTypeDefinition.getTypeName(), recordTypeDefinition.getDescription(), ((RecordTypeDefinition)recordTypeDefinition).getSemanticType(), ((RecordTypeDefinition)recordTypeDefinition).getEventId(), recordTypeDefinition.getFields().size()});
                    continue;
                }
                result.addToRowSet(new Object[]{recordTypeDefinition.getDescription(), ((RecordTypeDefinition)recordTypeDefinition).getSemanticType(), ((RecordTypeDefinition)recordTypeDefinition).getEventId(), recordTypeDefinition.getFields().size()});
                continue;
            }
            if (record instanceof UntypedRecordTypeDefinition) {
                recordTypeDefinition = (UntypedRecordTypeDefinition)record;
                if (this.isRecordOrMultiRecordType(descriptor)) {
                    result.addToRowSet(new Object[]{recordTypeDefinition.getTypeKey() != null ? recordTypeDefinition.getTypeKey() : "", recordTypeDefinition.getTypeName(), "n/a", "n/a", recordTypeDefinition.getDescription(), recordTypeDefinition.getFields().size()});
                    continue;
                }
                result.addToRowSet(new Object[]{recordTypeDefinition.getDescription(), "n/a", "n/a", recordTypeDefinition.getFields().size()});
                continue;
            }
            if (record instanceof RecordSubTypeGroupDefinition) {
                RecordSubTypeGroupDefinition recordSubTypeGroupDefinition = (RecordSubTypeGroupDefinition)record;
                if (this.isRecordOrMultiRecordType(descriptor)) {
                    result.addToRowSet(new Object[]{recordSubTypeGroupDefinition.getTypeKey(), recordSubTypeGroupDefinition.getTypeName(), "Sub Type Group Definition (" + recordSubTypeGroupDefinition.getSubKeyFieldStart() + "-" + recordSubTypeGroupDefinition.getSubKeyFieldEnd() + ")", "n/a", "n/a", recordSubTypeGroupDefinition.getSubTypeRecords().size()});
                    continue;
                }
                result.addToRowSet(new Object[]{"Sub Type Group Definition (" + recordSubTypeGroupDefinition.getSubKeyFieldStart() + "-" + recordSubTypeGroupDefinition.getSubKeyFieldEnd() + ")", "n/a", "n/a", recordSubTypeGroupDefinition.getSubTypeRecords().size()});
                continue;
            }
            if (this.isRecordOrMultiRecordType(descriptor)) {
                result.addToRowSet(new Object[]{record.getTypeKey(), record.getTypeName(), "Unknown Record Definition", "n/a", "n/a", "n/a"});
                continue;
            }
            result.addToRowSet(new Object[]{"Unknown Record Definition", "n/a", "n/a", "n/a"});
        }
        return new SLResponse(result);
    }

    private SLResponse describeRecord(Definition definition, FileDescriptor descriptor) throws Exception {
        FileDescriptorRecord record = descriptor.getRecord(definition.recordKey);
        if (record == null) {
            throw new Exception("Unknown record key '" + definition.recordKey + "',");
        }
        return this.describeRecord(definition, descriptor, record);
    }

    private SLResponse describeRecord(Definition definition, FileDescriptor descriptor, FileDescriptorRecord record) throws Exception {
        SubRecordField subField = null;
        if (definition.subs != null && definition.subs.size() > 0) {
            for (String sub : definition.subs) {
                if (sub.startsWith("RECORD")) {
                    FileDescriptorRecord subRecord;
                    String subRecordKey = sub.substring("RECORD".length());
                    if (subField == null) {
                        if (!(record instanceof RecordSubTypeGroupDefinition)) {
                            throw new Exception("Record '" + record.getTypeKey() + "' should be of type RecordSubTypeGroupDefinition to contain sub record '" + subRecordKey + "'.");
                        }
                        subRecord = ((RecordSubTypeGroupDefinition)record).getSubTypeRecord(subRecordKey);
                        if (subRecord == null) {
                            throw new Exception("Record '" + record.getTypeKey() + "' doesn't contain sub record '" + subRecordKey + "'.");
                        }
                        record = subRecord;
                        subField = null;
                        continue;
                    }
                    subRecord = subField.getRecord(subRecordKey);
                    if (subRecord == null) {
                        throw new Exception("Sub filed '" + subField.getFieldName() + "' doesn't contain sub record '" + subRecordKey + "'.");
                    }
                    record = subRecord;
                    subField = null;
                    continue;
                }
                if (!sub.startsWith("FIELD")) continue;
                String subFieldName = sub.substring("FIELD".length());
                if (record == null) {
                    throw new Exception("Sub field '" + subFieldName + "' can be get from record only.");
                }
                if (!(record instanceof AbstractRecordTypeDefinition)) {
                    throw new Exception("Record '" + record.getTypeKey() + "' should be of type AnstractRecordTypeDefinition to contain sub field '" + subFieldName + "'.");
                }
                RecordField field = ((AbstractRecordTypeDefinition)record).getField(subFieldName);
                if (field == null) {
                    throw new Exception("Record '" + record.getTypeKey() + "' doesn't contain sub field '" + subFieldName + "'.");
                }
                if (!(field instanceof SubRecordField)) {
                    throw new Exception("Field '" + subFieldName + "' is not of type sub field.");
                }
                subField = (SubRecordField)field;
                record = null;
            }
        }
        if (record instanceof AbstractRecordTypeDefinition) {
            if (definition.fields) {
                return this.describeRecordTypeDefinitionFields((AbstractRecordTypeDefinition)record);
            }
            if (definition.fieldName != null) {
                RecordField field = ((AbstractRecordTypeDefinition)record).getField(definition.fieldName);
                if (field == null) {
                    throw new Exception("Field '" + definition.fieldName + "' doesn't exists in record '" + record.getTypeKey() + "'.");
                }
                return this.describeField(field);
            }
            return this.describeRecordTypeDefinition(descriptor, (AbstractRecordTypeDefinition)record);
        }
        if (record instanceof RecordSubTypeGroupDefinition) {
            if (definition.fields) {
                return this.describeRecords(descriptor, ((RecordSubTypeGroupDefinition)record).getSubTypeRecords());
            }
            if (definition.fieldName != null) {
                FileDescriptorRecord subRecord = ((RecordSubTypeGroupDefinition)record).getSubTypeRecord(definition.fieldName);
                if (subRecord == null) {
                    throw new Exception("Sub record '" + definition.fieldName + "' doesn't exists in record '" + record.getTypeKey() + "'.");
                }
                return this.describeRecord(new Definition(null, false, null, false, null, false, false, null), descriptor, subRecord);
            }
            return this.describeRecordSubTypeGroupDefinition((RecordSubTypeGroupDefinition)record);
        }
        if (subField != null) {
            if (definition.fields) {
                return this.describeRecords(descriptor, subField.getSubRecords().values().stream().collect(Collectors.toCollection(() -> new ArrayList())));
            }
            return this.describeField(subField);
        }
        throw new Exception("Unknown record type " + record.getClass().getName());
    }

    private SLResponse describeRecordTypeDefinition(FileDescriptor descriptor, AbstractRecordTypeDefinition record) throws Exception {
        RowSet result = new RowSet(DescribeFileDescriptorOperation.createResultDescriptorNameValue());
        if (this.isRecordOrMultiRecordType(descriptor)) {
            result.addToRowSet(new Object[]{"Record Type Key", record.getTypeKey() != null ? record.getTypeKey() : ""});
            result.addToRowSet(new Object[]{"Record Type Name", record.getTypeName()});
        }
        result.addToRowSet(new Object[]{"Record Type Description", record.getDescription()});
        result.addToRowSet(new Object[]{"Semantic Type", record instanceof RecordTypeDefinition ? ((RecordTypeDefinition)record).getSemanticType() : "n/a"});
        result.addToRowSet(new Object[]{"Event ID", record instanceof RecordTypeDefinition ? ((RecordTypeDefinition)record).getEventId() : "n/a"});
        result.addToRowSet(new Object[]{"Fields Count", record.getFields().size()});
        return new SLResponse(result);
    }

    private SLResponse describeRecordTypeDefinitionFields(AbstractRecordTypeDefinition record) throws Exception {
        RowSet result = new RowSet(this.createResultDescriptorRecordTypeDefinitionFields());
        for (RecordField field : record.getFields()) {
            result.addToRowSet(new Object[]{field.getFieldName(), field.getDescription(), field.getConverterName(), field.getFormat() != null ? field.getFormat() : "", field.getDefaultValue() != null ? field.getDefaultValue() : "", field.getStart() + " - " + field.getEnd(), field.getSpathsString(), field.getDataTypeForDescribe() != null && field.getDataTypeForDescribe().length() > 0 ? field.getDataTypeForDescribe() : "n/a", field instanceof SubRecordField ? "x" : "", field.isNullable() ? "x" : ""});
        }
        return new SLResponse(result);
    }

    private SLResponse describeRecordSubTypeGroupDefinition(RecordSubTypeGroupDefinition record) throws Exception {
        RowSet result = new RowSet(DescribeFileDescriptorOperation.createResultDescriptorNameValue());
        result.addToRowSet(new Object[]{"Sub Record Type Key", record.getTypeKey()});
        result.addToRowSet(new Object[]{"Sub Record Type Name", record.getTypeName()});
        result.addToRowSet(new Object[]{"Sub Key Field Position", record.getSubKeyFieldStart() + " - " + record.getSubKeyFieldEnd()});
        result.addToRowSet(new Object[]{"Sub Records Count", record.getSubTypeRecords().size()});
        return new SLResponse(result);
    }

    private SLResponse describeField(RecordField field) throws Exception {
        RowSet result = new RowSet(DescribeFileDescriptorOperation.createResultDescriptorNameValue());
        result.addToRowSet(new Object[]{"Field Name", field.getFieldName()});
        result.addToRowSet(new Object[]{"Description", field.getDescription()});
        result.addToRowSet(new Object[]{"Converter Name", field.getConverterName()});
        result.addToRowSet(new Object[]{"Source Format", field.getFormat() != null ? field.getFormat() : ""});
        result.addToRowSet(new Object[]{"Default Value", field.getDefaultValue() != null ? field.getDefaultValue() : ""});
        result.addToRowSet(new Object[]{"Value Position", field.getStart() + " - " + field.getEnd()});
        result.addToRowSet(new Object[]{"Element Path(s)", Arrays.stream(Optional.ofNullable(field.getSpaths()).orElse(new String[0])).collect(Collectors.joining("\n"))});
        result.addToRowSet(new Object[]{"Data Type", field.getDataTypeForDescribe() != null && field.getDataTypeForDescribe().length() > 0 ? field.getDataTypeForDescribe() : "n/a"});
        result.addToRowSet(new Object[]{"Auto Trim Whitespaces", field.getAutotrimWhitespaces() != null ? field.getAutotrimWhitespaces() : "inherited from FileDescriptor"});
        result.addToRowSet(new Object[]{"Nullable", field.isNullable()});
        result.addToRowSet(new Object[]{"Null Indicator", field.getNullIndicator() == null ? "not set" : (field.getNullIndicator().length() == 0 ? "empty string" : field.getNullIndicator())});
        result.addToRowSet(new Object[]{"Is Sub Field", field instanceof SubRecordField});
        if (field instanceof SubRecordField) {
            result.addToRowSet(new Object[]{"Key Positions", ((SubRecordField)field).getKeyFieldStart() + " - " + ((SubRecordField)field).getKeyFieldEnd()});
            result.addToRowSet(new Object[]{"Sub Records Count", ((SubRecordField)field).getSubRecords().size()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptorNameValue() {
        RowMetaData result = new RowMetaData(10);
        DescribeFileDescriptorOperation.addColumn(result, "Name");
        DescribeFileDescriptorOperation.addColumn(result, "Value");
        return result;
    }

    private RowMetaData createResultDescriptorRecords(FileDescriptor descriptor) {
        RowMetaData result = new RowMetaData(10);
        if (this.isRecordOrMultiRecordType(descriptor)) {
            DescribeFileDescriptorOperation.addColumn(result, "Record Type Key");
            DescribeFileDescriptorOperation.addColumn(result, "Record Type Name");
        }
        DescribeFileDescriptorOperation.addColumn(result, "Record Type Description");
        DescribeFileDescriptorOperation.addColumn(result, "Semantic Type");
        DescribeFileDescriptorOperation.addColumn(result, "Event ID");
        DescribeFileDescriptorOperation.addColumn(result, "Fields Count");
        return result;
    }

    private RowMetaData createResultDescriptorRecordTypeDefinitionFields() {
        RowMetaData result = new RowMetaData(10);
        DescribeFileDescriptorOperation.addColumn(result, "Field Name");
        DescribeFileDescriptorOperation.addColumn(result, "Description");
        DescribeFileDescriptorOperation.addColumn(result, "Converter Name");
        DescribeFileDescriptorOperation.addColumn(result, "Source Format");
        DescribeFileDescriptorOperation.addColumn(result, "Default Value");
        DescribeFileDescriptorOperation.addColumn(result, "Position");
        DescribeFileDescriptorOperation.addColumn(result, "Element Path(s)");
        DescribeFileDescriptorOperation.addColumn(result, "Data Type");
        DescribeFileDescriptorOperation.addColumn(result, "Sub Record Field");
        DescribeFileDescriptorOperation.addColumn(result, "Nullable");
        return result;
    }

    private boolean isRecordOrMultiRecordType(FileDescriptor descriptor) {
        return descriptor.getFileFormat() == FileFormat.POSITIONAL_MULTI_RECORD_TYPE || descriptor.getFileFormat() == FileFormat.POSITIONAL_RECORD_TYPE;
    }

    public static class FileDescriptorAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                return FileDescriptorRepositoryUtils.listFileDescriptors();
            }
            catch (ObjectConfigurationException exception) {
                Trace.logError(this, exception.getMessage());
                return Collections.emptyList();
            }
        }
    }

    class FileDescriptorFieldAdviser
    extends AbstractFileDescriptorFieldRecordAdviser {
        FileDescriptorFieldAdviser(DescribeFileDescriptorOperation this$0) {
        }

        @Override
        protected List<String> doGetCompletions(DSLStatement statement, FileDescriptor descriptor, MFSession session) {
            FileDescriptorRecord record = null;
            if (statement.getParameter("RecordKey").isPresent()) {
                record = descriptor.getRecord(statement.getParameter("RecordKey").getValue());
            } else if (descriptor.getRecords().size() == 1) {
                record = descriptor.getRecords().get(0);
            }
            if (record instanceof AbstractRecordTypeDefinition) {
                return ((AbstractRecordTypeDefinition)record).getFields().stream().map(r -> "'" + r.getFieldName() + "'").collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    class FileDescriptorRecordAdviser
    extends AbstractFileDescriptorFieldRecordAdviser {
        FileDescriptorRecordAdviser(DescribeFileDescriptorOperation this$0) {
        }

        @Override
        protected List<String> doGetCompletions(DSLStatement statement, FileDescriptor descriptor, MFSession session) {
            return descriptor.getRecords().stream().map(r -> "'" + (r.getTypeKey() != null ? r.getTypeKey() : "") + "'").collect(Collectors.toList());
        }
    }

    class FileDescriptorSubRecordAdviser
    extends AbstractFileDescriptorFieldRecordAdviser {
        FileDescriptorSubRecordAdviser(DescribeFileDescriptorOperation this$0) {
        }

        @Override
        protected List<String> doGetCompletions(DSLStatement statement, FileDescriptor descriptor, MFSession session) {
            FileDescriptorRecord record;
            if (statement.getParameter("RecordKey").isPresent() && (record = descriptor.getRecord(statement.getParameter("RecordKey").getValue())) instanceof RecordSubTypeGroupDefinition) {
                return ((RecordSubTypeGroupDefinition)record).getSubTypeRecords().stream().map(r -> "'" + (r.getTypeKey() != null ? r.getTypeKey() : "") + "'").collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String descriptorName;
        private boolean records;
        private String recordKey;
        private boolean fields;
        private List<String> subs;
        private String fieldName;
        private boolean record;
        private boolean recordFields;
        private String oneRecordFieldName;

        public Definition(String descriptorName, boolean records, String recordKey, boolean fields, String fieldName, boolean record, boolean recordFields, String oneRecordFieldName) {
            super(DescribeFileDescriptorOperation.NAME);
            this.descriptorName = descriptorName;
            this.records = records;
            this.recordKey = recordKey;
            this.fields = fields;
            this.fieldName = fieldName;
            this.record = record;
            this.recordFields = recordFields;
            this.oneRecordFieldName = oneRecordFieldName;
        }
    }

    abstract class AbstractFileDescriptorFieldRecordAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        AbstractFileDescriptorFieldRecordAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                FileDescriptor descriptor;
                DSLStatement statement = DescribeFileDescriptorOperation.this.syntax.parse(processedScript, false);
                if (statement.getParameter("FileDescriptorName").isPresent() && (descriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(statement.getParameter("FileDescriptorName").getValue())) != null) {
                    return this.doGetCompletions(statement, descriptor, session);
                }
            }
            catch (Exception exception) {
                Trace.logError(this, exception.getMessage());
            }
            return Collections.emptyList();
        }

        protected abstract List<String> doGetCompletions(DSLStatement var1, FileDescriptor var2, MFSession var3);
    }
}

