/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.file;

import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorBuilder;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.edl.CreateSdoFromCsvOperation;
import com.streamscape.runtime.mf.operation.file.AbstractFileDescriptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CreateFileDescriptorOperation
extends AbstractFileDescriptorOperation {
    public static final String NAME = "create file descriptor";

    public CreateFileDescriptorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE FILE DESCRIPTOR").addActionParameter(new IdentifierParameter("DescriptorName"));
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("FROM_OR_TYPE_CHOICE").addModifier(new CompoundModifier().addModifier(new Modifier("FROM")).addModifier(new ChoiceModifier().addPossibleValues("CSV", "DELIMITED", "DELIMITED_REGEXP")).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("FileOrFieldsModifier").addModifier((AbstractModifier)((Modifier)new Modifier("FILE").addParameter(new SLFilePathParameter("filename"))).setSyntaxHint(new SyntaxHint("  ", true)))).addModifier((AbstractModifier)((Modifier)new Modifier("HEADER").addParameter(new StringParameter("header"))).setSyntaxHint(new SyntaxHint("  ", true)))).addModifier((AbstractModifier)CreateFileDescriptorOperation.createFieldsSyntax("FIELDS", "", null).setSyntaxHint(new SyntaxHint("  ", true))))));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("START AT LINE").addParameter((SyntaxParameter)new IntegerParameter("line number").setName("startAtLine"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("END AT LINE").addParameter((SyntaxParameter)new IntegerParameter("line number").setName("endAtLine"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("TRIM_WHITESPACES_CHOICE").addModifier((AbstractModifier)new Modifier("TRIM WHITESPACES").setName("TRIM_WHITESPACES_DESC"))).addModifier((AbstractModifier)new Modifier("NOT TRIM WHITESPACES").setName("NOT_TRIM_WHITESPACES_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("NULL INDICATOR").setName("NULL_INDICATOR_DESC_M")).addParameter((SyntaxParameter)new StringParameter("null indicator").setName("NULL_INDICATOR_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("LINES DELIMITER").setName("LINES_DELIMITER_M")).addParameter((SyntaxParameter)new StringParameter("lines delimiter").setName("LINES_DELIMITER_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("LINE REGEXP").setName("LINE_REGEXP")).addParameter(new ExpressionParameter("regexp", '(', ')'))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("TypedOrUntyped").setRequired(true)).addModifier(new CompoundModifier("TypedPropertiesModifier").addModifier((AbstractModifier)((Modifier)new Modifier("RECORD EVENT ID").addParameter(new EventIdParameter("eventId"))).setRequired(true)).addModifier((AbstractModifier)((Modifier)new Modifier("RECORD SEMANTIC TYPE").addParameter(new IdentifierParameter("semanticType"))).setRequired(true)))).addModifier(new CompoundModifier("UntypedPropertiesModifier").addModifier(new Modifier("UNTYPED RECORD", "UNTYPED")).addModifier((AbstractModifier)((Modifier)new Modifier("FIELD TYPES").addParameter(new SetParameter("typesset").addParameter(new StringParameter("fieldName")).addParameter(new StringParameter("fieldType")))).setRequired(false))));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RECORD DESCRIPTION").addParameter((SyntaxParameter)new StringParameter("description").setName("recordDescription"))).setRequired(false));
        CreateSdoFromCsvOperation.appendHeaderAtLineDelimiterModifier(this.syntax, true);
        this.syntax.setDescription("Creates file descriptor based on header of specified CSV or DELIMITED file or on fields list.\n\n Parameters:\n   from {csv | delimited | delimited_regexp} - Specifies type of file and resulting file descriptor.\n   file '<filename>'                  - Specifies file with header.\n   header '<header>'                  - Specifies header line.\n" + CreateFileDescriptorOperation.getFieldsDescription() + "   start at line <line number>        - Specifies the line number where csv data starts. First line is 1.\n   end at line <line number>          - Specifies the line number where csv data ends. 0 means until the file ends.\n   description <description>          - File descriptor description.\n   trim whitespaces                   - Trim whitespaces for delimited file. By default don't trim.\n   null indicator                     - String value to treat as null. If empty string then empty strings are treated as null.\n   record event id [eventId]          - Event id of the record.\n   record semantic type <type>        - Semantic type of the record.\n   untyped record                     - Untyped record type.\n   field types('<name>' '<type>',...) - Types map for fields, if not specified default type is string. Field types are dataspace types.\n   record description <desc>          - Description of the record.\n   line regexp (regexp)               - Line regular expression for DELIMITED_REGEXP file.\n" + CreateSdoFromCsvOperation.getHeaderAtLineDelimiterModifierDescription(true));
        this.syntax.setExamples("create file descriptor MyDescriptor from delimited_regexp fields('message' start group index 2 end group index 2) line regexp (([^\\t.]+)\\t(.*)) untyped record");
    }

    public static String getFieldsDescription() {
        return "   fields                             - Specifies fields list.\n      'fieldName'                     - Specifies field name. If it is typed record, field name should be one of semantic type fields.\n      description '<description>'     - Specifies field description.\n      trim whitespaces                - Trim whitespaces for delimited file. By default don't trim.\n      not nullable                    - Specifies field is not nullable. By default is nullable.\n      format '<format>'               - Specifies field format. Applicable for date/time types only and specifies the format for date/time in java format.\n                                        See date.fromString description.\n      default value '<defaultValue>'  - Specifies field default value.\n      spaths '<spaths>'               - Specifies field spaths delimited by coma. If not specified spath will be set to //<fieldName>. If empty spath will not be set.\n      type '<fieldType>'              - Specifies field type. Should be valid dataspace type.\n                                        Can be set for untyped records only. For typed records type will be defined from semantic type.\n      start group index <index>       - Specifies start regexp group index, for DELIMITED_REGEXP file format.\n      end group index <index>         - Specifies end regexp group index exclusive, for DELIMITED_REGEXP file format.\n";
    }

    public static CompoundModifier createFieldsSyntax(String modifier, String postfix, Modifier additionModifierToBlock) throws RuntimeException {
        BlockModifier block = new BlockModifier("", "FieldsBlock" + postfix);
        CompoundModifier field = new CompoundModifier();
        field.addParameter(new StringParameter("fieldName"));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("description"))).setRequired(false));
        field.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("TRIM_WHITESPACES_CHOICE_FIELD").addModifier((AbstractModifier)new Modifier("TRIM WHITESPACES").setName("TRIM_WHITESPACES_FIELD"))).addModifier((AbstractModifier)new Modifier("NOT TRIM WHITESPACES").setName("NOT_TRIM_WHITESPACES_FIELD"))).setRequired(false));
        field.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("NULLABLE_CHOICE").addModifier((AbstractModifier)new Modifier("NOT NULLABLE").setName("NOT_NULLABLE"))).addModifier((AbstractModifier)new Modifier("NULLABLE").setName("NULLABLE"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("NULL INDICATOR").setName("NULL_INDICATOR_FIELD_M")).addParameter((SyntaxParameter)new StringParameter("null indicator").setName("NULL_INDICATOR_FIELD"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("FORMAT").addParameter(new StringParameter("format"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("DEFAULT VALUE").addParameter(new StringParameter("defaultValue"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("SPATHS").addParameter((SyntaxParameter)new StringParameter("spaths delimited by coma").setName("spaths"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("TYPE").addParameter(new StringParameter("fieldType"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("START GROUP INDEX").addParameter(new IntegerParameter("startIndex"))).setRequired(false));
        field.addModifier((AbstractModifier)((Modifier)new Modifier("END GROUP INDEX").addParameter(new IntegerParameter("endIndex"))).setRequired(false));
        if (additionModifierToBlock != null) {
            field.addModifier(additionModifierToBlock);
        }
        block.addModifier((AbstractModifier)((RepeatableModifier)new RepeatableModifier("fieldline" + postfix).addModifier(field)).setSyntaxHint(new SyntaxHint("    ", true)));
        return new CompoundModifier("fieldscompound" + postfix).addModifier(new Modifier(modifier)).addModifier(block);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        FileDescriptorBuilder.AbstractDelimitedFileDescriptorBuilder builder;
        DSLStatement statement = ((Definition)definition).statement;
        CreateSdoFromCsvOperation.DelimitedFileParameters parameters = null;
        if (!statement.existsModifier("DELIMITED_REGEXP")) {
            parameters = CreateSdoFromCsvOperation.parseDelimitedFileParameters(statement, false);
        }
        if (statement.existsModifier("CSV")) {
            if (!",".equals(parameters.delimiter)) {
                throw new Exception("Invalid delimiter " + parameters.delimiter + " for CSV file.");
            }
            if ('\"' != parameters.quoteSymbol.charValue()) {
                throw new Exception("Invalid quote symbol " + parameters.quoteSymbol + " for CSV file.");
            }
            builder = ((FileDescriptorBuilder.CsvFileDescriptorBuilder)((FileDescriptorBuilder.CsvFileDescriptorBuilder)((FileDescriptorBuilder.CsvFileDescriptorBuilder)((FileDescriptorBuilder.CsvFileDescriptorBuilder)((FileDescriptorBuilder.CsvFileDescriptorBuilder)((FileDescriptorBuilder.CsvFileDescriptorBuilder)FileDescriptorBuilder.csv().setStartAtLine(statement.getParameter("startAtLine").getValue(0))).setEndAtLine(statement.getParameter("endAtLine").getValue(0))).setDescription(statement.getParameter("description").getValue(""))).setTrimWhitespaces(statement.existsModifier("TRIM_WHITESPACES_DESC"))).setNullIndicator(statement.getParameter("NULL_INDICATOR_DESC").getValue(null))).setLinesDelimiter(statement.getParameter("LINES_DELIMITER_DESC").getValue(null))).setQuoteEscapeSymbol(parameters.quoteEscapeSymbol.charValue()).setIgnoreInnerQuotes(parameters.ignoreInnerQuotes);
        } else if (statement.existsModifier("DELIMITED")) {
            builder = ((FileDescriptorBuilder.DelimitedFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedFileDescriptorBuilder)FileDescriptorBuilder.delimited().setDelimiter(parameters.delimiter).setQuoteSymbol(parameters.quoteSymbol != null ? parameters.quoteSymbol.charValue() : (char)'\u0000').setQuoteEscapeSymbol(parameters.quoteEscapeSymbol != null ? parameters.quoteEscapeSymbol.charValue() : (char)'\u0000').setIgnoreInnerQuotes(parameters.ignoreInnerQuotes != null ? parameters.ignoreInnerQuotes : false).setStartAtLine(statement.getParameter("startAtLine").getValue(0))).setEndAtLine(statement.getParameter("endAtLine").getValue(0))).setDescription(statement.getParameter("description").getValue(""))).setTrimWhitespaces(statement.existsModifier("TRIM_WHITESPACES_DESC"))).setNullIndicator(statement.getParameter("NULL_INDICATOR_DESC").getValue(null))).setLinesDelimiter(statement.getParameter("LINES_DELIMITER_DESC").getValue(null));
        } else if (statement.existsModifier("DELIMITED_REGEXP")) {
            builder = ((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)((FileDescriptorBuilder.DelimitedRegexpFileDescriptorBuilder)FileDescriptorBuilder.delimitedRegexp().setStartAtLine(statement.getParameter("startAtLine").getValue(0))).setEndAtLine(statement.getParameter("endAtLine").getValue(0))).setDescription(statement.getParameter("description").getValue(""))).setTrimWhitespaces(statement.existsModifier("TRIM_WHITESPACES_DESC"))).setNullIndicator(statement.getParameter("NULL_INDICATOR_DESC").getValue(null))).setLinesDelimiter(statement.getParameter("LINES_DELIMITER_DESC").getValue(null))).setRegexp(statement.getParameter("regexp").getValue(null));
            if (statement.getParameter("regexp").getValue(null) == null) {
                throw new Exception("Line regular expression should be set for DELIMITED_REGEXP file.");
            }
        } else {
            throw new Exception("Invalid file format.");
        }
        FileDescriptorBuilder.UntypedRecordTypeDefinitionBuilderForDescriptor<Object> recordBuilder = null;
        recordBuilder = statement.existsModifier("UNTYPED") ? builder.untypedRecordTypeDefinition() : ((FileDescriptorBuilder.RecordTypeDefinitionBuilder)builder.recordTypeDefinition().setEventId(statement.getParameter("eventId").getValue())).setSemanticType(statement.getParameter("semanticType").getValue());
        recordBuilder.setDescription(statement.getParameter("recordDescription").getValue(""));
        if (statement.existsBlock("FieldsBlock")) {
            FileDescriptorBuilder.UntypedRecordTypeDefinitionBuilderForDescriptor<Object> finalRecordBuilder = recordBuilder;
            statement.getBlock("FieldsBlock").getLines().forEach(line -> {
                FileDescriptorBuilder.RecordFieldBuilder recordFieldBuilder = finalRecordBuilder.recordField();
                recordFieldBuilder.setFieldName(line.getParameter("fieldName").getValue());
                if (line.existsParameter("description")) {
                    recordFieldBuilder.setDescription(line.getParameter("description").getValue());
                }
                if (line.existsParameter("format")) {
                    recordFieldBuilder.setFormat(line.getParameter("format").getValue());
                }
                if (line.existsModifier("TRIM_WHITESPACES_FIELD")) {
                    recordFieldBuilder.setTrimWhitespaces(true);
                } else if (line.existsModifier("NOT_TRIM_WHITESPACES_FIELD")) {
                    recordFieldBuilder.setTrimWhitespaces(false);
                }
                recordFieldBuilder.setNullable(!line.existsModifier("NOT_NULLABLE"));
                recordFieldBuilder.setNullIndicator(line.getParameter("NULL_INDICATOR_FIELD").getValue(null));
                if (line.existsParameter("defaultValue")) {
                    recordFieldBuilder.setDefaultValue(line.getParameter("defaultValue").getValue());
                }
                if (line.existsParameter("fieldType")) {
                    recordFieldBuilder.setDataType(line.getParameter("fieldType").getValue());
                } else if (finalRecordBuilder instanceof FileDescriptorBuilder.UntypedRecordTypeDefinitionBuilder) {
                    recordFieldBuilder.setDataType("string");
                }
                if (line.existsParameter("spaths")) {
                    recordFieldBuilder.setSpaths(StringUtils.split(line.getParameter("spaths").getValue(), ',').toArray(new String[0]));
                } else if (finalRecordBuilder instanceof FileDescriptorBuilder.RecordTypeDefinitionBuilder) {
                    recordFieldBuilder.setSpaths(new String[]{"//" + line.getParameter("fieldName").getValue()});
                }
                int startGroupIndex = line.getParameter("startIndex").getValue(-1);
                int endGroupIndex = line.getParameter("endIndex").getValue(-1);
                if (statement.existsModifier("DELIMITED_REGEXP")) {
                    if (startGroupIndex == -1 || endGroupIndex == -1) {
                        throw new RuntimeException("Start and end group indexes should be specified for DELIMITED_REGEXP file.");
                    }
                    if (endGroupIndex < startGroupIndex) {
                        throw new RuntimeException("Invalid start and group index specified.");
                    }
                    recordFieldBuilder.setStart(startGroupIndex);
                    recordFieldBuilder.setEnd(endGroupIndex);
                }
                recordFieldBuilder.add();
            });
        } else {
            if (statement.existsModifier("DELIMITED_REGEXP")) {
                throw new Exception("File of format DELIMITED_REGEXP cannot be created from sample file.");
            }
            try (InputStream inputStream = null;){
                if (statement.existsParameter("filename")) {
                    inputStream = ((SLFileUtils)new SLFileUtilsFactory().create(session, statement.getParameter("filename").getValue())).createSLFileInputStream();
                    ((SLFileInputStream)inputStream).open();
                } else if (statement.existsParameter("header")) {
                    inputStream = new ByteArrayInputStream(statement.getParameter("header").getValue().getBytes());
                    parameters.headerLineNumber = 1;
                } else {
                    throw new Exception("No one of filename, header or fields specified.");
                }
                FileDescriptorBuilder.RecordTypeDefinitionBuilderForDescriptorHelper.autobuildFromHeaderFile(new BufferedInputStream(inputStream), parameters.headerLineNumber, this.typesSetToMap(statement), recordBuilder);
            }
        }
        builder.addRecord(((FileDescriptorBuilder.FileDescriptorRecordBuilder)recordBuilder).build());
        FileDescriptor descriptor = builder.build();
        String descriptorName = statement.getParameter("DescriptorName").getValue();
        if (FileDescriptorRepositoryUtils.existsFileDescriptor(descriptorName)) {
            throw new Exception("File descriptor with name '" + descriptorName + "' already exist.");
        }
        FileDescriptorRepositoryUtils.saveFileDescriptor(descriptorName, descriptor);
        return new SLResponse();
    }

    private Map<String, String> typesSetToMap(DSLStatement statement) {
        HashMap<String, String> typesMap = null;
        if (statement.existsSet("typesset")) {
            typesMap = new HashMap<String, String>();
            StatementSetValue typesSet = statement.getSet("typesset");
            for (int i = 0; i < typesSet.size(); ++i) {
                typesMap.put(typesSet.getElement(i).getParameter("fieldName").getValue(), typesSet.getElement(i).getParameter("fieldType").getValue());
            }
        }
        return typesMap;
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(CreateFileDescriptorOperation.NAME);
            this.statement = statement;
        }
    }
}

