/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.file;

import com.streamscape.Trace;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorRepositoryUtils;
import com.streamscape.lib.file.FileFormat;
import com.streamscape.lib.file.RecordField;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.operation.edl.CreateSdoFromCsvOperation;
import com.streamscape.runtime.mf.operation.file.AbstractFileDescriptorOperation;
import com.streamscape.runtime.mf.operation.file.CreateFileDescriptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AlterFileDescriptorOperation
extends AbstractFileDescriptorOperation {
    public static final String NAME = "alter file descriptor";

    public AlterFileDescriptorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER FILE DESCRIPTOR").addActionParameter((SyntaxParameter)new IdentifierParameter("DescriptorName").setCompletionAdviser(new FileDescriptorNotSystemAdviser()));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("START AT LINE").addParameter((SyntaxParameter)new IntegerParameter("line number").setName("startAtLine"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("END AT LINE").addParameter((SyntaxParameter)new IntegerParameter("line number").setName("endAtLine"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("description"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("TRIM_WHITESPACES_CHOICE").addModifier((AbstractModifier)new Modifier("TRIM WHITESPACES").setName("TRIM_WHITESPACES_DESC"))).addModifier((AbstractModifier)new Modifier("NOT TRIM WHITESPACES").setName("NOT_TRIM_WHITESPACES_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("NULL INDICATOR").setName("NULL_INDICATOR_DESC_M")).addParameter((SyntaxParameter)new StringParameter("null indicator").setName("NULL_INDICATOR_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("LINES DELIMITER").setName("LINES_DELIMITER_M")).addParameter((SyntaxParameter)new StringParameter("lines delimiter").setName("LINES_DELIMITER_DESC"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("LINE REGEXP").setName("LINE_REGEXP")).addParameter(new ExpressionParameter("regexp", '(', ')'))).setRequired(false));
        CreateSdoFromCsvOperation.appendHeaderAtLineDelimiterModifier(this.syntax, false);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RECORD DESCRIPTION").addParameter((SyntaxParameter)new StringParameter("description").setName("recordDescription"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RECORD EVENT ID").addParameter(new EventIdParameter("eventId"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RECORD SEMANTIC TYPE").addParameter(new IdentifierParameter("semanticType"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateFileDescriptorOperation.createFieldsSyntax("SET FIELDS", "set", null).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateFileDescriptorOperation.createFieldsSyntax("ADD FIELDS", "add", (Modifier)new Modifier("AFTER FIELD").addParameter((SyntaxParameter)new StringParameter("field name").setName("afterFieldName"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DELETE FIELDS").addParameter(new SetParameter("deleteFieldNames").setDelimiter(new Modifier(",")).addParameter((AbstractParameter)new StringParameter("field name").setName("deleteFieldName")))).setRequired(false));
        this.syntax.setDescription("Alters CSV or DELIMITED file descriptor.\n\n Parameters:\n   start at line <line number> - Specifies the line number where csv data starts. First line is 1.\n   end at line <line number>   - Specifies the line number where csv data ends. 0 means until the file ends.\n   description <description>   - File descriptor description.\n" + CreateSdoFromCsvOperation.getHeaderAtLineDelimiterModifierDescription(false) + "   record description <desc>   - Description of the record.\n   set fields                  - Updates specified fields.\n   add fields                  - Adds specified fields.\n   delete fields               - Removes specified fields.\n" + CreateFileDescriptorOperation.getFieldsDescription() + "   line regexp (regexp)        - Line regular expression for DELIMITED_REGEXP file.\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        StatementSetValue deleteFieldNamesSet;
        DSLStatement statement = ((Definition)definition).statement;
        String descriptorName = statement.getParameter("DescriptorName").getValue();
        FileDescriptor descriptor = FileDescriptorRepositoryUtils.lookupFileDescriptor(descriptorName);
        if (descriptor == null) {
            throw new Exception("Descriptor '" + descriptorName + "' doesn't exist.");
        }
        if (descriptor.isSystem()) {
            throw new Exception("Descriptor '" + descriptorName + "' is system and cannot be changed.");
        }
        AbstractRecordTypeDefinition recordDefinition = (AbstractRecordTypeDefinition)descriptor.getRecords().get(0);
        String value = statement.getParameter("startAtLine").getValue(null);
        if (value != null) {
            descriptor.setStartAtLine(Integer.valueOf(value));
        }
        if ((value = statement.getParameter("endAtLine").getValue(null)) != null) {
            descriptor.setEndAtLine(Integer.valueOf(value));
        }
        if ((value = statement.getParameter("description").getValue(null)) != null) {
            descriptor.setDescription(value);
        }
        if (statement.existsModifier("TRIM_WHITESPACES_DESC") || statement.existsModifier("NOT_TRIM_WHITESPACES_DESC")) {
            if (statement.existsModifier("TRIM_WHITESPACES_DESC")) {
                descriptor.setAutotrimWhitespaces(true);
            }
            if (statement.existsModifier("NOT_TRIM_WHITESPACES_DESC")) {
                descriptor.setAutotrimWhitespaces(false);
            }
            descriptor.getRecords().forEach(record -> {
                if (record instanceof AbstractRecordTypeDefinition) {
                    ((AbstractRecordTypeDefinition)record).getFields().forEach(field -> field.setAutotrimWhitespaces(null));
                }
            });
        }
        if ((value = statement.getParameter("NULL_INDICATOR_DESC").getValue(null)) != null) {
            descriptor.setNullIndicator(value);
        }
        if ((value = statement.getParameter("LINES_DELIMITER_DESC").getValue(null)) != null) {
            descriptor.setLinesDelimiter(value);
        }
        if ((value = statement.getParameter("recordDescription").getValue(null)) != null) {
            recordDefinition.setDescription(value);
        }
        if ((value = statement.getParameter("regexp").getValue(null)) != null) {
            if (descriptor.getFileFormat() != FileFormat.DELIMITED_REGEXP) {
                throw new Exception("Line regexp can be only set for DELIMITED_REGEXP file format.");
            }
            descriptor.setRegexp(value);
        }
        if (descriptor.getFileFormat() == FileFormat.CSV || descriptor.getFileFormat() == FileFormat.DELIMITED) {
            CreateSdoFromCsvOperation.DelimitedFileParameters params = CreateSdoFromCsvOperation.parseDelimitedFileParameters(statement, true);
            if (params.delimiter != null) {
                if (descriptor.getFileFormat() == FileFormat.CSV && !params.delimiter.trim().equals(",")) {
                    throw new Exception("Delimiter of CSV file can be set to comma only.");
                }
                descriptor.setDelimiter(params.delimiter.trim());
            }
            if (params.quoteSymbol != null) {
                descriptor.setQuoteSymbol(params.quoteSymbol.charValue());
            }
            if (params.quoteEscapeSymbol != null) {
                descriptor.setQuoteEscapeSymbol(params.quoteEscapeSymbol.charValue());
            }
            if (params.ignoreInnerQuotes != null) {
                descriptor.setIgnoreInnerQuotes(params.ignoreInnerQuotes);
            }
        }
        if ((value = statement.getParameter("eventId").getValue(null)) != null) {
            if (!(recordDefinition instanceof RecordTypeDefinition)) {
                throw new Exception("Event ID cannot be set for untyped record definition.");
            }
            ((RecordTypeDefinition)recordDefinition).setEventId(value);
        }
        if ((value = statement.getParameter("semanticType").getValue(null)) != null) {
            if (!(recordDefinition instanceof RecordTypeDefinition)) {
                throw new Exception("Semantic type cannot be set for untyped record definition.");
            }
            ((RecordTypeDefinition)recordDefinition).setSemanticType(value);
        }
        if ((statement.existsBlock("FieldsBlockset") || statement.existsBlock("FieldsBlockadd") || statement.existsSet("deleteFieldNames")) && (descriptor.getRecords() == null || descriptor.getRecords().size() != 1 || !(descriptor.getRecords().get(0) instanceof AbstractRecordTypeDefinition))) {
            throw new Exception("There should be only one record to change record fields.");
        }
        if (statement.existsBlock("FieldsBlockset")) {
            statement.getBlock("FieldsBlockset").getLines().forEach(line -> {
                String value;
                RecordField field = recordDefinition.getField(line.getParameter("fieldName").getValue());
                if (field == null) {
                    throw new RuntimeException("Field '" + line.getParameter("fieldName").getValue() + "' doesn't exist.");
                }
                if (line.existsParameter("description")) {
                    field.setDescription(line.getParameter("description").getValue());
                }
                if (line.existsModifier("TRIM_WHITESPACES_FIELD")) {
                    field.setAutotrimWhitespaces(true);
                }
                if (line.existsModifier("NOT_TRIM_WHITESPACES_FIELD")) {
                    field.setAutotrimWhitespaces(false);
                }
                if (line.existsModifier("NOT_NULLABLE")) {
                    field.setNullable(false);
                }
                if (line.existsModifier("NULLABLE")) {
                    field.setNullable(true);
                }
                if ((value = line.getParameter("NULL_INDICATOR_FIELD").getValue(null)) != null) {
                    field.setNullIndicator(value);
                }
                if (line.existsParameter("format")) {
                    field.setFormat(line.getParameter("format").getValue());
                }
                if (line.existsParameter("defaultValue")) {
                    field.setDefaultValue(line.getParameter("defaultValue").getValue());
                }
                if (line.existsParameter("fieldType")) {
                    field.setDataType(line.getParameter("fieldType").getValue());
                }
                if (line.existsParameter("spaths")) {
                    field.setSpaths(StringUtils.split(line.getParameter("spaths").getValue(), ',').toArray(new String[0]));
                }
                int startGroupIndex = line.getParameter("startIndex").getValue(-1);
                int endGroupIndex = line.getParameter("endIndex").getValue(-1);
                if (descriptor.getFileFormat() == FileFormat.DELIMITED_REGEXP) {
                    if (endGroupIndex < startGroupIndex) {
                        throw new RuntimeException("Invalid start and group index specified.");
                    }
                    field.setStart(startGroupIndex);
                    field.setEnd(endGroupIndex);
                }
            });
        }
        if (statement.existsBlock("FieldsBlockadd")) {
            statement.getBlock("FieldsBlockadd").getLines().forEach(line -> {
                String value;
                if (descriptor.getFileFormat() != FileFormat.CSV && descriptor.getFileFormat() != FileFormat.DELIMITED) {
                    throw new RuntimeException("Field can be added to CSV or Delimited file.");
                }
                String fieldName = line.getParameter("fieldName").getValue();
                RecordField field = recordDefinition.getField(fieldName);
                if (field != null) {
                    throw new RuntimeException("Field '" + fieldName + "' already exists.");
                }
                field = new RecordField();
                field.setFieldName(fieldName);
                int afterFieldPosition = -1;
                String afterFieldName = line.getParameter("afterFieldName").getValue();
                if (afterFieldName != null) {
                    afterFieldPosition = recordDefinition.getRecordFieldPosition(afterFieldName);
                    if (afterFieldPosition == -1) {
                        throw new RuntimeException("Field '" + afterFieldName + "' already exists.");
                    }
                    if (++afterFieldPosition == recordDefinition.getFields().size()) {
                        afterFieldPosition = -1;
                    }
                }
                if (line.existsParameter("description")) {
                    field.setDescription(line.getParameter("description").getValue());
                }
                if (line.existsModifier("TRIM_WHITESPACES_FIELD")) {
                    field.setAutotrimWhitespaces(true);
                }
                if (line.existsModifier("NOT_TRIM_WHITESPACES_FIELD")) {
                    field.setAutotrimWhitespaces(false);
                }
                if (line.existsModifier("NOT_NULLABLE")) {
                    field.setNullable(false);
                }
                if (line.existsModifier("NULLABLE")) {
                    field.setNullable(true);
                }
                if ((value = line.getParameter("NULL_INDICATOR_FIELD").getValue(null)) != null) {
                    field.setNullIndicator(value);
                }
                if (line.existsParameter("format")) {
                    field.setFormat(line.getParameter("format").getValue());
                }
                if (line.existsParameter("defaultValue")) {
                    field.setDefaultValue(line.getParameter("defaultValue").getValue());
                }
                if (line.existsParameter("fieldType")) {
                    field.setDataType(line.getParameter("fieldType").getValue());
                }
                if (line.existsParameter("spaths")) {
                    field.setSpaths(StringUtils.split(line.getParameter("spaths").getValue(), ',').toArray(new String[0]));
                }
                int startGroupIndex = line.getParameter("startIndex").getValue(-1);
                int endGroupIndex = line.getParameter("endIndex").getValue(-1);
                if (descriptor.getFileFormat() == FileFormat.DELIMITED_REGEXP) {
                    if (startGroupIndex == -1 || endGroupIndex == -1) {
                        throw new RuntimeException("Start and end group indexes should be specified for DELIMITED_REGEXP file.");
                    }
                    if (startGroupIndex == -1) {
                        startGroupIndex = field.getStart();
                    }
                    if (endGroupIndex == -1) {
                        endGroupIndex = field.getEnd();
                    }
                    if (endGroupIndex < startGroupIndex) {
                        throw new RuntimeException("Invalid start and group index specified.");
                    }
                    field.setStart(startGroupIndex);
                    field.setEnd(endGroupIndex);
                }
                if (afterFieldPosition == -1) {
                    recordDefinition.addRecordField(field);
                } else {
                    recordDefinition.addRecordField(afterFieldPosition, field);
                }
            });
        }
        if ((deleteFieldNamesSet = statement.getSet("deleteFieldNames")).isPresent()) {
            for (int i = 0; i < deleteFieldNamesSet.size(); ++i) {
                String deleteFieldName = deleteFieldNamesSet.getElement(i).getParameter("deleteFieldName").getValue();
                recordDefinition.deleteRecordField(deleteFieldName);
            }
        }
        FileDescriptorRepositoryUtils.saveFileDescriptor(descriptorName, descriptor);
        return new SLResponse();
    }

    public static class FileDescriptorNotSystemAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                return FileDescriptorRepositoryUtils.listFileDescriptors().stream().filter(name -> {
                    try {
                        return !FileDescriptorRepositoryUtils.lookupFileDescriptor(name).isSystem();
                    }
                    catch (Exception exception) {
                        Trace.logError(this, exception.getMessage());
                        return false;
                    }
                }).collect(Collectors.toList());
            }
            catch (ObjectConfigurationException exception) {
                Trace.logError(this, exception.getMessage());
                return Collections.emptyList();
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AlterFileDescriptorOperation.NAME);
            this.statement = statement;
        }
    }
}

