/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.sql.Statement;
import java.util.ArrayList;

public class PingConnectionOperation
extends AbstractConnectionFactoryOperation {
    public static final String NAME = "ping connection";

    public PingConnectionOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("PING CONNECTION").addActionParameter((SyntaxParameter)new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter().setCompletionAdviser(new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameCompletionAdviser().scopes(ListConnectionFactoriesOperation.FactoryScope.ALL).registered(true).notregistered(true)));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("query").setName("QueryModifier")).addParameter(new StringParameter("query"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("timeout").setName("TimeoutModifier")).addParameter(new IntegerParameter("timeout"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("with result").setRequired(false));
        this.syntax.setDescription("Tests connectivity using a specified connection factory and optionally tries to execute a query.\n\nIf connection opening fail, a vendor-specific error will be returned. The QUERY parameter is applicable\nto JDBC connection factories only. Queries will only be executed if a connection is opened successfully.\n\nParameters:\n\n  timeout     - Default is 30 seconds\n  query       - SQL query for JDBC connections.\n  with result - Returns the results of 'query' instead of a simple OK response.");
        this.syntax.setExamples("ping connection ExampleType.ExampleName query 'select 1'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        int timeout = 30;
        if (statement.getParameter("timeout").isPresent()) {
            timeout = Integer.valueOf(statement.getParameter("timeout").getValue());
        }
        return new Definition(statement.getParameter("FactoryType").getValue(), statement.getParameter("FactoryName").getValue(), statement.getParameter("query").getValue(), timeout, statement.existsModifier("with result"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String factoryType = ((Definition)statement).factoryType;
        String factoryName = ((Definition)statement).factoryName;
        int pingTimeout = ((Definition)statement).timeout;
        RepositoryAccessor repository = ((RuntimeContext)this.callable).getRepositoryAccessor();
        try {
            if (repository.existsJDBCFactory(factoryName, factoryType)) {
                return this.pingJdbcFactory(factoryType, factoryName, pingTimeout, ((Definition)statement).query, ((Definition)statement).withResult);
            }
            this.pingClientFactory(factoryType, factoryName, pingTimeout);
        }
        catch (Exception exception) {
            return new SLResponse(Utils.formatExceptionWithUnrepeatedCauses(exception), false);
        }
        return new SLResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingClientFactory(String factoryType, String factoryName, int pingTimeout) throws Exception {
        PackageLoaderHelper.loadPackageIfRegistered((FabricComponent)this.callable, PackageType.client.toString() + "." + factoryType);
        ClientFactory factory = ClientConfigurationFactory.loadFactoryObject((FabricComponent)this.callable, factoryName, factoryType, false);
        try {
            factory = new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(factory);
            factory.setReliable(false);
            factory.setConnectionTimeout(pingTimeout);
            ClientConnection connection = factory.createConnection();
            ArrayList exceptions = new ArrayList();
            connection.setExceptionEventListener(exceptions::add);
            connection.connect();
            connection.ping();
            if (connection.getState() != ConnectionState.CONNECTED) {
                ClientException exception;
                ClientException clientException = exception = exceptions.size() > 0 ? (ClientException)exceptions.get(exceptions.size() - 1) : null;
                if (exception != null) {
                    throw exception;
                }
                throw new Exception("Failed to connect and ping target. Connection state: " + String.valueOf((Object)connection.getState()));
            }
        }
        finally {
            factory.destroyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SLResponse pingJdbcFactory(String factoryType, String factoryName, int pingTimeout, String query, boolean withResult) throws Exception {
        PackageLoaderHelper.loadPackageIfRegistered(RuntimeContext.getInstance(), PackageType.jdbc.toString() + "." + factoryType);
        JDBCFactory jdbcFactory = JDBCConfigurationFactory.getJDBCFactory(RuntimeContext.getInstance(), factoryName, factoryType);
        try {
            jdbcFactory.setReliableConnection(false);
            jdbcFactory.setConnectionTimeout(pingTimeout);
            jdbcFactory.setQueryTimeout(pingTimeout);
            DatabaseConnection connection = jdbcFactory.createConnection();
            connection.connect();
            if (query != null) {
                Statement stm = connection.createStatement();
                stm.execute(query);
                if (withResult) {
                    SLResponse sLResponse = new SLResponse(new RowSetFactory().createRowSet(stm.getResultSet()));
                    return sLResponse;
                }
            }
        }
        finally {
            jdbcFactory.destroyAll();
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        String factoryType;
        String factoryName;
        String query;
        private int timeout;
        private final boolean withResult;

        public Definition(String factoryType, String factoryName, String query, int timeout, boolean withResult) {
            super(PingConnectionOperation.NAME);
            this.factoryType = factoryType;
            this.factoryName = factoryName;
            this.query = query;
            this.timeout = timeout;
            this.withResult = withResult;
        }
    }
}

