/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.lib.http.client.HTTPConnectionFactoryHelper;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateAwsConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.AbstractConnectionFactoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Subject;
import java.util.ArrayList;
import java.util.List;

public class ListConnectionFactoriesOperation
extends AbstractConnectionFactoryOperation {
    public static final String NAME = "list connection factories";

    public ListConnectionFactoriesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST");
        this.syntax.setPredicate((ChoiceModifier)new ChoiceModifier("SCOPE").addPossibleValues(FactoryScope.class).addPossibleValue("*").setRequired(false));
        this.syntax.setSubject(new Subject("CONNECTION FACTORIES"));
        this.syntax.setDescription("Returns a list of connection factories in the node.");
        this.syntax.setSyntaxDescription("list all connection factories        - Returns a list of all connection factories in the node.\nlist db connection factories         - Returns a list of DB connection factories in the node.\nlist transport connection factories  - Returns a list of transport connection factories in the node.\nlist client connection factories     - Returns a list of client connection factories in the node.\nlist http connection factories       - Returns a list of http client connection factories in the node.\nlist registered connection factories - Returns a list of connection factories prototypes in the node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getModifier("SCOPE").isPresent()) {
            return new Definition(FactoryScope.valueOf(statement.getModifier("SCOPE").getToken()));
        }
        return new Definition(FactoryScope.ALL);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListConnectionFactoriesOperation.createResultDescriptor());
        Definition definition = (Definition)statement;
        if (definition.scope == FactoryScope.ALL) {
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.DB, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.DB, false));
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.TRANSPORT, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.TRANSPORT, false));
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.CLIENT, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.CLIENT, false));
        } else if (definition.scope == FactoryScope.REGISTERED) {
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.DB, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.DB, true));
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.TRANSPORT, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.TRANSPORT, true));
            this.addToResultRowSet((RuntimeContext)this.callable, result, FactoryScope.CLIENT, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, FactoryScope.CLIENT, true));
        } else {
            this.addToResultRowSet((RuntimeContext)this.callable, result, definition.scope, ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, definition.scope, false));
        }
        return new SLResponse(result);
    }

    private void addToResultRowSet(RuntimeContext context, RowSet result, FactoryScope scope, List<String> names) throws Exception {
        for (String fullName : names) {
            int dot = fullName.indexOf(46);
            String type = fullName.substring(0, dot);
            String name = fullName.substring(dot + 1);
            String description = null;
            if (scope == FactoryScope.CLIENT) {
                description = context.getRepositoryAccessor().loadClientFactory(name, type).getDescription();
            } else if (scope == FactoryScope.HTTP) {
                factory = context.getRepositoryAccessor().loadClientFactory(name, type);
                if (!HTTPConnectionFactoryHelper.isHttpFactory(factory)) continue;
                description = factory.getDescription();
            } else if (scope == FactoryScope.AWS) {
                factory = context.getRepositoryAccessor().loadClientFactory(name, type);
                if (!AbstractAlterCreateAwsConnectionFactoryOperation.isAwsFactory(factory)) continue;
                description = factory.getDescription();
            } else if (scope == FactoryScope.DB) {
                description = context.getRepositoryAccessor().loadJDBCFactory(name, type).getDescription();
            } else if (scope == FactoryScope.TRANSPORT) {
                description = context.getRepositoryAccessor().loadTransportFactory(name, type).getDescription();
            }
            result.addToRowSet(new Object[]{scope.toString().toLowerCase(), type, name, description});
        }
    }

    public static List<String> listConnectionFactories(RuntimeContext context, FactoryScope scope, boolean registered) throws Exception {
        return ListConnectionFactoriesOperation.listConnectionFactories(context.getRepositoryAccessor(), scope, registered);
    }

    public static List<String> listConnectionFactories(RepositoryAccessor repositoryAccessor, FactoryScope scope, boolean registered) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (scope == FactoryScope.ALL || scope == FactoryScope.CLIENT) {
            for (String type : repositoryAccessor.listClientFactoryTypes()) {
                ListConnectionFactoriesOperation.addToResultList(result, type, repositoryAccessor.listClientFactoriesByType(type), registered);
            }
        }
        if (scope == FactoryScope.HTTP) {
            for (String type : repositoryAccessor.listClientFactoryTypes()) {
                for (String name : repositoryAccessor.listClientFactoriesByType(type)) {
                    if (!HTTPConnectionFactoryHelper.isHttpFactory(repositoryAccessor.loadClientFactory(name, type))) continue;
                    ListConnectionFactoriesOperation.addToResultList(result, type, name, registered);
                }
            }
        }
        if (scope == FactoryScope.AWS) {
            for (String type : repositoryAccessor.listClientFactoryTypes()) {
                for (String name : repositoryAccessor.listClientFactoriesByType(type)) {
                    if (!AbstractAlterCreateAwsConnectionFactoryOperation.isAwsFactory(repositoryAccessor.loadClientFactory(name, type))) continue;
                    ListConnectionFactoriesOperation.addToResultList(result, type, name, registered);
                }
            }
        }
        if (scope == FactoryScope.ALL || scope == FactoryScope.DB) {
            for (String type : repositoryAccessor.listJDBCFactoryTypes()) {
                ListConnectionFactoriesOperation.addToResultList(result, type, repositoryAccessor.listJDBCFactoriesByType(type), registered);
            }
        }
        if (scope == FactoryScope.ALL || scope == FactoryScope.TRANSPORT) {
            for (String type : repositoryAccessor.listTransportFactoryTypes()) {
                ListConnectionFactoriesOperation.addToResultList(result, type, repositoryAccessor.listTransportFactoriesByType(type), registered);
            }
        }
        return result;
    }

    private static void addToResultList(List<String> result, String type, List<String> names, boolean registered) {
        for (String name : names) {
            ListConnectionFactoriesOperation.addToResultList(result, type, name, registered);
        }
    }

    private static void addToResultList(List<String> result, String type, String name, boolean registered) {
        if (!(registered ^ name.equalsIgnoreCase("prototype"))) {
            result.add(type + "." + name);
        }
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListConnectionFactoriesOperation.addColumn(result, "Scope");
        ListConnectionFactoriesOperation.addColumn(result, "Type");
        ListConnectionFactoriesOperation.addColumn(result, "Name");
        ListConnectionFactoriesOperation.addColumn(result, "Description");
        return result;
    }

    public static enum FactoryScope {
        DB,
        TRANSPORT,
        CLIENT,
        HTTP,
        AWS,
        ALL,
        REGISTERED;

    }

    public static class Definition
    extends AbstractSLStatement {
        FactoryScope scope;

        public Definition(FactoryScope scope) {
            super(ListConnectionFactoriesOperation.NAME);
            this.scope = scope;
        }
    }
}

