/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.modifier.Subject;
import java.util.List;

public class DropConnectionFactoryOperation
extends AbstractConnectionFactoryOperation {
    public static final String NAME = "drop connection factory";

    public DropConnectionFactoryOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP");
        this.syntax.setPredicate(new Predicate("").addPossibleValue(ListConnectionFactoriesOperation.FactoryScope.CLIENT.toString()).addPossibleValue(ListConnectionFactoriesOperation.FactoryScope.HTTP.toString()).addPossibleValue(ListConnectionFactoriesOperation.FactoryScope.AWS.toString()).addPossibleValue(ListConnectionFactoriesOperation.FactoryScope.DB.toString()).addPossibleValue(ListConnectionFactoriesOperation.FactoryScope.TRANSPORT.toString()));
        this.syntax.setSubject(new Subject("CONNECTION FACTORY"));
        this.syntax.addParameter(new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter());
        this.syntax.setDescription("Drops specified connection factory in the node.");
        this.syntax.addCompletionCommand("list connection factories");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, ListConnectionFactoriesOperation.FactoryScope.ALL, true));
            completions.addAll(ListConnectionFactoriesOperation.listConnectionFactories((RuntimeContext)this.callable, ListConnectionFactoriesOperation.FactoryScope.ALL, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        ListConnectionFactoriesOperation.FactoryScope scope = ListConnectionFactoriesOperation.FactoryScope.valueOf(statement.getPredicate().getToken());
        return new Definition(statement.getDefinition(), scope, statement.getParameter("FactoryType").getValue(), statement.getParameter("FactoryName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (definition.scope == ListConnectionFactoriesOperation.FactoryScope.DB) {
            repositoryAccessor.removeJDBCFactory(definition.factoryName, definition.factoryType);
        } else if (definition.scope == ListConnectionFactoriesOperation.FactoryScope.CLIENT || definition.scope == ListConnectionFactoriesOperation.FactoryScope.HTTP || definition.scope == ListConnectionFactoriesOperation.FactoryScope.AWS) {
            repositoryAccessor.removeClientFactory(definition.factoryName, definition.factoryType);
        } else if (definition.scope == ListConnectionFactoriesOperation.FactoryScope.TRANSPORT) {
            repositoryAccessor.removeTransportFactory(definition.factoryName, definition.factoryType);
        } else {
            throw new Exception("Invalid factory type " + String.valueOf((Object)definition.scope));
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        ListConnectionFactoriesOperation.FactoryScope scope;
        String factoryType;
        String factoryName;

        public Definition(String name, ListConnectionFactoriesOperation.FactoryScope scope, String factoryType, String factoryName) {
            super(name);
            this.scope = scope;
            this.factoryType = factoryType;
            this.factoryName = factoryName;
        }
    }
}

