/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeConnectionFactoryOperation
extends AbstractConnectionFactoryOperation {
    public static final String NAME = "describe connection factory";
    public static final String PROPERTY_FACTORY_SCOPE = "Scope";
    public static final String PROPERTY_FACTORY_TYPE = "Type";
    public static final String PROPERTY_FACTORY_NAME = "Name";
    public static final String PROPERTY_FACTORY_DESCRIPTION = "Description";
    public static final String PROPERTY_FACTORY_VENDOR_STRING = "Vendor";
    public static final String PROPERTY_FACTORY_URL = "URL";
    public static final String PROPERTY_FACTORY_DEFAULT_USER = "Default User";
    public static final String PROPERTY_FACTORY_DEFAULT_PASSWORD = "Default Password";
    public static final String PROPERTY_FACTORY_MAJOR_VERSION = "Major Version";
    public static final String PROPERTY_FACTORY_MINOR_VERSION = "Minor Version";
    public static final String PROPERTY_FACTORY_CONNECTION_CLASS_NAME = "Connection Class Name";
    public static final String PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL = "Check Interval";
    public static final String PROPERTY_FACTORY_CONNECTION_TIMEOUT = "Connection Timeout";
    public static final String PROPERTY_FACTORY_RECONNECTION_RETRIES = "Reconnection Retries";
    public static final String PROPERTY_FACTORY_IS_LIFE_CYCLE_MANAGED = "Is Life Cycle Managed";
    public static final String PROPERTY_FACTORY_IS_RELIABLE_CONNECTION = "Is Reliable";
    public static final String PROPERTY_FACTORY_CONNECTION_CLASS_NAME_C = "jdbcDriverClass";
    public static final String PROPERTY_FACTORY_DESCRIPTION_CS = "description";
    public static final String PROPERTY_FACTORY_URL_CS = "url";
    public static final String PROPERTY_FACTORY_DEFAULT_USER_CS = "defaultUser";
    public static final String PROPERTY_FACTORY_DEFAULT_PASSWORD_CS = "defaultPassword";
    public static final String PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL_CS = "checkInterval";
    public static final String PROPERTY_FACTORY_CONNECTION_TIMEOUT_CS = "connectionTimeout";
    public static final String PROPERTY_FACTORY_RECONNECTION_RETRIES_CS = "reconnectionRetries";
    public static final String PROPERTY_FACTORY_IS_RELIABLE_CONNECTION_CS = "isReliable";
    public static final String JDBC_PROPERTY_FACTORY_RECONNECT_INTERVAL = "Reconnect Interval";
    public static final String JDBC_PROPERTY_FACTORY_CATALOG = "Catalog";
    public static final String JDBC_PROPERTY_FACTORY_AUTO_COMMIT = "Auto Commit";
    public static final String JDBC_PROPERTY_FACTORY_HOLDABILITY = "Holdability";
    public static final String JDBC_PROPERTY_FACTORY_POLLING_QUERY = "Polling Query";
    public static final String JDBC_PROPERTY_FACTORY_QUERY_TIMEOUT = "Query Timeout";
    public static final String JDBC_PROPERTY_FACTORY_READOLNY = "Read Only";
    public static final String JDBC_PROPERTY_FACTORY_ISOLATION_LEVEL = "Isolation Level";
    public static final String JDBC_PROPERTY_FACTORY_RECONNECT_INTERVAL_CS = "reconnectInterval";
    public static final String JDBC_PROPERTY_FACTORY_CATALOG_CS = "catalog";
    public static final String JDBC_PROPERTY_FACTORY_AUTO_COMMIT_CS = "autocommit";
    public static final String JDBC_PROPERTY_FACTORY_HOLDABILITY_CS = "holdability";
    public static final String JDBC_PROPERTY_FACTORY_POLLING_QUERY_CS = "pollingQuery";
    public static final String JDBC_PROPERTY_FACTORY_QUERY_TIMEOUT_CS = "queryTimeout";
    public static final String JDBC_PROPERTY_FACTORY_READOLNY_CS = "isReadOnly";
    public static final String JDBC_PROPERTY_FACTORY_ISOLATION_LEVEL_CS = "isolationLevel";

    public DescribeConnectionFactoryOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE CONNECTION FACTORY").addActionParameter((SyntaxParameter)new ConnectionFactoryTypeNameParameter().setCompletionAdviser(new ConnectionFactoryTypeNameCompletionAdviser().scopes(ListConnectionFactoriesOperation.FactoryScope.ALL).registered(false).notregistered(true)));
        this.syntax.setDescription("Shows information about the specified connection factory.");
        this.syntax.setExamples("describe connection factory ExampleType.ExampleName");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("FactoryType").getValue(), statement.getParameter("FactoryName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        return new SLResponse(DescribeConnectionFactoryOperation.getResultRowSet((RuntimeContext)this.callable, definition.factoryType, definition.factoryName));
    }

    public static RowSet getResultRowSet(RuntimeContext context, String type, String name) throws Exception {
        RowSet result = DescribeConnectionFactoryOperation.invokeClientFactory(context, type, name);
        if (result == null && (result = DescribeConnectionFactoryOperation.invokeJDBCFactory(context, type, name)) == null && (result = DescribeConnectionFactoryOperation.invokeTransportFactory(context, type, name)) == null) {
            throw new Exception("Connection factory not found.");
        }
        return result;
    }

    public static RowSet invokeClientFactory(RuntimeContext context, String type, String name) throws Exception {
        RepositoryAccessor repositoryAccessor = context.getRepositoryAccessor();
        if (!repositoryAccessor.existsClientFactory(name, type)) {
            return null;
        }
        ClientFactory factory = repositoryAccessor.loadClientFactory(name, type);
        RowSet result = new RowSet(DescribeConnectionFactoryOperation.createResultDescriptor());
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_SCOPE, ListConnectionFactoriesOperation.FactoryScope.CLIENT.name().toLowerCase(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_TYPE, factory.getFactoryType(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_NAME, factory.getFactoryName(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DESCRIPTION, factory.getDescription(), PROPERTY_FACTORY_DESCRIPTION_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_VENDOR_STRING, factory.getVendorString(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_URL, factory.getUrl(), PROPERTY_FACTORY_URL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_USER, factory.getDefaultUser(), PROPERTY_FACTORY_DEFAULT_USER_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_PASSWORD, "*******", PROPERTY_FACTORY_DEFAULT_PASSWORD_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MAJOR_VERSION, factory.getMajorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MINOR_VERSION, factory.getMinorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CLASS_NAME, factory.getConnectionClassName(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL, factory.getCheckInterval(), PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_TIMEOUT, factory.getConnectionTimeout(), PROPERTY_FACTORY_CONNECTION_TIMEOUT_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_RECONNECTION_RETRIES, factory.getReconnectRetries(), PROPERTY_FACTORY_RECONNECTION_RETRIES_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_LIFE_CYCLE_MANAGED, factory.isManaged(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_RELIABLE_CONNECTION, factory.isReliable(), PROPERTY_FACTORY_IS_RELIABLE_CONNECTION_CS, false);
        if (HTTPConnection.class.getName().equals(factory.getConnectionClassName())) {
            DescribeConnectionFactoryOperation.addHttpPropertiesToResultSet(result, factory);
        } else {
            for (String property : factory.listProperties()) {
                DescribeConnectionFactoryOperation.addToResult(result, property, factory.getProperty(property), property, true);
            }
        }
        return result;
    }

    private static void addHttpPropertiesToResultSet(RowSet result, ClientFactory factory) throws Exception {
        List<String> names = Arrays.asList(PROPERTY_FACTORY_NAME, "EnableOAuth", "ProxyHost", "ProxyPort", "ProxyUser", "ProxyPort", "TrustStore.file", "KeyStore.password", "TrustStore.file", "TrustAllCertificates", "Realms", "DefaultAuth");
        HashMap<Object, Object> properties = new HashMap<Object, Object>(factory.getProperties());
        for (String string : names) {
            Object value = properties.remove(string);
            if (value == null) {
                value = string.equals("EnableOAuth") || string.equals("TrustAllCertificates") ? "false" : "";
            }
            result.addToRowSet(new Object[]{string, value, string, "x"});
        }
        for (Map.Entry entry : properties.entrySet()) {
            DescribeConnectionFactoryOperation.addToResult(result, (String)entry.getKey(), entry.getValue(), (String)entry.getKey(), true);
        }
    }

    public static RowSet invokeJDBCFactory(RuntimeContext context, String type, String name) throws Exception {
        RepositoryAccessor repositoryAccessor = context.getRepositoryAccessor();
        if (!repositoryAccessor.existsJDBCFactory(name, type)) {
            return null;
        }
        JDBCFactory factory = repositoryAccessor.loadJDBCFactory(name, type);
        RowSet result = new RowSet(DescribeConnectionFactoryOperation.createResultDescriptor());
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_SCOPE, ListConnectionFactoriesOperation.FactoryScope.DB.name().toLowerCase(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_TYPE, factory.getFactoryType(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_NAME, factory.getFactoryName(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DESCRIPTION, factory.getDescription(), PROPERTY_FACTORY_DESCRIPTION_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_VENDOR_STRING, factory.getVendorString(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_URL, factory.getUrl(), PROPERTY_FACTORY_URL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_USER, factory.getDefaultUser(), PROPERTY_FACTORY_DEFAULT_USER_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_PASSWORD, "*******", PROPERTY_FACTORY_DEFAULT_PASSWORD_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MAJOR_VERSION, factory.getMajorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MINOR_VERSION, factory.getMinorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CLASS_NAME, factory.getJDBCDriverClassName(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL, factory.getConnectionCheckInterval(), PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_TIMEOUT, factory.getConnectionTimeout(), PROPERTY_FACTORY_CONNECTION_TIMEOUT_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_RECONNECTION_RETRIES, factory.getReconnectRetries(), PROPERTY_FACTORY_RECONNECTION_RETRIES_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_LIFE_CYCLE_MANAGED, factory.isLifeCycleManaged(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_RELIABLE_CONNECTION, factory.isReliableConnection(), PROPERTY_FACTORY_IS_RELIABLE_CONNECTION_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_RECONNECT_INTERVAL, factory.getReconnectInterval(), JDBC_PROPERTY_FACTORY_RECONNECT_INTERVAL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_CATALOG, factory.getCatalog(), JDBC_PROPERTY_FACTORY_CATALOG_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_AUTO_COMMIT, factory.getAutoCommit(), JDBC_PROPERTY_FACTORY_AUTO_COMMIT_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_HOLDABILITY, factory.getHoldability(), JDBC_PROPERTY_FACTORY_HOLDABILITY_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_POLLING_QUERY, factory.getPollingQuery(), JDBC_PROPERTY_FACTORY_POLLING_QUERY_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_QUERY_TIMEOUT, factory.getQueryTimeout(), JDBC_PROPERTY_FACTORY_QUERY_TIMEOUT_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_READOLNY, factory.getReadOnly(), JDBC_PROPERTY_FACTORY_READOLNY_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, JDBC_PROPERTY_FACTORY_ISOLATION_LEVEL, factory.getTransactionIsolation(), JDBC_PROPERTY_FACTORY_ISOLATION_LEVEL_CS, false);
        for (Map.Entry<Object, Object> entry : factory.getProperties().entrySet()) {
            DescribeConnectionFactoryOperation.addToResult(result, (String)entry.getKey(), entry.getValue(), (String)entry.getKey(), true);
        }
        return result;
    }

    public static RowSet invokeTransportFactory(RuntimeContext context, String type, String name) throws Exception {
        RepositoryAccessor repositoryAccessor = context.getRepositoryAccessor();
        if (!repositoryAccessor.existsTransportFactory(name, type)) {
            return null;
        }
        TransportFactory factory = repositoryAccessor.loadTransportFactory(name, type);
        RowSet result = new RowSet(DescribeConnectionFactoryOperation.createResultDescriptor());
        for (String property : factory.listFactoryProperties()) {
            result.addToRowSet(new Object[]{property, factory.getProperty(property)});
        }
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_SCOPE, ListConnectionFactoriesOperation.FactoryScope.CLIENT.name().toLowerCase(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_TYPE, factory.getFactoryType(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_NAME, factory.getFactoryName(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DESCRIPTION, factory.getDescription(), PROPERTY_FACTORY_DESCRIPTION_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_VENDOR_STRING, factory.getVendorString(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_URL, factory.getDefaultUrl(), PROPERTY_FACTORY_URL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_USER, factory.getDefaultUser(), PROPERTY_FACTORY_DEFAULT_USER_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_DEFAULT_PASSWORD, "*******", PROPERTY_FACTORY_DEFAULT_PASSWORD_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MAJOR_VERSION, factory.getMajorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_MINOR_VERSION, factory.getMinorVersion(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CLASS_NAME, factory.getConnectionFactoryClass(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL, factory.getConnectionCheckInterval(), PROPERTY_FACTORY_CONNECTION_CHECK_INTERVAL_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_CONNECTION_TIMEOUT, factory.getConnectionTimeout(), PROPERTY_FACTORY_CONNECTION_TIMEOUT_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_RECONNECTION_RETRIES, factory.getTransportReconnectRetries(), PROPERTY_FACTORY_RECONNECTION_RETRIES_CS, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_LIFE_CYCLE_MANAGED, factory.isLifeCycleManaged(), null, false);
        DescribeConnectionFactoryOperation.addToResult(result, PROPERTY_FACTORY_IS_RELIABLE_CONNECTION, factory.isReliableConnection(), PROPERTY_FACTORY_IS_RELIABLE_CONNECTION_CS, false);
        for (String property : factory.listFactoryProperties()) {
            DescribeConnectionFactoryOperation.addToResult(result, property, factory.getProperty(property), property, true);
        }
        return result;
    }

    private static void addToResult(RowSet result, String propertyName, Object propertyValue, String editName, boolean userDefined) throws Exception {
        result.addToRowSet(new Object[]{propertyName, propertyValue, editName != null ? editName : "-", userDefined ? "x" : ""});
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeConnectionFactoryOperation.addColumn(result, "Property");
        DescribeConnectionFactoryOperation.addColumn(result, "Value");
        DescribeConnectionFactoryOperation.addColumn(result, "Editable");
        DescribeConnectionFactoryOperation.addColumn(result, "User Defined");
        return result;
    }

    public static class ConnectionFactoryTypeNameParameter
    extends CompoundParameter {
        public ConnectionFactoryTypeNameParameter() {
            this("FactoryType", "FactoryName");
        }

        ConnectionFactoryTypeNameParameter(String factoryTypeName, String factoryNameName) {
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter(DescribeConnectionFactoryOperation.PROPERTY_FACTORY_TYPE).setName(factoryTypeName));
            this.addParameter((AbstractParameter)new IdentifierParameter(DescribeConnectionFactoryOperation.PROPERTY_FACTORY_NAME).setName(factoryNameName));
        }
    }

    public static class ConnectionFactoryTypeNameCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        private ListConnectionFactoriesOperation.FactoryScope[] scopes = new ListConnectionFactoriesOperation.FactoryScope[]{ListConnectionFactoriesOperation.FactoryScope.ALL};
        private boolean registered = true;
        private boolean notregistered = true;

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                ArrayList<String> result = new ArrayList<String>();
                for (ListConnectionFactoriesOperation.FactoryScope scope : this.scopes) {
                    if (this.registered) {
                        result.addAll(ListConnectionFactoriesOperation.listConnectionFactories(callable, scope, true));
                    }
                    if (!this.notregistered) continue;
                    result.addAll(ListConnectionFactoriesOperation.listConnectionFactories(callable, scope, false));
                }
                return result;
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to get list of factories. Cause: " + exception.getMessage());
                return null;
            }
        }

        public ConnectionFactoryTypeNameCompletionAdviser scopes(ListConnectionFactoriesOperation.FactoryScope ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public ConnectionFactoryTypeNameCompletionAdviser registered(boolean registered) {
            this.registered = registered;
            return this;
        }

        public ConnectionFactoryTypeNameCompletionAdviser notregistered(boolean notregistered) {
            this.notregistered = notregistered;
            return this;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        String factoryType;
        String factoryName;

        public Definition(String factoryType, String factoryName) {
            super(DescribeConnectionFactoryOperation.NAME);
            this.factoryType = factoryType;
            this.factoryName = factoryName;
        }
    }
}

