/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateTransportConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.slex.lang.DSLStatement;

public class CreateTransportConnectionFactoryOperation
extends AbstractAlterCreateTransportConnectionFactoryOperation {
    public static final String NAME = "create transport connection factory";

    public CreateTransportConnectionFactoryOperation() {
        super(NAME, false);
        this.syntax.setDescription("Creates specified transport connection factory.");
        this.syntax.setExamples("create transport connection factory MyName \n url 'localhost'\n connection class 'my.client.conneciton.class'\n type MyType\n properties(description = 'my connection')");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repositoryAccessor.existsTransportFactory(factoryName, factoryType)) {
            throw new Exception("Specified transport factory '" + factoryType + "." + factoryName + "' already exist.");
        }
        String className = statement.getParameter("ClassName").getValue();
        String url = statement.getParameter("UrlValue").getValue();
        TransportFactory factory = TransportConfigurationFactory.createFactory((FabricComponent)this.callable, factoryType, factoryName, className, url, true, false);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveTransportFactory(factory);
        return new SLResponse();
    }
}

