/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateHttpConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.lang.DSLStatement;

public class CreateHttpConnectionFactoryOperation
extends AbstractAlterCreateHttpConnectionFactoryOperation {
    public static final String NAME = "create http connection factory";

    public CreateHttpConnectionFactoryOperation() {
        super(NAME, false);
        this.syntax.setDescription("Creates http connection factory.");
        this.syntax.setExamples("create http connection factory Stocks \n url 'http://stocks.com'\n set properties(description = 'Streamscape Dataspace Driver')");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repositoryAccessor.existsClientFactory(factoryName, factoryType)) {
            throw new Exception("Specified client factory '" + factoryType + "." + factoryName + "' already exist.");
        }
        String url = statement.getParameter("UrlValue").getValue();
        ClientFactory factory = ClientConfigurationFactory.createFactory((FabricComponent)this.callable, factoryType, factoryName, HTTPConnection.class.getName(), url, true, false);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveClientFactory(factory);
        return new SLResponse();
    }
}

