/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateDBConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.slex.lang.DSLStatement;

public class CreateDBConnectionFactoryOperation
extends AbstractAlterCreateDBConnectionFactoryOperation {
    public static final String NAME = "create db connection factory";

    public CreateDBConnectionFactoryOperation() {
        super(NAME, false);
        this.syntax.setDescription("Creates db connection factory.");
        this.syntax.setExamples("create db connection factory MyName \n url 'jdbc:streamscape:dataspace://localhost:11001/TSPACE.MY_TSPACE'\n driver class 'com.streamscape.ds.jdbc.JDBCDriver'\n type MyType\n set properties(description = 'Streamscape Dataspace Driver')");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repositoryAccessor.existsJDBCFactory(factoryName, factoryType)) {
            throw new Exception("Specified jdbc factory '" + factoryType + "." + factoryName + "' already exist.");
        }
        String className = statement.getParameter("ClassName").getValue();
        String url = statement.getParameter("UrlValue").getValue();
        JDBCFactory factory = JDBCConfigurationFactory.createFactory((FabricComponent)this.callable, factoryName, factoryType, className, url, true, false);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveJDBCFactory(factory);
        return new SLResponse();
    }
}

