/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateClientConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.lang.DSLStatement;

public class CreateClientConnectionFactoryOperation
extends AbstractAlterCreateClientConnectionFactoryOperation {
    public static final String NAME = "create client connection factory";

    public CreateClientConnectionFactoryOperation() {
        super(NAME, false);
        this.syntax.setDescription("Creates specified client connection factory.");
        this.syntax.setExamples("create client connection factory MyName \n url 'localhost'\n connection class 'my.client.connection.class'\n type MyType\n set properties(description = 'my connection')");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repositoryAccessor.existsClientFactory(factoryName, factoryType)) {
            throw new Exception("Specified client factory '" + factoryType + "." + factoryName + "' already exist.");
        }
        String className = statement.getParameter("ClassName").getValue();
        String url = statement.getParameter("UrlValue").getValue();
        ClientFactory factory = ClientConfigurationFactory.createFactory((FabricComponent)this.callable, factoryType, factoryName, className, url, true, false);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveClientFactory(factory);
        return new SLResponse();
    }
}

