/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateAwsConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.lang.DSLStatement;

public class CreateAwsConnectionFactoryOperation
extends AbstractAlterCreateAwsConnectionFactoryOperation {
    public static final String NAME = "create aws connection factory";

    public CreateAwsConnectionFactoryOperation() {
        super(NAME, false);
        this.syntax.setDescription("Creates AWS connection factory.\n\nAWS credentials can be specified in two ways:\n   - by specifying aws.profile property to the name of AWS profile configured in <usedir>/.aws/credentials file\nor\n   - by specifying aws.access.key.id, aws.secret.access.key and aws.region properites\nor\n   - by specifying aws.provider with 'default' value, means to use AWS credentials provider chain that looks for credentials in this order:\n         1. Java System Properties - aws.accessKeyId and aws.secretAccessKey\n         2. Environment Variables - AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY\n         3. Credential profiles file at the default location (~/.aws/credentials) shared by all AWS SDKs and the AWS CLI\n         4. Credentials delivered through the Amazon EC2 container service if AWS_CONTAINER_CREDENTIALS_RELATIVE_URI\"             environment variable is set and security manager has permission to access the variable,\n         5. Instance profile credentials delivered through the Amazon EC2 metadata service\n");
        this.syntax.setExamples("create aws connection factory MyAwsWithProfile \n   set properties(aws.profile = 'default')\n\ncreate aws connection factory MyAwsWithCreds \n   set properties(aws.access.key.id = 'xxxx', aws.secret.access.key = 'yyyy', aws.region = 'us-east-1')\n\ncreate aws connection factory MyAwsWithProvider \n   set properties(aws.provider = 'default')\n");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repositoryAccessor.existsClientFactory(factoryName, factoryType)) {
            throw new Exception("Specified client factory '" + factoryType + "." + factoryName + "' already exist.");
        }
        String url = statement.getParameter("UrlValue").getValue();
        if (url == null) {
            url = "amazon.com";
        }
        ClientFactory factory = ClientConfigurationFactory.createFactory((FabricComponent)this.callable, factoryType, factoryName, "com.streamscape.aws.client.AwsClientConnection", url, true, false);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveClientFactory(factory);
        return new SLResponse();
    }
}

