/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateTransportConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.slex.lang.DSLStatement;

public class AlterTransportConnectionFactoryOperation
extends AbstractAlterCreateTransportConnectionFactoryOperation {
    public static final String NAME = "alter transport connection factory";

    public AlterTransportConnectionFactoryOperation() {
        super(NAME, true);
        this.syntax.setDescription("Alters specified transport connection factory.");
        this.syntax.setExamples("alter transport connection factory MyType.MyName properties(checkInterval=5000) ");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (!repositoryAccessor.existsTransportFactory(factoryName, factoryType)) {
            throw new Exception("Specified transport factory doesn't exist.");
        }
        TransportFactory factory = repositoryAccessor.loadTransportFactory(factoryName, factoryType);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveTransportFactory(factory);
        return new SLResponse();
    }
}

