/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateDBConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.slex.lang.DSLStatement;

public class AlterDBConnectionFactoryOperation
extends AbstractAlterCreateDBConnectionFactoryOperation {
    public static final String NAME = "alter db connection factory";

    public AlterDBConnectionFactoryOperation() {
        super(NAME, true);
        this.syntax.setDescription("Alters specified db connection factory properties.");
        this.syntax.setExamples("alter db connection factory MyType.MyName set properties(checkInterval=5000) ");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (!repositoryAccessor.existsJDBCFactory(factoryName, factoryType)) {
            throw new Exception("Specified jdbc factory doesn't exist.");
        }
        JDBCFactory factory = repositoryAccessor.loadJDBCFactory(factoryName, factoryType);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveJDBCFactory(factory);
        return new SLResponse();
    }
}

