/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateClientConnectionFactoryOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.lang.DSLStatement;

public class AlterClientConnectionFactoryOperation
extends AbstractAlterCreateClientConnectionFactoryOperation {
    public static final String NAME = "alter client connection factory";

    public AlterClientConnectionFactoryOperation() {
        super(NAME, true);
        this.syntax.setDescription("Alters specified client connection factory.");
        this.syntax.setExamples("alter client connection factory MyType.MyName set properties(checkInterval=5000)\nalter client connection factory SFConnectionFactory.MySalesforce add properties (recourseDirectory='/services/data/v52.0')");
    }

    @Override
    protected SLResponse onInvoke(DSLStatement statement, String factoryType, String factoryName) throws Exception {
        RepositoryAccessor repositoryAccessor = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (!repositoryAccessor.existsClientFactory(factoryName, factoryType)) {
            throw new Exception("Specified client factory doesn't exist.");
        }
        ClientFactory factory = repositoryAccessor.loadClientFactory(factoryName, factoryType);
        this.setFactoryProperties(statement, factory);
        repositoryAccessor.saveClientFactory(factory);
        return new SLResponse();
    }
}

