/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.ds.schema.server.web.WebServerDSLProvider;
import com.streamscape.lib.http.client.HTTPConnectionFactoryHelper;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateClientConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.AbstractAlterCreateConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAlterCreateHttpConnectionFactoryOperation
extends AbstractAlterCreateConnectionFactoryOperation {
    public AbstractAlterCreateHttpConnectionFactoryOperation(String name, boolean alter) {
        super(name, ListConnectionFactoriesOperation.FactoryScope.HTTP, alter);
    }

    @Override
    protected String getFactoryType() {
        return "HTTP";
    }

    @Override
    protected void addSpecificFactorySetProperties(BlockModifier block) {
        block.addModifier(this.createAssignPropertyModifier("Name", new StringParameter("name")));
        block.addModifier(this.createAssignPropertyModifier("EnableOAuth", new BooleanParameter("true|false")));
        block.addModifier(this.createAssignPropertyModifier("ProxyHost", new StringParameter("host")));
        block.addModifier(this.createAssignPropertyModifier("ProxyPort", new IntegerParameter("port")));
        block.addModifier(this.createAssignPropertyModifier("ProxyUser", new StringParameter("user")));
        block.addModifier(this.createAssignPropertyModifier("ProxyPassword", new StringParameter("password")));
        block.addModifier(this.createAssignPropertyModifier("TrustStore.file", new StringParameter("trustStoreFile")));
        block.addModifier(this.createAssignPropertyModifier("TrustCertificate", new StringParameter("trustCertificate")));
        block.addModifier(this.createAssignPropertyModifier("TrustAllCertificates", new BooleanParameter("trustAllCertificates")));
        block.addModifier(this.createAssignPropertyModifier("KeyStore.file", new BooleanParameter("keyStoreFile")));
        block.addModifier(this.createAssignPropertyModifier("KeyStore.password", new BooleanParameter("keyStorePassword")));
    }

    protected void setFactoryProperties(DSLStatement statement, ClientFactory factory) throws Exception {
        HTTPConnectionFactoryHelper helper = new HTTPConnectionFactoryHelper(factory);
        AbstractAlterCreateConnectionFactoryOperation.PropertyObserver onSetProperty = (propertyName, propertyValue) -> {
            if (propertyName.equalsIgnoreCase("Name")) {
                helper.setName(propertyValue);
            } else if (propertyName.equalsIgnoreCase("EnableOAuth")) {
                helper.setEnableOAuth(Boolean.valueOf(propertyValue));
            } else if (propertyName.equalsIgnoreCase("ProxyHost")) {
                helper.setProxyHost(propertyValue);
            } else if (propertyName.equalsIgnoreCase("ProxyPort")) {
                helper.setProxyPort(Integer.valueOf(propertyValue));
            } else if (propertyName.equalsIgnoreCase("ProxyUser")) {
                helper.setProxyUser(propertyValue);
            } else if (propertyName.equalsIgnoreCase("ProxyPassword")) {
                helper.setProxyPassword(propertyName);
            } else if (propertyName.equalsIgnoreCase("TrustStore.file")) {
                helper.setTrustStoreFile(propertyValue);
            } else if (propertyName.equalsIgnoreCase("TrustCertificate")) {
                helper.setTrustCertificate(propertyValue);
            } else if (propertyName.equalsIgnoreCase("TrustAllCertificates")) {
                helper.setTrustAllCertificates(Boolean.valueOf(propertyValue));
            } else if (propertyName.equalsIgnoreCase("KeyStore.file")) {
                helper.setKeyStoreFile(propertyValue);
            } else if (propertyName.equalsIgnoreCase("KeyStore.password")) {
                helper.setKeyStorePassword(propertyValue);
            } else {
                AbstractAlterCreateClientConnectionFactoryOperation.getPropertyObserver(factory).onProperty(propertyName, propertyValue);
            }
        };
        AbstractAlterCreateConnectionFactoryOperation.PropertyObserver onSetUserProperty = (propertyName, propertyValue) -> factory.getProperties().put(propertyName, propertyValue);
        AbstractAlterCreateConnectionFactoryOperation.PropertyObserver onRemoveUserProperty = (propertyName, propertyValue) -> factory.getProperties().remove(propertyName);
        this.parseProperties(statement, onSetProperty, onSetUserProperty, onRemoveUserProperty);
        this.parseAndSetSpecificFactoryModifiers(statement, factory);
    }

    @Override
    protected void addSpecificFactoryModifiers(DSLStatementSyntax syntax, boolean alter) {
        if (alter) {
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSet("REMOVE REALMS", "realmsremove").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSet("ADD REALMS", "realmsadd").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSet("SET REALMS", "realmsset").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSet("REMOVE HEADERS", "headerssetremove").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameValueSet("ADD HEADERS", "headerssetadd").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameValueSet("SET HEADERS", "headerssetset").setSyntaxHint(new SyntaxHint(" ", true)));
        } else {
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameSet("REALMS", "realmsset").setSyntaxHint(new SyntaxHint(" ", true)));
            syntax.addModifier((AbstractModifier)WebServerDSLProvider.createNameValueSet("HEADERS", "headerssetset").setSyntaxHint(new SyntaxHint(" ", true)));
        }
    }

    protected void parseAndSetSpecificFactoryModifiers(DSLStatement statement, ClientFactory factory) throws Exception {
        Map<String, String> headers;
        HTTPConnectionFactoryHelper helper = new HTTPConnectionFactoryHelper(factory);
        List<String> realms = helper.getRealms();
        realms.removeAll(WebServerDSLProvider.nameSetToList(statement, "realmsremove", new ArrayList<String>()));
        realms.addAll(WebServerDSLProvider.nameSetToList(statement, "realmsadd", new ArrayList<String>()));
        realms = WebServerDSLProvider.nameSetToList(statement, "realmsset", realms);
        helper.setRealms(realms);
        Map<String, String> finalHeaders = headers = helper.getHttpHeaders();
        WebServerDSLProvider.nameSetToList(statement, "headerssetremove", new ArrayList<String>()).forEach(name -> finalHeaders.remove(name));
        headers.putAll(WebServerDSLProvider.nameValueSetToMap(statement, "headerssetadd", new HashMap<String, String>()));
        headers = WebServerDSLProvider.nameValueSetToMap(statement, "headerssetset", headers);
        helper.setHttpHeaders(headers);
    }
}

