/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.factory;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.AbstractConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractAlterCreateConnectionFactoryOperation
extends AbstractConnectionFactoryOperation {
    private ListConnectionFactoriesOperation.FactoryScope scope;
    private boolean alter;

    AbstractAlterCreateConnectionFactoryOperation(String name, final ListConnectionFactoriesOperation.FactoryScope scope, boolean alter) {
        this.scope = scope;
        this.alter = alter;
        this.createDSLSyntax(name);
        boolean withFactoryType = scope != ListConnectionFactoriesOperation.FactoryScope.HTTP && scope != ListConnectionFactoriesOperation.FactoryScope.AWS;
        this.syntax.setAction(name.toUpperCase()).addActionParameter(alter && withFactoryType ? (SyntaxParameter)new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter().setCompletionAdviser(alter ? new CompletionAdviser<RuntimeContext>(){

            @Override
            public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
                try {
                    return ListConnectionFactoriesOperation.listConnectionFactories(callable, scope, false);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean isCaseSensitive() {
                return true;
            }
        } : null) : (SyntaxParameter)((IdentifierParameter)new IdentifierParameter("Name").setName("FactoryName")).setCompletionAdviser(alter ? new CompletionAdviser<RuntimeContext>(){

            @Override
            public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
                try {
                    return ListConnectionFactoriesOperation.listConnectionFactories(callable, scope, false).stream().map(name -> name.substring(name.indexOf(".") + 1)).collect(Collectors.toList());
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean isCaseSensitive() {
                return true;
            }
        } : null));
        if (!alter) {
            if (scope != ListConnectionFactoriesOperation.FactoryScope.AWS) {
                this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("URL").addParameter((SyntaxParameter)new StringParameter("URL").setName("UrlValue"))).setSyntaxHint(SyntaxHint.SPACE));
            }
            if (scope != ListConnectionFactoriesOperation.FactoryScope.HTTP && scope != ListConnectionFactoriesOperation.FactoryScope.AWS) {
                this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier(scope == ListConnectionFactoriesOperation.FactoryScope.DB ? "DRIVER CLASS" : "CONNECTION CLASS").addParameter((SyntaxParameter)new StringParameter("class name").setName("ClassName"))).setSyntaxHint(new SyntaxHint(" ", true)));
            }
            if (withFactoryType) {
                this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TYPE").addParameter((SyntaxParameter)new IdentifierParameter("Name").setName("FactoryType"))).setSyntaxHint(new SyntaxHint(" ", true)));
            }
        }
        this.syntax.addModifier(this.createSetPropertiesBlockSyntax());
        this.syntax.addModifier(this.createSetUserPropertiesBlockSyntax());
        if (alter) {
            this.syntax.addModifier(this.createRemoveUserPropertiesBlockSyntax());
        }
        this.addSpecificFactoryModifiers(this.syntax, alter);
    }

    protected void addSpecificFactoryModifiers(DSLStatementSyntax syntax, boolean alter) {
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.syntax.getName(), statement);
    }

    protected abstract String getFactoryType();

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String factoryType = statement.getParameter("FactoryType").getValue();
        String factoryName = statement.getParameter("FactoryName").getValue();
        if (factoryType == null) {
            factoryType = this.getFactoryType();
        }
        return this.onInvoke(statement, factoryType, factoryName);
    }

    protected abstract SLResponse onInvoke(DSLStatement var1, String var2, String var3) throws Exception;

    protected abstract void addSpecificFactorySetProperties(BlockModifier var1);

    protected AbstractModifier<?> createSetPropertiesBlockSyntax() throws RuntimeException {
        BlockModifier block = new BlockModifier("SET PROPERTIES", "SetPropertiesBlock");
        if (this.alter && this.scope != ListConnectionFactoriesOperation.FactoryScope.AWS) {
            block.addModifier(this.createAssignPropertyModifier("url", new StringParameter("url")));
        }
        block.addModifier(this.createAssignPropertyModifier("description", new StringParameter("description")));
        if (this.scope != ListConnectionFactoriesOperation.FactoryScope.AWS) {
            block.addModifier(this.createAssignPropertyModifier("defaultUser", new StringParameter("username")));
            block.addModifier(this.createAssignPropertyModifier("defaultPassword", new StringParameter("password")));
        }
        block.addModifier(this.createAssignPropertyModifier("checkInterval", new LongParameter("milliseconds")));
        block.addModifier(this.createAssignPropertyModifier("connectionTimeout", new IntegerParameter("seconds")));
        block.addModifier(this.createAssignPropertyModifier("reconnectionRetries", new IntegerParameter("-1 means infinite")));
        block.addModifier(this.createAssignPropertyModifier("isReliable", new BooleanParameter("isReliable")));
        this.addSpecificFactorySetProperties(block);
        block.addModifier(this.wrapToRepatable(this.createAssignUserPropertyModifier()));
        ((BlockModifier)block.setRequired(false)).setSyntaxHint(new SyntaxHint(" ", true));
        return block;
    }

    protected AbstractModifier<?> createSetUserPropertiesBlockSyntax() throws RuntimeException {
        BlockModifier block = new BlockModifier("ADD PROPERTIES", "SetUserPropertiesBlock");
        block.addModifier(this.wrapToRepatable(this.createAssignUserPropertyModifier()));
        ((BlockModifier)block.setRequired(false)).setSyntaxHint(new SyntaxHint(" ", true));
        return block;
    }

    protected AbstractModifier<?> createRemoveUserPropertiesBlockSyntax() throws RuntimeException {
        BlockModifier block = new BlockModifier("REMOVE PROPERTIES", "RemoveUserPropertiesBlock");
        block.addModifier(this.wrapToRepatable(this.createRemoveUserPropertyModifier()));
        ((BlockModifier)block.setRequired(false)).setSyntaxHint(new SyntaxHint(" ", true));
        return block;
    }

    protected AbstractModifier<?> createAssignPropertyModifier(String propertyName, AbstractParameter<?> parameter) {
        return this.createAssignPropertyModifier(propertyName, parameter, false);
    }

    protected AbstractModifier<?> createAssignPropertyModifier(String propertyName, AbstractParameter<?> parameter, boolean required) {
        CompoundModifier syntax = new CompoundModifier(propertyName + "setcompound");
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier(propertyName).setDisplayInLowerCase(false)).setName("PropertyName"));
        syntax.addModifier(new Modifier("=", "equals")).addParameter((AbstractParameter)parameter.setName("value"));
        syntax.setRequired(required);
        return syntax;
    }

    protected AbstractModifier<?> createAssignUserPropertyModifier() {
        CompoundModifier syntax = new CompoundModifier("userpropertysetcompound");
        syntax.addParameter(new IdentifierParameter("PropertyName"));
        syntax.addModifier((AbstractModifier)new Modifier("=", "equals").addParameter(new StringParameter("value")));
        return syntax;
    }

    protected AbstractModifier<?> createRemoveUserPropertyModifier() {
        CompoundModifier syntax = new CompoundModifier("userpropertyremovecompound");
        syntax.addParameter(new IdentifierParameter("PropertyName"));
        return syntax;
    }

    protected RepeatableModifier wrapToRepatable(AbstractModifier<?> modifier) {
        return (RepeatableModifier)((RepeatableModifier)new RepeatableModifier(modifier.getName() + "line").addModifier(modifier)).setSyntaxHint(new SyntaxHint(" ", true));
    }

    protected void parseProperties(DSLStatement statement, PropertyObserver onSetProperty, PropertyObserver onSetUserProperty, PropertyObserver onRemoveUserProperty) throws Exception {
        if (statement.getBlock("SetPropertiesBlock").isPresent()) {
            AbstractAlterCreateConnectionFactoryOperation.parsePropertiesBlock(statement.getBlock("SetPropertiesBlock"), onSetProperty);
        }
        if (statement.getBlock("SetUserPropertiesBlock").isPresent()) {
            AbstractAlterCreateConnectionFactoryOperation.parsePropertiesBlock(statement.getBlock("SetUserPropertiesBlock"), onSetUserProperty);
        }
        if (statement.getBlock("RemoveUserPropertiesBlock").isPresent()) {
            AbstractAlterCreateConnectionFactoryOperation.parsePropertiesBlock(statement.getBlock("RemoveUserPropertiesBlock"), onRemoveUserProperty);
        }
    }

    protected static void parsePropertiesBlock(StatementBlockValue body, PropertyObserver observer) throws Exception {
        for (int index = 0; index < body.getLinesCount(); ++index) {
            StatementValueList line = body.getLineByIndex(index);
            String propertyName = null;
            String propertyValue = null;
            try {
                if (line.existsModifier("PropertyName")) {
                    propertyName = line.getModifier("PropertyName").getToken();
                } else if (line.existsParameter("PropertyName")) {
                    propertyName = line.getParameter("PropertyName").getValue();
                } else {
                    throw new Exception("No property name specified.");
                }
                if (line.existsParameter("value")) {
                    propertyValue = line.getParameter("value").getValue();
                }
                observer.onProperty(propertyName, propertyValue);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Error while processing line '" + line.toString() + "'. " + e.getMessage());
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        Definition(String name, DSLStatement statement) {
            super(name);
            this.statement = statement;
        }
    }

    public static interface PropertyObserver {
        public void onProperty(String var1, String var2) throws Exception;
    }
}

