/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.exchange;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractExchangeOperation;
import com.streamscape.sef.exchange.FabricExchange;
import com.streamscape.sef.exchange.FabricExchangeException;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.security.UserState;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SetExchangePropertiesOperation
extends AbstractExchangeOperation {
    public static final String NAME = "set exchange properties";

    public SetExchangePropertiesOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET EXCHANGE PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Sets the specified configuration properties of the Fabric Exchange.");
        this.syntax.setSyntaxDescription("set exchange properties           - Sets the specified properties in the current node.\nset exchange properties at node   - Sets the specified properties in the specified node.\nset exchange properties at domain - Sets the specified properties in all nodes of the sysplex.\n\nThe following properties are supported:\n\n   workerPoolSize                 - Size of the main thread pool (number of threads in the pool).\n                                    Non-positive value means that this pool is not used.\n   workerPoolType                 - Type of the main thread pool (FIXED or DYNAMIC).\n   systemWorkerPoolSize           - Size of the internal thread pool (number of thread in the pool).\n                                    Non-positive value means that this pool is not used.\n   systemWorkerPoolType           - Type of the internal thread pool (FIXED or DYNAMIC).\n   scavenger.reconnectAttempts    - Number of reconnect attempts which will be made by the Scavenger thread.\n                                    Zero value means that the Scavenger will not attempt to reconnect.\n                                    Negative value means that the Scavenger will try to reconnect infinitely (until successful connection).\n   scavenger.reconnectInterval    - Time (in seconds) between successive reconnect attempts which will be made by the Scavenger thread.\n                                    The value must be positive.\n   anonymousRegistration          - Enables or disables anonymous registration of new users.\n   anonymousUser                  - Initial state of anonymously registered users.\n                                    The possible value is ENABLED or DISABLED.\n   threadMonitorInterval          - Time (in seconds) between iterations in the monitor that observes a state of the JVM threads.\n                                    Non-positive value means that this monitor will be disabled.\n   blockedThreadAdvisoryThreshold - Time (in seconds) for a blocked thread after which the BlockedThreadAdvisory advisory will be raised.\n                                    Non-positive value means that the advisory will not be raised.\n   connectionTimeout              - Time (in seconds) of waiting for establishing outgoing connections.\n                                    The value must be positive.\n   replyTimeout                   - Time (in seconds) of waiting for reply for internal standard requests.\n                                    The value must be positive.\n   fastReplyTimeout               - The time (in seconds) of waiting for reply for internal fast requests.\n                                    The value must be positive.\n   longReplyTimeout               - The time (in seconds) of waiting for reply for internal long requests.\n                                    The value must be positive.\n   broadcastReplyTimeout          - The time (in seconds) of waiting for reply for internal broadcast requests.\n                                    The value must be positive.\n   tokenDelay                     - Delay (in milliseconds) before passing the synchronization token to the next node.\n                                    The value must be positive.\n   tokenMonitorInterval           - Time (in seconds) between iterations in the monitor that observes a state of the synchronization token.\n                                    The value must be positive.\n   fastFailTimeout                - Time (in seconds) of waiting for a synchronization token before applying the 'fast-fail' behavior\n                                    (i.e. moving the node to a standalone mode).\n                                    Non-positive value means that the 'fast-fail' behavior will not be used.\n   accessorMonitorInterval        - Time (in seconds) between successive repeats in the monitor which observes a state of accessors in the node.\n                                    Non-positive value means that this monitor will be disabled.\n   accessorPoolSize               - Maximum number of accessors in the pool of a component (dataspace or service).\n                                    Such pools are used in RPL scripts.\n                                    Non-positive value means that the pool will not be used\n                                    (i.e. a new accessor will be created each time it is used in a script).\n   accessorPoolExpirationTimeout  - Time (in seconds) before closing an idle accessor in the pool.\n                                    Non-positive value means that idle accessors in the pool will not be closed.\n   nodeWeight                     - Weight of the node in Sysplex.\n                                    This parameter is used by accessors to select the node if the node name is not specified.\n                                    The value must be positive.\n   clientThresholds               - List of thresholds for the number of external (remote) clients currently connected to the node.\n                                    Upon reaching the threshold, the advisory [advisory.fabric.ClientThreshold] is raised.\n                                    Thresholds have the protocol and numeric value in format &lt;Protocol&gt;:&lt;Threshold&gt;,...\n                                    Supported protocol values are TLP, HTTP, XMPP and * (means any client).\n                                    Non-positive threshold value means that the advisory will not be raised for the specified protocol.\n   webAppTokenAuthentication      - Enables or disables user authentication with a Web Application Token.\n\nThe properties must be exactly in the format shown above (they are case-sensitive).");
        this.syntax.setExamples("set exchange properties (scavenger.reconnectAttempts = '10')\nset exchange properties (anonymousRegistration = 'false',threadMonitorInterval='120')\nset exchange properties (anonymousRegistration = 'true', anonymousUser = 'disabled')\nset exchange properties (accessorPoolSize='5', accessorPoolExpirationTimeout='60')\nset exchange properties (nodeWeight='1')\nset exchange properties (workerPoolSize = '200') at node Node1\nset exchange properties (scavenger.reconnectInterval = '60') at domain\nset exchange properties (accessorMonitorInterval = '180') at domain\nset exchange properties (clientThresholds = '*:200,http:100,tlp:-1')");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Map<String, String> properties = ((Definition)statement).properties;
        FabricExchange exchange = ((RuntimeContext)this.callable).getExchange();
        Iterator<Map.Entry<String, String>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (entry.getKey().equals("anonymousRegistration")) {
                exchange.setAnonymousRegistration(SetParametersModifier.getBoolean("anonymousRegistration", entry.getValue()));
                iter.remove();
            }
            if (entry.getKey().equals("anonymousUser")) {
                try {
                    exchange.setAnonymousUser(UserState.valueOf(entry.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException exception) {
                    throw new FabricException("Invalid value '" + entry.getValue() + "' for property '" + entry.getKey() + "'.");
                }
                iter.remove();
                continue;
            }
            if (!entry.getKey().equals("replyTimeout") && !entry.getKey().equals("fastReplyTimeout") && !entry.getKey().equals("longReplyTimeout") && !entry.getKey().equals("broadcastReplyTimeout") && !entry.getKey().equals("tokenDelay") && !entry.getKey().equals("webAppTokenAuthentication")) continue;
            exchange.setAdvancedParameter(entry.getKey(), entry.getValue());
            iter.remove();
        }
        return !properties.isEmpty() ? this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false) : new SLResponse();
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        FabricExchange exchange = ((RuntimeContext)this.callable).getExchange();
        for (Map.Entry<String, String> entry : ((Definition)statement).properties.entrySet()) {
            if (entry.getKey().equals("workerPoolSize")) {
                int poolSize = SetParametersModifier.getInt("workerPoolSize", entry.getValue());
                if (poolSize <= 0) {
                    throw new FabricExchangeException(6007, "Parameter 'workerPoolSize' must be positive.");
                }
                FabricThreadManager.getInstance().createThread("EXCH:SetProperty.workerPoolSize", "", () -> {
                    Utils.sleep(500L);
                    try {
                        exchange.setWorkerPoolSize(poolSize);
                    }
                    catch (FabricExchangeException fabricExchangeException) {
                        // empty catch block
                    }
                }).start();
                continue;
            }
            if (entry.getKey().equals("workerPoolType")) {
                ThreadPoolType poolType = SetExchangePropertiesOperation.getPoolType("workerPoolType", entry.getValue());
                FabricThreadManager.getInstance().createThread("EXCH:SetProperty.workerPoolType", "", () -> {
                    Utils.sleep(500L);
                    exchange.setWorkerPoolType(poolType);
                }).start();
                continue;
            }
            if (entry.getKey().equals("systemWorkerPoolSize")) {
                exchange.setSystemWorkerPoolSize(SetParametersModifier.getInt("systemWorkerPoolSize", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("systemWorkerPoolType")) {
                exchange.setSystemWorkerPoolType(SetExchangePropertiesOperation.getPoolType("systemWorkerPoolType", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("scavenger.reconnectAttempts")) {
                exchange.setScavengerReconnectAttempts(SetParametersModifier.getInt("scavenger.reconnectAttempts", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("scavenger.reconnectInterval")) {
                exchange.setScavengerReconnectInterval(SetParametersModifier.getLong("scavenger.reconnectInterval", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("threadMonitorInterval")) {
                exchange.setThreadMonitorInterval(SetParametersModifier.getLong("threadMonitorInterval", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("blockedThreadAdvisoryThreshold")) {
                exchange.setBlockedThreadAdvisoryThreshold(SetParametersModifier.getLong("blockedThreadAdvisoryThreshold", entry.getValue()));
                continue;
            }
            if (entry.getKey().equals("clientThresholds")) {
                List<String> tokens = StringUtils.splitWithoutEmptyTokens(entry.getValue(), ',');
                if (tokens.isEmpty()) {
                    exchange.setClientThresholds(null);
                    continue;
                }
                HashMap<String, Integer> thresholds = new HashMap<String, Integer>();
                for (String token : tokens) {
                    List<String> protocolThreshold = StringUtils.split(token, ':');
                    if (protocolThreshold.size() != 2) {
                        throw new FabricException("Invalid threshold '" + String.valueOf(protocolThreshold) + "'.");
                    }
                    String protocol = protocolThreshold.get(0).toUpperCase();
                    SetExchangePropertiesOperation.checkProtocol("clientThresholds", protocol);
                    int threshold = SetParametersModifier.getInt("clientThresholds", protocolThreshold.get(1));
                    if (thresholds.containsKey(protocol)) {
                        throw new FabricException("More than one threshold specified for protocol '" + protocol + "'.");
                    }
                    thresholds.put(protocol, threshold);
                }
                exchange.setClientThresholds(thresholds);
                continue;
            }
            exchange.setAdvancedParameter(entry.getKey(), entry.getValue());
        }
        return new SLResponse();
    }

    private static ThreadPoolType getPoolType(String name, String value) throws Exception {
        try {
            return ThreadPoolType.valueOf(value);
        }
        catch (Exception exception) {
            throw new FabricException("Invalid value '" + value + "' for property '" + name + "'.");
        }
    }

    private static void checkProtocol(String name, String value) throws Exception {
        try {
            if (!value.equals("*")) {
                LinkProtocol.valueOf(value);
            }
        }
        catch (Exception exception) {
            throw new FabricException("Invalid protocol '" + value + "' for property '" + name + "'.");
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private Map<String, String> properties;

        public Definition(String nodeName, Map<String, String> properties) {
            super(SetExchangePropertiesOperation.NAME);
            this.nodeName = nodeName;
            this.properties = properties;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }
    }
}

