/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.exchange;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractExchangeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.Modifier;

public class ResyncExchangeOperation
extends AbstractExchangeOperation {
    public static final String NAME = "resync exchange";

    public ResyncExchangeOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RESYNC EXCHANGE");
        ((DSLStatementSyntax)this.syntax.addModifier(new Modifier("FORCE", false))).setSyntaxHint(SyntaxHint.SPACE);
        this.syntax.setDescription("Restarts the synchronization token in the Exchange.\nUse this operation if the token is lost (token state can be checked by 'show exchange state' operation).\nThis operation can be executed in the root node only.");
        this.syntax.setSyntaxDescription("Optional parameter:\n\n  force - Performs forced restart of the synchronization token in the Exchange.\n          Does not check a state of the token before the restart.\n          This operation is potentially unsafe, so use it only if a normal restart does not work.");
        this.syntax.addTag(OperationTag.sysplex);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("FORCE"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.resync(((Definition)statement).force);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean force;

        public Definition(boolean force) {
            super(ResyncExchangeOperation.NAME);
            this.force = force;
        }

        public boolean isForce() {
            return this.force;
        }
    }
}

