/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.event;

import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.event.AbstractEventOperation;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListEventsOperation
extends AbstractEventOperation {
    public static final String NAME = "list events";

    public ListEventsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENTS");
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setAlias("*"));
        ChoiceModifier modifier = new ChoiceModifier();
        modifier.addModifier((AbstractModifier)new Modifier().addParameter(new EventIdParameter("EventFilter", true)));
        modifier.addModifier(ListEventsOperation.createLikeModifier());
        this.syntax.addModifier((AbstractModifier)modifier.setRequired(false));
        this.syntax.setDescription("Returns a list of user events.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all         - Returns a list of all (user and system) events.\n   EventFilter - Returns a list of user events whose event id matches the specified filter.\n                 Parameter EventFilter should be put in double quotes or in [] characters.\n                 This is a standard event filter that can contain metacharacters '*', '#' and '!'.\n   like        - Returns a list of events whose event id matches the specified pattern.\n" + ListEventsOperation.getLikeModifierDescription("                 ", "\n"));
        this.syntax.setExamples("list events\nlist events [event.#]\nlist events [event.mail.*]]\nlist events [event.!mail.#]]\nlist events all [event.#]\nlist events all like '.*xmpp.*'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition(statement.existsModifier("ALL"));
        if (statement.existsParameter("EventFilter")) {
            result.setEventFilter(statement.getParameter("EventFilter").getValue());
        }
        result.setPattern(ListEventsOperation.getLikeParameterValue(statement));
        if (result.eventFilter != null && result.pattern != null) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parameters 'EventFilter' and 'Pattern' cannot be specified together."));
        }
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListEventsOperation.createResultDescriptor());
        List<ComponentReference> components = ((RuntimeContext)this.callable).getModerator().getComponents(EventScope.INHERITED);
        List<EventConsumerReference> consumers = ((RuntimeContext)this.callable).getModerator().getEventConsumers(EventScope.INHERITED);
        ArrayList<String> systemEvents = new ArrayList<String>();
        for (String eventId : this.listEvents(definition)) {
            if (ListEventsOperation.isReservedEvent(eventId)) continue;
            boolean isSystem = ListEventsOperation.isNonUserEvent(eventId);
            if (isSystem) {
                if (!definition.isAll && !ListEventsOperation.isVisibleEvent(eventId)) continue;
                systemEvents.add(eventId);
                continue;
            }
            ListEventsOperation.add(eventId, components, consumers, ((RuntimeContext)this.callable).getDatagramPrototypeFactory().isPrototypeGlobal(eventId), false, result);
        }
        for (String eventId : systemEvents) {
            ListEventsOperation.add(eventId, components, consumers, true, true, result);
        }
        return new SLResponse(result);
    }

    private List<String> listEvents(Definition definition) throws Exception {
        DatagramPrototypeCache cache = ((RuntimeContext)this.callable).getDatagramPrototypeCache();
        if (definition.eventFilter != null) {
            return cache.listEventIdsByFilter(new Filter(definition.eventFilter));
        }
        if (definition.pattern != null) {
            Pattern pattern = ListEventsOperation.compileExtendedPattern(definition.pattern);
            return cache.listEventIds().stream().filter(eventId -> pattern.matcher((CharSequence)eventId).matches()).collect(Collectors.toList());
        }
        return cache.listEventIds();
    }

    private static void add(String eventId, List<ComponentReference> components, List<EventConsumerReference> consumers, boolean isSystem, boolean isGlobal, RowSet result) throws SQLException {
        result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventId), ListEventsOperation.hasProducer(eventId, components), ListEventsOperation.hasConsumer(eventId, consumers), isGlobal, isSystem});
    }

    private static String hasProducer(String eventId, List<ComponentReference> componentReferences) {
        for (ComponentReference reference : componentReferences) {
            if (!reference.isBoundEventId(eventId)) continue;
            return "x";
        }
        return "-";
    }

    private static String hasConsumer(String eventId, List<EventConsumerReference> consumerReferences) {
        for (EventConsumerReference reference : consumerReferences) {
            if (!reference.matchesEventId(eventId)) continue;
            return "x";
        }
        return "-";
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListEventsOperation.addColumn(result, "Event");
        ListEventsOperation.addColumn(result, "Producers");
        ListEventsOperation.addColumn(result, "Consumers");
        ListEventsOperation.addColumn(result, "System");
        ListEventsOperation.addColumn(result, "Global");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean isAll;
        private String eventFilter;
        private String pattern;

        public Definition() {
            super(ListEventsOperation.NAME);
        }

        public Definition(boolean isAll) {
            super(ListEventsOperation.NAME);
            this.isAll = isAll;
        }

        public boolean isAll() {
            return this.isAll;
        }

        public String getEventFilter() {
            return this.eventFilter;
        }

        public void setEventFilter(String eventFilter) {
            this.eventFilter = eventFilter;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

