/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.event;

import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AbstractEventPrototypeOperation;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListEventPrototypesOperation
extends AbstractEventPrototypeOperation {
    public static final String NAME = "list event prototypes";
    private static final Comparator<Pair<String, Prototype>> PROTOTYPE_COMPARATOR = Comparator.comparing(pair -> ((Prototype)pair.second).getModelName());

    public ListEventPrototypesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENT PROTOTYPES");
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setAlias("*"));
        this.syntax.addModifier(ListEventPrototypesOperation.createLikeModifier());
        this.syntax.addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("MODEL").addParameter((SyntaxParameter)new IdentifierParameter("Model").setCompletionAdviser(new AbstractEventPrototypeOperation.EventModelCompletionAdviser(this)))).addModifier(new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("TYPE").addParameter((SyntaxParameter)new IdentifierParameter("Type").setCompletionAdviser(new AbstractOperation.SemanticTypeCompletionAdviser()))).addModifier(new Modifier("NESTED", false))));
        this.syntax.setDescription("Returns a list of user event prototypes.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all            - Returns a list of all (user and system) event prototypes.\n   like           - Returns a list of event prototypes whose event id matches the specified pattern.\n" + ListEventPrototypesOperation.getLikeModifierDescription("                    ", "\n") + "   model          - Returns a list of event prototypes matches the specified model.\n                    Full list of supported models can be obtained with 'list event prototype models' command.\n      type -        Returns a list of event prototypes whose payload object matches the specified semantic type.\n                    This parameter is applicable only to 'DataEvent', 'DeltaEvent', 'OpaqueEvent' models.\n      type nested - Returns a list of event prototypes whose payload object matches the specified semantic type\n                    or contains any nested object of the specified type.\n                    This parameter is applicable only to 'DataEvent', 'DeltaEvent', 'OpaqueEvent' models.");
        this.syntax.setExamples("list event prototypes\nlist event prototypes all\nlist event prototypes like '.*log.*'\nlist event prototypes all like '%log%\nlist event prototypes model TextEvent\nlist event prototypes model TextEvent all\nlist event prototypes model DataEvent type TestType\nlist event prototypes model DataEvent type TestType nested\nlist event prototypes all model DataEvent type TestType");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(ListEventPrototypesOperation.getLikeParameterValue(statement), statement.existsParameter("Model") ? statement.getParameter("Model").getValue() : null, statement.existsParameter("Type") ? this.resolveTypeName(statement.getParameter("Type").getValue()) : null, statement.existsModifier("NESTED"), statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Pair<AbstractEventPrototypeOperation.PrototypeModel, Boolean> model = this.checkModel(definition);
        Pattern pattern = definition.pattern != null ? ListEventPrototypesOperation.compileExtendedPattern(definition.pattern) : null;
        RowSet result = new RowSet(ListEventPrototypesOperation.createResultDescriptor((Boolean)model.second, definition.isAll));
        ArrayList<Pair<String, Prototype>> userEvents = new ArrayList<Pair<String, Prototype>>();
        ArrayList<Pair<String, Prototype>> systemAdvisories = new ArrayList<Pair<String, Prototype>>();
        ArrayList<Pair<String, Prototype>> systemEvents = new ArrayList<Pair<String, Prototype>>();
        ArrayList<Pair<String, Prototype>> systemExceptions = new ArrayList<Pair<String, Prototype>>();
        for (String eventId : this.listEventIds(pattern)) {
            Pair<String, Prototype> prototype;
            if (ListEventPrototypesOperation.isNonUserEvent(eventId)) {
                if (!definition.isAll || (prototype = this.getPrototype(eventId, definition.model)) == null) continue;
                if (eventId.startsWith("advisory")) {
                    systemAdvisories.add(prototype);
                    continue;
                }
                if (eventId.startsWith("event")) {
                    systemEvents.add(prototype);
                    continue;
                }
                if (!eventId.startsWith("exception")) continue;
                systemExceptions.add(prototype);
                continue;
            }
            prototype = this.getPrototype(eventId, definition.model);
            if (prototype == null) continue;
            userEvents.add(prototype);
        }
        this.addPrototypes(userEvents, definition, false, model, result);
        this.addPrototypes(systemAdvisories, definition, true, model, result);
        this.addPrototypes(systemEvents, definition, true, model, result);
        this.addPrototypes(systemExceptions, definition, true, model, result);
        return new SLResponse(result);
    }

    private List<String> listEventIds(Pattern pattern) {
        return ((RuntimeContext)this.callable).getDatagramPrototypeCache().listEventIds().stream().filter(eventId -> !ListEventPrototypesOperation.isReservedEvent(eventId) && ListEventPrototypesOperation.matchesPattern(eventId, pattern)).collect(Collectors.toList());
    }

    private static boolean matchesPattern(String eventId, Pattern pattern) {
        return eventId != null && (pattern == null || pattern.matcher(eventId).matches());
    }

    private Pair<String, Prototype> getPrototype(String eventId, String model) {
        Prototype prototype = ((RuntimeContext)this.callable).getDatagramPrototypeCache().lookupPrototype(eventId);
        return ListEventPrototypesOperation.matchesModel(prototype, model) ? new Pair<String, Prototype>(eventId, prototype) : null;
    }

    private static boolean matchesModel(Prototype prototype, String model) {
        return prototype != null && (model == null || Utils.equalsNullSafe(model, prototype.getModelName()));
    }

    private void addPrototypes(List<Pair<String, Prototype>> prototypes, Definition definition, boolean isSystem, Pair<AbstractEventPrototypeOperation.PrototypeModel, Boolean> model, RowSet result) throws Exception {
        prototypes.sort(PROTOTYPE_COMPARATOR);
        for (Pair<String, Prototype> prototype : prototypes) {
            if (!definition.isAll && isSystem) continue;
            Pair<String, Boolean> semanticType = this.checkSemanticType((Boolean)model.second, definition, (String)prototype.first);
            if (!((Boolean)semanticType.second).booleanValue()) continue;
            ListEventPrototypesOperation.add(result, this.getValues((String)prototype.first, (Prototype)prototype.second, (Boolean)model.second, (String)semanticType.first, definition.isAll, isSystem).toArray());
        }
    }

    private Pair<AbstractEventPrototypeOperation.PrototypeModel, Boolean> checkModel(Definition definition) throws Exception {
        AbstractEventPrototypeOperation.PrototypeModel model = definition.model != null ? this.checkModel(definition.model) : null;
        Pair<AbstractEventPrototypeOperation.PrototypeModel, Boolean> result = new Pair<AbstractEventPrototypeOperation.PrototypeModel, Boolean>(model, this.needSemanticType(model));
        if (!((Boolean)result.second).booleanValue() && definition.semanticType != null) {
            throw new Exception("Semantic type is applicable only to 'DataEvent', 'DeltaEvent' or 'OpaqueEvent' models.");
        }
        return result;
    }

    private Pair<String, Boolean> checkSemanticType(boolean withSemanticType, Definition definition, String eventId) throws Exception {
        if (withSemanticType) {
            if (definition.semanticType != null && !((RuntimeContext)this.callable).getSemanticTypeCache().existsSemanticType(definition.semanticType)) {
                throw new Exception("Semantic type not found.");
            }
            Class payloadClass = ((PayloadEvent)((Object)this.getEventPrototype(eventId))).getPayloadClass();
            String payloadType = payloadClass != null ? ListEventPrototypesOperation.skipNull(((RuntimeContext)this.callable).getSemanticTypeCache().resolveSemanticClass(payloadClass)) : null;
            Pair<String, Boolean> result = new Pair<String, Boolean>(payloadType, false);
            this.checkPayload(definition, payloadClass, payloadType, result);
            return result;
        }
        return new Pair<Object, Boolean>(null, true);
    }

    private void checkPayload(Definition definition, Class payloadClass, String payloadType, Pair<String, Boolean> result) throws Exception {
        if (definition.semanticType != null) {
            if (!definition.isNested) {
                result.second = definition.semanticType.equals(payloadType);
            } else {
                this.checkNestedPayload(definition, payloadClass, result);
            }
        } else {
            result.second = true;
        }
    }

    private void checkNestedPayload(final Definition definition, Class payloadClass, final Pair<String, Boolean> result) {
        try {
            ((RuntimeContext)this.callable).getTypeAnalyzerFactory().createTypeAnalyzer().getTypeGraph(payloadClass).traverse(new TypeGraphVisitor(){

                @Override
                public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
                    Class<?> nestedClass = TypeAnalyzer.getRawClass(node.getType());
                    if (nestedClass != null && definition.semanticType.equals(((RuntimeContext)ListEventPrototypesOperation.this.callable).getSemanticTypeCache().resolveSemanticClass(nestedClass))) {
                        result.second = true;
                        return false;
                    }
                    return true;
                }

                @Override
                public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<String> getValues(String eventId, Prototype prototype, boolean withType, String semanticType, boolean needAll, boolean isSystem) throws Exception {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(StringUtils.wrapEventId(eventId), prototype.getModelName()));
        if (withType) {
            result.add(semanticType);
        }
        if (needAll) {
            result.add(Boolean.toString(isSystem));
        }
        result.add(Boolean.toString(((RuntimeContext)this.callable).getDatagramPrototypeFactory().isPrototypeGlobal(eventId)));
        result.add(Boolean.toString(prototype.isValid()));
        return result;
    }

    private static RowMetaData createResultDescriptor(boolean withSemanticType, boolean isAll) {
        RowMetaData result = new RowMetaData();
        ListEventPrototypesOperation.addColumn(result, "Event Id");
        ListEventPrototypesOperation.addColumn(result, "Model");
        if (withSemanticType) {
            ListEventPrototypesOperation.addColumn(result, "Semantic Type");
        }
        if (isAll) {
            ListEventPrototypesOperation.addColumn(result, "System");
        }
        ListEventPrototypesOperation.addColumn(result, "Global");
        ListEventPrototypesOperation.addColumn(result, "Valid");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        String pattern;
        String model;
        String semanticType;
        boolean isNested;
        boolean isAll;

        Definition(String pattern, String model, String semanticType, boolean isNested, boolean isAll) {
            super(ListEventPrototypesOperation.NAME);
            this.pattern = pattern;
            this.model = model;
            this.semanticType = semanticType;
            this.isNested = isNested;
            this.isAll = isAll;
        }
    }
}

