/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.event;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AbstractEventPrototypeOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import java.util.List;

public class DropEventPrototypeOperation
extends AbstractEventPrototypeOperation {
    public static final String NAME = "drop event prototype";

    public DropEventPrototypeOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP EVENT PROTOTYPE").addActionParameter(new EventIdParameter("EventId"));
        this.syntax.addModifier((AbstractModifier)new Modifier("FORCE", false).setSyntaxHintSpace());
        this.syntax.setDescription("Drops an event prototype with the specified event id.\nParameter EventId should be put in double quotes or in [] characters.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\nDrops the event prototype without checking for its active event flows.");
        this.syntax.setExamples("drop event prototype [event.Example]\ndrop event prototype [event.Example] force");
        this.syntax.addCompletionCommand("list event prototypes");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.getUserEventIds(completions);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("EventId").getValue(), statement.existsModifier("FORCE"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((RuntimeContext)this.callable).getDatagramPrototypeCache().existsEventId(definition.eventId)) {
            return new SLResponse("Event prototype not found.", false);
        }
        ((RuntimeContext)this.callable).getDatagramPrototypeFactory().removePrototype(definition.eventId, definition.force);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        String eventId;
        boolean force;

        public Definition(String eventId, boolean force) {
            super(DropEventPrototypeOperation.NAME);
            this.eventId = eventId;
            this.force = force;
        }
    }
}

