/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.event;

import com.streamscape.lib.analyzer.EventAnalyzer;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AbstractEventPrototypeOperation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DescribeEventPrototypeOperation
extends AbstractEventPrototypeOperation {
    public static final String NAME = "describe event prototype";

    public DescribeEventPrototypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE EVENT PROTOTYPE");
        this.syntax.setPredicate((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("ALL PROPERTIES").setName("AllProperties"))).addModifier((AbstractModifier)new Modifier("SYSTEM PROPERTIES").setName("SystemProperties"))).addModifier((AbstractModifier)new Modifier("USER PROPERTIES").setName("UserProperties"))).addModifier((AbstractModifier)new Modifier("ANNOTATIONS").setName("Annotations"))).addModifier((AbstractModifier)new Modifier("AS EDL").setName("AsEdl")));
        this.syntax.setSubject((Subject)new Subject("").addParameter(new EventIdParameter("EventId")));
        this.syntax.setDescription("describe event prototype [<EventId>]                   - Shows information about event prototype with the specified event id.\ndescribe event prototype user properties [<EventId>]   - Shows information about user event properties of prototype with the specified event id.\ndescribe event prototype system properties [<EventId>] - Shows information about system event properties of prototype with the specified event id.\ndescribe event prototype annotation [<EventId>]        - Shows information about annotations of prototype with the specified event id.\ndescribe event prototype all properties [<EventId>]    - Shows information about all event properties and annotations of prototype with the specified event id.\n\nParameter EventId should be put in double quotes or in [] characters.");
        this.syntax.setExamples("describe event prototype [event.Example]\ndescribe event prototype all properties [event.Example]");
        this.syntax.addCompletionCommand("list event prototypes");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getDatagramPrototypeCache().listEventIds().stream().filter(eventId -> !DescribeEventPrototypeOperation.isReservedEvent(eventId)).map(eventId -> "[" + eventId + "]").collect(Collectors.toList()));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        PropertiesType propertiesType = PropertiesType.NONE;
        if (statement.existsModifier("AllProperties")) {
            propertiesType = PropertiesType.ALL;
        } else if (statement.existsModifier("SystemProperties")) {
            propertiesType = PropertiesType.SYSTEM;
        } else if (statement.existsModifier("UserProperties")) {
            propertiesType = PropertiesType.USER;
        } else if (statement.existsModifier("Annotations")) {
            propertiesType = PropertiesType.ANNOTATIONS;
        }
        return new Definition(statement.getParameter("EventId").getValue(), propertiesType, statement.existsModifier("AsEdl"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Pair<Prototype, ImmutableEventDatagram> eventPrototype = this.getPrototype(definition.eventId);
        if (eventPrototype != null) {
            AbstractEventPrototypeOperation.PrototypeModel model = this.checkModel((Prototype)eventPrototype.first);
            if (definition.asEdl) {
                return this.describeEventPrototypeAsEdl(definition.eventId, eventPrototype, model);
            }
            switch (model) {
                case ADVISORY: 
                case EXCEPTION: {
                    return this.describeSimpleEvent((Prototype)eventPrototype.first, (ImmutableEventDatagram)eventPrototype.second, definition.propertiesType);
                }
                case EVENT: {
                    return this.describeEvent((Prototype)eventPrototype.first, (ImmutableEventDatagram)eventPrototype.second, definition.propertiesType);
                }
                case DATA_EVENT: 
                case DELTA_EVENT: 
                case OPAQUE_EVENT: {
                    return this.describePayloadEvent((Prototype)eventPrototype.first, (ImmutableEventDatagram)eventPrototype.second, definition.propertiesType);
                }
                case ROW_EVENT: {
                    return this.describeRowEvent((Prototype)eventPrototype.first, (ImmutableEventDatagram)eventPrototype.second, definition.propertiesType);
                }
            }
            return new SLResponse("Model '" + ((Prototype)eventPrototype.first).getModelName() + "' is not supported.", false);
        }
        return new SLResponse("Event prototype not found.", false);
    }

    private SLResponse describeSimpleEvent(Prototype prototype, ImmutableEventDatagram event, PropertiesType propertiesType) throws Exception {
        if (propertiesType == PropertiesType.USER || propertiesType == PropertiesType.ANNOTATIONS) {
            throw new Exception("Model '" + prototype.getModelName() + "' does not support user event properties.");
        }
        return this.describeEvent(prototype, event, propertiesType);
    }

    private SLResponse describeEvent(Prototype prototype, ImmutableEventDatagram event, PropertiesType propertiesType) throws Exception {
        return propertiesType != PropertiesType.NONE ? this.describeProperties(event, propertiesType) : this.describeCommonEvent(prototype, event);
    }

    private SLResponse describePayloadEvent(Prototype prototype, ImmutableEventDatagram event, PropertiesType propertiesType) throws Exception {
        if (propertiesType != PropertiesType.NONE) {
            return this.describeProperties(event, propertiesType);
        }
        RowSet result = new RowSet(DescribeEventPrototypeOperation.createResultDescriptor());
        this.addCommonFields(event, prototype, result);
        return new SLResponse(result);
    }

    private SLResponse describeRowEvent(Prototype prototype, ImmutableEventDatagram event, PropertiesType propertiesType) throws Exception {
        if (propertiesType != PropertiesType.NONE) {
            return this.describeProperties(event, propertiesType);
        }
        RowSet result = new RowSet(DescribeEventPrototypeOperation.createResultDescriptor());
        this.addCommonFields(event, prototype, result);
        RowMetaData meta = null;
        if (event instanceof RowEvent) {
            if (((RowEvent)event).getRow() != null) {
                meta = ((RowEvent)event).getRow().getMetaData();
            }
        } else if (event instanceof RowSetEvent) {
            meta = ((RowSetEvent)event).getRowSet().getRowMetaData();
        } else if (event instanceof RowArrayEvent) {
            meta = ((RowArrayEvent)event).getMetaData();
        } else if (event instanceof RowChangeEvent) {
            meta = ((RowChangeEvent)event).getBeforeImage().getMetaData();
        }
        if (meta != null) {
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            Iterator<ColumnDescriptor> columns = meta.iterator();
            while (columns.hasNext()) {
                ColumnDescriptor column = columns.next();
                buffer.append(first ? "" : ", ").append(column.getName()).append(" ").append(column.getType().name());
                first = false;
            }
            String columnsString = buffer.toString();
            if (columnsString.length() > 0) {
                result.addToRowSet(new Object[]{"Columns", "(" + buffer.toString() + ")"});
            }
        }
        return new SLResponse(result);
    }

    private SLResponse describeCommonEvent(Prototype prototype, ImmutableEventDatagram event) throws Exception {
        RowSet result = new RowSet(DescribeEventPrototypeOperation.createResultDescriptor());
        this.addCommonFields(event, prototype, result);
        return new SLResponse(result);
    }

    private void addCommonFields(ImmutableEventDatagram event, Prototype prototype, RowSet result) throws Exception {
        result.addToRowSet(new Object[]{"Event Id", StringUtils.wrapEventId(event.getEventId())});
        result.addToRowSet(new Object[]{"Model", prototype.getModelName()});
        result.addToRowSet(new Object[]{"System", DescribeEventPrototypeOperation.isNonUserEvent(event.getEventId())});
        result.addToRowSet(new Object[]{"Global", ((RuntimeContext)this.callable).getDatagramPrototypeFactory().isPrototypeGlobal(event.getEventId())});
        result.addToRowSet(new Object[]{"Valid", prototype.isValid()});
        if (!prototype.isValid()) {
            result.addToRowSet(new Object[]{"Validation Error", prototype.getError()});
        }
        Class payloadClass = new EventAnalyzer(event).getPayLoadClass();
        result.addToRowSet(new Object[]{"Semantic Type", payloadClass != null ? EventAnalyzer.resolveTypeName(payloadClass) : "none"});
    }

    private SLResponse describeProperties(ImmutableEventDatagram event, PropertiesType propertiesType) throws Exception {
        RowSet result = new RowSet(DescribeEventPrototypeOperation.createResultDescriptorForProperties());
        EventAnalyzer analyzer = new EventAnalyzer(event);
        if (propertiesType == PropertiesType.USER || propertiesType == PropertiesType.ALL) {
            this.addProperties(result, analyzer.getUserProperties(), analyzer, false);
        }
        if (propertiesType == PropertiesType.SYSTEM || propertiesType == PropertiesType.ALL) {
            this.addProperties(result, analyzer.getSystemProperties(), analyzer, false);
        }
        if (propertiesType == PropertiesType.ANNOTATIONS) {
            this.addProperties(result, analyzer.getUserProperties(), analyzer, true);
            this.addProperties(result, analyzer.getSystemProperties(), analyzer, true);
        }
        return new SLResponse(result);
    }

    private void addProperties(RowSet rowSet, Map<String, EventAnalyzer.Property> properties, EventAnalyzer analyzer, boolean annotatedOnly) {
        properties.forEach((key, property) -> {
            EventAnalyzer.Annotation annotation = analyzer.getAnnotations().get(property.getName());
            if (!annotatedOnly || annotation != null) {
                DescribeEventPrototypeOperation.addValues(rowSet, property.getName(), property.getTypeName(), DescribeEventPrototypeOperation.convert(property), annotation != null, annotation != null ? annotation.getSDRPath() : "", annotation != null ? Boolean.valueOf(annotation.isValid()) : "");
            }
        });
    }

    private static Object convert(EventAnalyzer.Property property) {
        if (property.getType() == Long.TYPE && property.getValue() instanceof Date && ((Date)property.getValue()).getTime() == 0L) {
            return Long.toString(0L);
        }
        if (property.getType() == byte[].class && Utils.equalsNullSafe(property.getValue(), "null")) {
            return DescribeEventPrototypeOperation.skipNull(null);
        }
        return DescribeEventPrototypeOperation.skipNull(property.getValue());
    }

    private SLResponse describeEventPrototypeAsEdl(String eventId, Pair<Prototype, ImmutableEventDatagram> eventPrototype, AbstractEventPrototypeOperation.PrototypeModel model) throws Exception {
        String properties;
        String annotations;
        RowMetaData rowMetaData;
        StringBuilder builder = new StringBuilder();
        builder.append("create event prototype [").append(eventId).append("]").append("\n");
        builder.append("  model ").append(((Prototype)eventPrototype.first).getModelName()).append("\n");
        String payloadType = this.getDataType((Prototype)eventPrototype.first, (ImmutableEventDatagram)eventPrototype.second);
        if (payloadType != null) {
            builder.append("  semantic_type ").append(payloadType).append("\n");
        }
        EventDatagram eventDatagram = eventPrototype.second instanceof EventDatagram ? (EventDatagram)eventPrototype.second : null;
        EventDatagram eventModel = EventDatagramFactory.getInstance().newEventInstance(((Prototype)eventPrototype.first).getModelName());
        if (eventDatagram instanceof RowEvent && (rowMetaData = ((RowEvent)eventDatagram).getRow().getMetaData()) != null && rowMetaData.getColumnCount() > 0) {
            builder.append("  row fields(");
            builder.append(rowMetaData.getColumnDescriptors().stream().map(d -> d.getName() + " " + (d.getType() != null ? d.getType().getTypeName() : d.getTypeName())).collect(Collectors.joining(",")));
            builder.append(")").append("\n");
        }
        if (eventDatagram != null && eventDatagram.getAnnotatedProperties().size() > 0 && (annotations = eventDatagram.getAnnotatedProperties().stream().filter(propertyName -> {
            try {
                return eventModel.getAnnotation((String)propertyName) == null;
            }
            catch (Exception ignored) {
                return false;
            }
        }).map(propertyName -> {
            try {
                return "@" + propertyName + " " + eventDatagram.getAnnotation((String)propertyName).getSDRPath();
            }
            catch (Exception ignored) {
                return null;
            }
        }).collect(Collectors.joining(","))).length() > 0) {
            builder.append("  annotations (").append(annotations).append(")").append("\n");
        }
        if (eventDatagram != null && eventDatagram.getEventPropertyNames().size() > 0 && (properties = eventDatagram.getEventPropertyNames().stream().filter(propertyName -> {
            try {
                return !eventModel.existsEventProperty((String)propertyName) && eventDatagram.getAnnotation((String)propertyName) == null;
            }
            catch (Exception ignored) {
                return false;
            }
        }).map(propertyName -> {
            try {
                PropertyType propertyType = eventDatagram.getEventPropertyType((String)propertyName);
                return propertyName + " " + (propertyType != null ? propertyType.name() : "object");
            }
            catch (Exception ignored) {
                return null;
            }
        }).collect(Collectors.joining(","))).length() > 0) {
            builder.append("  properties (").append(properties).append(")").append("\n");
        }
        return new SLResponse(builder.toString());
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeEventPrototypeOperation.addColumn(result, "Name");
        DescribeEventPrototypeOperation.addColumn(result, "Value");
        return result;
    }

    private static RowMetaData createResultDescriptorForProperties() {
        RowMetaData result = new RowMetaData();
        DescribeEventPrototypeOperation.addColumn(result, "Property Name");
        DescribeEventPrototypeOperation.addColumn(result, "Property Type");
        DescribeEventPrototypeOperation.addColumn(result, "Property Value");
        DescribeEventPrototypeOperation.addColumn(result, "Annotated");
        DescribeEventPrototypeOperation.addColumn(result, "SDR Path");
        DescribeEventPrototypeOperation.addColumn(result, "Valid");
        return result;
    }

    public static enum PropertiesType {
        NONE,
        ALL,
        USER,
        SYSTEM,
        ANNOTATIONS;

    }

    public static class Definition
    extends AbstractSLStatement {
        private String eventId;
        private PropertiesType propertiesType;
        private boolean asEdl;

        public Definition(String eventId, PropertiesType propertiesType, boolean asEdl) {
            super(DescribeEventPrototypeOperation.NAME);
            this.eventId = eventId;
            this.propertiesType = propertiesType;
            this.asEdl = asEdl;
        }

        public String getEventId() {
            return this.eventId;
        }

        public PropertiesType getPropertiesType() {
            return this.propertiesType;
        }

        public Definition setAsEdl(boolean asEdl) {
            this.asEdl = asEdl;
            return this;
        }
    }
}

