/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.event;

import com.streamscape.ds.schema.collection.CollectionMetaData;
import com.streamscape.ds.schema.collection.DataspaceTypeToSQLTypeConverter;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.runtime.mf.operation.mapper.CreateSemanticMapperOperation;
import com.streamscape.sdo.AbstractEventPrototypeOperation;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowChangeEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CreateEventPrototypeOperation
extends AbstractEventPrototypeOperation {
    public static final String NAME = "create event prototype";

    public CreateEventPrototypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE EVENT PROTOTYPE").addActionParameter(new EventIdParameter("EventId"));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("ModelOrLikeModifier").setSyntaxHintSpace()).addModifier((AbstractModifier)new Modifier("MODEL").addParameter((SyntaxParameter)new IdentifierParameter("Model").setCompletionAdviser(new AbstractEventPrototypeOperation.EventModelCompletionAdviser(this))))).addModifier((AbstractModifier)new Modifier("LIKE").addParameter((SyntaxParameter)new EventIdParameter("ExistingEventId").setCompletionAdviser(new AbstractOperation.EventIdCompletionAdviser(this)))));
        this.syntax.addModifier(new CompoundModifier("SEMANTIC_TYPE_COMP", false).addModifier(new ChoiceModifier("SEMANTIC_TYPE_CHOICE").addPossibleValues("SEMANTIC_TYPE", "SEMANTIC TYPE", "TYPE")).addParameter((AbstractParameter)new IdentifierParameter("SemanticType").setCompletionAdviser(new AbstractOperation.SemanticTypeCompletionAdviser())));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("SqlQueryFieldsChoice").setRequired(false)).addModifier((AbstractModifier)new Modifier("SQL_QUERY").addParameter(new StringParameter("SqlQuery", Character.valueOf('\''), Character.valueOf('\''))))).addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier("ROW_DEFINITION_COMP").setCompactSyntax("row fields(<name> <type>,...)")).setSyntaxHint(new SyntaxHint(" ", true))).addModifier(new Modifier("ROW FIELDS")).addParameter(((ExpressionParameter)new ExpressionParameter("<name> <type>,...", '(', ')').setName("ROW_DEFINITION")).setIgnoreQuotes(false))));
        this.syntax.addModifier((AbstractModifier)new Modifier("ANNOTATIONS", false).addParameter(new SetParameter("AnnotationsSet", (AbstractParameter)new IdentifierParameter("Name").setPrefix("@"), (AbstractParameter)new ExpressionParameter("SdrPath").setExcludedDelimiters("[]@='"))));
        this.syntax.addModifier(this.createPropertiesModifierBlock());
        this.syntax.setDescription("Creates a new event prototype with the specified id.");
        this.syntax.setSyntaxDescription("Any parameters must not contain whitespace characters.\nParameters <EventId> and <ModelEventId> should be put in double quotes or in [] characters.\n\nMandatory parameters:\n\n   model         - Name of the prototype model.\n                   Full list of supported models can be obtained using 'list event prototype models' command.\n   like          - Creates a new event prototype based on the existing event prototype.\n\nOptional parameters:\n\n   type          - Name of the semantic type of the prototype's data object.\n                   This parameter is applicable only to 'DataEvent', 'DeltaEvent', 'OpaqueEvent' models.\n\n   sql_query     - SQL query which is used as the basis for RowMetaData of created Row* event prototype. \n                   All collection references inside the query should be fully qualified (including dataspace names).\n                   NOTE: specified query is executed in order to obtain meta information on all tuples involved in the query. \n                   It is recommended to limit amount of query data (e.g. with 'top 1' statement) as the data returned as a result\n                   of query execution is rejected (only the meta info is used). \n                   All collection references inside the query should be fully qualified (including dataspace names).\n                   This parameter is applicable only to 'RowEvent', 'RowSetEvent', 'RowArrayEvent','RowChangeEvent' models.\n\n   row fields    - Row field names and types can be specified instead of SqlQuery. Types are DSQL types.\n\n   annotations   - List of annotations of the prototype.\n                   Annotations contain a list of the pairs @<name> <sdrPath> which must be separated by comma:\n                      name  - the name of annotated event property (must be started with @ character).\n                      value - the path to the event data field to be annotated (must have the format //<field>/<subfield1>/...).\n   properties    - List of properties of the prototype.\n                   Properties contain a list of the pairs <name> <type> which must be separated by comma:\n                      name - the name of event property.\n                      type - the type of event property.");
        this.syntax.setExamples("create event prototype [event.Example] model TextEvent\ncreate event prototype [event.Example] model TextEvent properties (name1 string)\ncreate event prototype [event.Example] model TextEvent properties (name1 string, name2 boolean, name3 decimal(10,1))\ncreate event prototype [event.Example] model DataEvent type Example1\ncreate event prototype [event.Example] model DataEvent type Example1 annotations (@name1 //data/field1, @name2 //data/field2)\ncreate event prototype [event.Example] model DataEvent type Example1 annotations (@name3 //data/field1) properties (name1 String, name2 Boolean)\ncreate event prototype [event.Example] model RowEvent sql_query 'select col1,col2 from Dataspace1.Table1' annotations (@Column1 //row/column[1], @Column2 //row/col2)\ncreate event prototype [event.Example] model RowEvent row fields (col1 int, col2 string) annotations (@Column1 //row/column[1], @Column2 //row/col2)\ncreate event prototype [event.Event2] like [event.Event1]");
    }

    private BlockModifier createPropertiesModifierBlock() {
        BlockModifier block = new BlockModifier("PROPERTIES", "PropertiesBlock");
        block.addModifier(this.wrapToRepeatable(this.createPropertyNameTypeModifier()));
        block.setRequired(false);
        return block;
    }

    private CompoundModifier createPropertyNameTypeModifier() {
        CompoundModifier result = this.createPropertyNameModifier("PropertyName");
        ChoiceModifier propertyType = this.createPropertyTypeModifier("PropertyType");
        propertyType.addModifier(this.createBigDecimalPropertyModifier(true));
        propertyType.setCompactSyntax(propertyType.getSyntax().replace("}", "|\n                              decimal (&lt;Precision&gt;, &lt;Scale&gt;) }"));
        return result.addModifier(propertyType);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementBlockValue propertiesBlock;
        StatementSetValue annotations;
        Definition result = new Definition(statement.getParameter("EventId").getValue());
        if (statement.existsParameter("Model")) {
            result.setModel(statement.getParameter("Model").getValue());
        }
        if (statement.existsParameter("ExistingEventId")) {
            result.setExistingEventId(statement.getParameter("ExistingEventId").getValue());
        }
        if (statement.existsParameter("SemanticType")) {
            result.setSemanticType(this.resolveTypeName(statement.getParameter("SemanticType").getValue()));
        }
        if (statement.existsParameter("SqlQuery")) {
            result.setSqlQuery(statement.getParameter("SqlQuery").getValue());
        }
        if (statement.existsParameter("SqlQuery") && statement.existsParameter("ROW_DEFINITION")) {
            throw new ParsingException("Only one parameter SqlQuery or ROW FIELDS can be specified.");
        }
        if (statement.existsParameter("ROW_DEFINITION")) {
            result.setRowDefinition(statement.getParameter("ROW_DEFINITION").getValue());
        }
        if ((annotations = statement.getSet("AnnotationsSet")).isPresent()) {
            ArrayList<Annotation> annotationsList = new ArrayList<Annotation>();
            for (int i = 0; i < annotations.size(); ++i) {
                StatementValueList annotationValue = annotations.getElement(i);
                annotationsList.add(new Annotation(annotationValue.getParameter("Name").getValue(), annotationValue.getParameter("SdrPath").getValue()));
            }
            result.setAnnotations(annotationsList);
        }
        if ((propertiesBlock = statement.getBlock("PropertiesBlock")).isPresent()) {
            ArrayList<Property> propertiesList = new ArrayList<Property>();
            for (int i = 0; i < propertiesBlock.getLinesCount(); ++i) {
                StatementValueList line = propertiesBlock.getLineByIndex(i);
                Property property = new Property(line.getParameter("PropertyName").getValue());
                if (line.existsModifier("Decimal")) {
                    property.type = "BigDecimal";
                    StatementSetValue precisionSet = line.getSet("PrecisionSet");
                    if (precisionSet.isPresent()) {
                        property.precision = Integer.parseInt(precisionSet.getElement(0).getParameter("precision").getValue());
                        property.scale = Integer.parseInt(precisionSet.getElement(1).getParameter("scale").getValue());
                        if (property.precision <= 0 || property.scale < 0 || property.precision > 128 || property.scale > property.precision) {
                            throw new ParsingException("Invalid precision/scale specified for property '" + property.name + "'.");
                        }
                    }
                } else {
                    property.type = line.getModifier("PropertyType").getToken();
                }
                propertiesList.add(property);
            }
            result.setProperties(propertiesList);
        }
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.model != null) {
            AbstractEventPrototypeOperation.PrototypeModel model = this.checkModel(definition.model);
            this.checkSemanticType(model, definition.semanticType);
            switch (model) {
                case ADVISORY: {
                    this.createAdvisoryPrototype(definition);
                    break;
                }
                case EVENT: {
                    this.createEventPrototype(definition);
                    break;
                }
                case EXCEPTION: {
                    this.createExceptionPrototype(definition);
                    break;
                }
                case DATA_EVENT: {
                    this.createDataEventPrototype(definition);
                    break;
                }
                case DELTA_EVENT: {
                    this.createDeltaEventPrototype(definition);
                    break;
                }
                case OPAQUE_EVENT: {
                    this.createOpaquePrototype(definition);
                    break;
                }
                case ROW_EVENT: {
                    this.createRowEventPrototype(definition, session);
                    break;
                }
                default: {
                    throw new FabricException("Model '" + definition.model + "' is not supported.");
                }
            }
        } else if (definition.existingEventId != null) {
            if (definition.semanticType != null) {
                throw new FabricException("Semantic type is not applicable for 'like' parameter.");
            }
            Prototype prototype = ((RuntimeContext)this.callable).getDatagramPrototypeCache().lookupPrototype(definition.existingEventId);
            if (prototype == null) {
                throw new FabricException("Event [" + definition.existingEventId + "] not found.");
            }
            AbstractEventPrototypeOperation.PrototypeModel model = this.checkModel(prototype.getModelName());
            switch (model) {
                case ADVISORY: {
                    this.createAdvisoryPrototype(definition, ((RuntimeContext)this.callable).getAdvisoryDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                case EVENT: 
                case ROW_EVENT: {
                    this.createEventPrototype(definition, ((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                case EXCEPTION: {
                    this.createExceptionPrototype(definition, ((RuntimeContext)this.callable).getExceptionDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                case DATA_EVENT: {
                    this.createDataEventPrototype(definition, (DataEvent)((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                case DELTA_EVENT: {
                    this.createDeltaEventPrototype(definition, (DeltaEvent)((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                case OPAQUE_EVENT: {
                    this.createOpaquePrototype(definition, (OpaqueEvent)((RuntimeContext)this.callable).getOpaqueDatagramFactory().newEventInstanceFrom(definition.existingEventId));
                    break;
                }
                default: {
                    throw new FabricException("Model '" + definition.model + "' is not supported.");
                }
            }
        }
        return new SLResponse();
    }

    private void checkSemanticType(AbstractEventPrototypeOperation.PrototypeModel model, String semanticType) throws Exception {
        if (this.needSemanticType(model)) {
            if (semanticType == null) {
                throw new FabricException("Semantic type is not specified.");
            }
        } else if (semanticType != null) {
            throw new FabricException("Semantic type is applicable only to 'DataEvent', 'DeltaEvent' or 'OpaqueEvent' models.");
        }
    }

    private void createAdvisoryPrototype(Definition definition) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addAdvisoryPrototype(definition.model, definition.eventId);
    }

    private void createAdvisoryPrototype(Definition definition, AdvisoryEventDatagram event) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addAdvisoryPrototype(definition.eventId, event);
    }

    private void createEventPrototype(Definition definition) throws Exception {
        this.createEventPrototype(definition, ((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstance(definition.model));
    }

    private void createRowEventPrototype(Definition definition, MFSession session) throws Exception {
        EventDatagram event = ((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstance(definition.model);
        RowMetaData meta = null;
        if (definition.getSqlQuery() != null) {
            meta = this.getRowMetaData(definition.getSqlQuery(), session.getOwner().getSecurityContext());
        } else if (definition.getRowDefinition() != null) {
            meta = CreateSemanticMapperOperation.parseRowDefinition(definition.getRowDefinition(), (RuntimeMFSession)session);
        }
        if (meta != null) {
            if (event instanceof RowEvent) {
                ((RowEvent)event).init(meta);
            } else if (event instanceof RowSetEvent) {
                ((RowSetEvent)event).init(meta);
            } else if (event instanceof RowArrayEvent) {
                ((RowArrayEvent)event).init(meta);
            } else if (event instanceof RowChangeEvent) {
                ((RowChangeEvent)event).setBeforeImage(new Row(meta));
                ((RowChangeEvent)event).setAfterImage(new Row(meta));
            }
        } else {
            throw new IllegalArgumentException("Row fields or SQL query should be specified for RowEvent.");
        }
        this.createEventPrototype(definition, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowMetaData getRowMetaData(String query, SecurityContext securityContext) throws Exception {
        RowMetaData meta = new RowMetaData();
        try (Connection connection = null;){
            connection = ((RuntimeContext)this.callable).getDataspaceManager().getJDBCConnection("SYS", securityContext);
            Statement stat = connection.createStatement();
            if (stat.execute(query)) {
                ResultSetMetaData resultSetMeta = stat.getResultSet().getMetaData();
                meta = new RowMetaData();
                for (int i = 1; i <= resultSetMeta.getColumnCount(); ++i) {
                    Tuple tuple;
                    CollectionMetaData collectionMetaData;
                    String columnName = resultSetMeta.getColumnLabel(i);
                    if (columnName == null) {
                        columnName = resultSetMeta.getColumnName(i);
                    }
                    SQLType type = SQLType.typeForId(resultSetMeta.getColumnType(i), resultSetMeta.getColumnTypeName(i), resultSetMeta.getColumnClassName(i));
                    boolean nullable = resultSetMeta.isNullable(i) == 1;
                    int precision = resultSetMeta.getPrecision(i);
                    int scale = resultSetMeta.getScale(i);
                    String columnSchemaName = resultSetMeta.getSchemaName(i);
                    DataspaceComponent component = ((RuntimeContext)this.callable).getDataspaceManager().lookup(columnSchemaName);
                    if (component != null && (collectionMetaData = component.lookupCollectionMetaData(resultSetMeta.getTableName(i))) != null && (tuple = collectionMetaData.lookupTuple(resultSetMeta.getColumnName(i))) != null) {
                        type = DataspaceTypeToSQLTypeConverter.convert(tuple.getDataspaceType());
                        precision = tuple.getPrecision();
                        scale = tuple.getScale();
                    }
                    ColumnDescriptor column = new ColumnDescriptor(columnName, type, nullable, precision, scale);
                    meta.addColumn(column);
                }
            } else {
                throw new IllegalArgumentException("Invalid SQL query provided. Unable to extract columns meta information.");
            }
            stat.close();
        }
        return meta;
    }

    private void createEventPrototype(Definition definition, EventDatagram event) throws Exception {
        CreateEventPrototypeOperation.addProperties(definition, event);
        CreateEventPrototypeOperation.addAnnotations(definition, event);
        PrototypeFactory.addEventPrototype(definition.eventId, event);
    }

    private void createExceptionPrototype(Definition definition) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addExceptionPrototype(definition.model, definition.eventId);
    }

    private void createExceptionPrototype(Definition definition, ExceptionEventDatagram event) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addExceptionPrototype(definition.eventId, event);
    }

    private void createDataEventPrototype(Definition definition) throws Exception {
        DataEvent event = (DataEvent)((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstance(definition.model);
        event.setData(SDOUtils.createDataObject(definition.semanticType));
        this.createDataEventPrototype(definition, event);
    }

    private void createDataEventPrototype(Definition definition, DataEvent event) throws Exception {
        CreateEventPrototypeOperation.addProperties(definition, event);
        CreateEventPrototypeOperation.addAnnotations(definition, event);
        PrototypeFactory.addDataEventPrototype(definition.eventId, event);
    }

    private void createDeltaEventPrototype(Definition definition) throws Exception {
        DeltaEvent event = (DeltaEvent)((RuntimeContext)this.callable).getEventDatagramFactory().newEventInstance(definition.model);
        Object data = SDOUtils.createDataObject(definition.semanticType);
        event.setBeforeImage(data);
        event.setAfterImage(data);
        this.createDeltaEventPrototype(definition, event);
    }

    private void createDeltaEventPrototype(Definition definition, DeltaEvent event) throws Exception {
        CreateEventPrototypeOperation.addProperties(definition, event);
        CreateEventPrototypeOperation.addAnnotations(definition, event);
        PrototypeFactory.addDeltaEventPrototype(definition.eventId, event);
    }

    private void createOpaquePrototype(Definition definition) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addOpaqueEventPrototype(definition.eventId, definition.semanticType);
    }

    private void createOpaquePrototype(Definition definition, OpaqueEvent event) throws Exception {
        CreateEventPrototypeOperation.checkPropertiesAbsence(definition);
        PrototypeFactory.addOpaqueEventPrototype(definition.eventId, event);
    }

    private static void checkPropertiesAbsence(Definition definition) throws FabricException {
        if (definition.properties != null || definition.annotations != null) {
            throw new FabricException("Model '" + definition.model + "' does not support properties.");
        }
    }

    private static void addAnnotations(Definition definition, EventDatagram event) throws Exception {
        if (definition.annotations != null) {
            for (Annotation annotation : definition.annotations) {
                event.addAnnotation(annotation.name, annotation.sdrPath);
            }
        }
    }

    private static void addProperties(Definition definition, EventDatagram event) throws Exception {
        if (definition.properties != null) {
            for (Property property : definition.properties) {
                if (property.type.equalsIgnoreCase(PropertyType.BigDecimal.toString())) {
                    event.setEventObjectProperty(property.name, EventPropertyValidator.makeBigDecimalTemplate(property.precision, property.scale));
                    continue;
                }
                event.setEventObjectProperty(property.name, EventPropertyValidator.getDefaultValue(CreateEventPrototypeOperation.getPropertyType(property.type)));
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String eventId;
        private String model;
        private String existingEventId;
        private String semanticType;
        private String sqlQuery;
        private List<Annotation> annotations;
        private List<Property> properties;
        private String rowDefinition;

        public Definition(String eventId) {
            super(CreateEventPrototypeOperation.NAME);
            this.eventId = eventId;
        }

        public Definition(String eventId, String model) {
            super(CreateEventPrototypeOperation.NAME);
            this.eventId = eventId;
            this.setModel(model);
        }

        public String getEventId() {
            return this.eventId;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getExistingEventId() {
            return this.existingEventId;
        }

        public void setExistingEventId(String modelEventId) {
            this.existingEventId = modelEventId;
        }

        public String getSemanticType() {
            return this.semanticType;
        }

        public void setSemanticType(String semanticType) {
            this.semanticType = semanticType;
        }

        public String getSqlQuery() {
            return this.sqlQuery;
        }

        public void setSqlQuery(String query) {
            this.sqlQuery = query;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations != null ? new ArrayList<Annotation>(this.annotations) : new ArrayList();
        }

        public void setAnnotations(List<Annotation> annotations) {
            this.annotations = annotations;
        }

        public List<Property> getProperties() {
            return this.properties != null ? new ArrayList<Property>(this.properties) : new ArrayList();
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }

        public void setRowDefinition(String rowDefinition) {
            this.rowDefinition = rowDefinition;
        }

        public String getRowDefinition() {
            return this.rowDefinition;
        }
    }

    public static class Annotation
    extends CloneableDataObject {
        public String name;
        public String sdrPath;

        public Annotation(String name, String sdrPath) {
            this.name = name;
            this.sdrPath = sdrPath;
        }

        public String toString() {
            return this.name + ":" + this.sdrPath;
        }
    }

    public static class Property
    extends CloneableDataObject {
        public String name;
        public String type;
        public int precision = -1;
        public int scale = -1;

        public Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

