/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.parser;

import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.operation.edl.parser.SdoBodyTokenType;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;

public class SdoTypeCompleter
implements PrefixCompleter {
    private TriggerFunctionParserContext context;
    private boolean onlySimple = false;
    private boolean onlySdoTypes = false;

    public SdoTypeCompleter(TriggerFunctionParserContext context) {
        this.context = context;
    }

    public SdoTypeCompleter onlySimple(boolean onlySimple) {
        this.onlySimple = onlySimple;
        return this;
    }

    public SdoTypeCompleter onlySdoTypes(boolean onlySdoTypes) {
        this.onlySdoTypes = onlySdoTypes;
        return this;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        PrefixTree<SuggestionGroup> prefixTree = new PrefixTree<SuggestionGroup>(true);
        for (String typeName : this.context.listSemanticTypes()) {
            SemanticType semanticType = this.context.lookupSemanticType(typeName);
            if (semanticType.isSystem() && (semanticType.getAncestorType() == null || !semanticType.getAncestorType().equals(SerializerUtils.SemanticTypeAncestor.complex.toString()))) continue;
            prefixTree.add(typeName, SuggestionGroup.TYPE_COMPLEX);
        }
        prefixTree.add(SdoBodyTokenType.STRING.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.INT.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.INTEGER.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.SHORT.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.LONG.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.FLOAT.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.DOUBLE.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.BIGDECIMAL.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.BIGINT.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.BIGINTEGER.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.BOOLEAN.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.CHAR.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.BYTE.getValue(), SuggestionGroup.TYPE_PRIMITIVE);
        prefixTree.add(SdoBodyTokenType.DATE.getValue(), SuggestionGroup.TYPE_COMPLEX);
        prefixTree.add(SdoBodyTokenType.SQL_DATE.getValue(), SuggestionGroup.TYPE_COMPLEX);
        prefixTree.add(SdoBodyTokenType.SQL_TIMESTAMP.getValue(), SuggestionGroup.TYPE_COMPLEX);
        prefixTree.add(SdoBodyTokenType.EVENT.getValue(), SuggestionGroup.TYPE_COMPLEX);
        prefixTree.add(SdoBodyTokenType.OBJECT.getValue(), SuggestionGroup.TYPE_COMPLEX);
        if (!this.onlySimple) {
            prefixTree.add(SdoBodyTokenType.LIST.getValue(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(SdoBodyTokenType.MAP.getValue(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(SdoBodyTokenType.ENTRY.getValue(), SuggestionGroup.TYPE_COLLECTION);
        }
        if (!this.onlySdoTypes) {
            prefixTree.add(Types.QUEUE.getName(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.SET.getName(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.COLLECTION.getName(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.MAP.getName(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.ENTRY.getName(), SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.DATASPACE.getName(), SuggestionGroup.TYPE_CONTEXT);
            prefixTree.add(Types.SERVICE.getName(), SuggestionGroup.TYPE_CONTEXT);
            prefixTree.add(Types.RUNTIME.getName(), SuggestionGroup.TYPE_CONTEXT);
            prefixTree.add(Types.BLOCKING_QUEUE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.EVENT_QUEUE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.AUDIT_QUEUE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.MESSAGE_QUEUE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.PROCESS_QUEUE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.TABLE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.EVENT_TABLE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.FILE_TABLE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.VIRTUAL_TABLE.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.DIRECTORY.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.VIEW.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
            prefixTree.add(Types.SOURCE_STREAM.getName(), SuggestionGroup.TYPE_DATASPACE_COLLECTION);
        }
        PrefixTreeCompleter completer = new PrefixTreeCompleter(prefixTree);
        return completer.completeDsl(prefix);
    }
}

