/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.parser;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.EnumDataField;
import com.streamscape.runtime.mf.operation.edl.ListDataField;
import com.streamscape.runtime.mf.operation.edl.MapDataField;
import com.streamscape.runtime.mf.operation.edl.SimpleDataField;
import com.streamscape.runtime.mf.operation.edl.parser.AbstractSdoParser;
import com.streamscape.runtime.mf.operation.edl.parser.SdoBodyTokenType;
import com.streamscape.runtime.mf.operation.edl.parser.SdoTypeCompleter;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.parser.AbstractParser;
import com.streamscape.tools.parser.ParserCompletionException;
import com.streamscape.tools.parser.ParserException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SdoBodyParser
extends AbstractSdoParser {
    public static final String XML_IMPLICIT_COLLECTION = "xml-implicit-collection";
    public static final String JSON_SUPPRESS_GENERIC_TYPE = "json-suppress-generic-type";
    public static final String XML_ATTRIBUTE = "xml-attribute";
    private TriggerFunctionParserContext context = new TriggerFunctionParserContextImpl(RuntimeContext.getInstance());

    @Override
    protected void readLine(List<DataField> lines) throws ParserException, LexerException {
        DataField dataField = this.readDataType(0);
        if (this.isCompleteMode && this.lexer.isBufferEnd()) {
            this.addSuggestion(new SyntaxSuggestion(null, "<field name>"));
            throw new ParserCompletionException();
        }
        dataField.setName(this.readLiteral());
        dataField = this.readArrayModifiers(dataField);
        this.readDefaultValue(dataField);
        this.readModifiers(dataField);
        if (this.isSuggestionsNotEmpty()) {
            throw new ParserCompletionException();
        }
        lines.add(dataField);
    }

    private DataField readDataType(int level) throws ParserException, LexerException {
        new AbstractParser.PrefixParserCompleter(this).completers(new SdoTypeCompleter(this.context).onlySimple(false).onlySdoTypes(true)).spaceFirst(false).withRead(false).throwException(false).complete();
        Token token = this.lexer.getCurrentToken();
        if (token.isCommon()) {
            if (this.lexer.isCurrentToken(CommonTokenType.LITERAL)) {
                return this.readSimpleDataTypeWithArrays(level);
            }
            throw this.unexpectedToken();
        }
        switch ((SdoBodyTokenType)token.getCustomType()) {
            case INT: 
            case INTEGER: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case BIGINT: 
            case BIGINTEGER: 
            case BIGDECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case CHAR: 
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case OBJECT: 
            case EVENT: {
                return this.readSimpleDataTypeWithArrays(level);
            }
            case LIST: {
                if (this.isCompleteMode && this.lexer.isAtEnd()) {
                    this.addSuggestion(new SyntaxSuggestion(null, "(<element type> [alias <XmlEntryTypeName>] [, xml-implicit-collection])"));
                }
                this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
                this.lexer.readToken();
                DataField elementDataField = this.readDataType(level + 1);
                ListDataField listDataField = new ListDataField(elementDataField);
                listDataField.setIsArray(false);
                if (this.isCompleteMode && this.lexer.isBufferEnd()) {
                    this.addSuggestion(new SyntaxSuggestion(null, "alias <XmlEntryTypeName>"));
                }
                if (this.lexer.isCurrentToken("alias")) {
                    if (this.isCompleteMode && this.lexer.isAtEnd()) {
                        this.addSuggestion(new SyntaxSuggestion(null, "<XmlEntryTypeName>"));
                    }
                    this.lexer.readToken();
                    listDataField.setEntryTypeName(this.readLiteral());
                }
                if (this.lexer.isCurrentToken("strict")) {
                    this.lexer.readToken();
                    this.lexer.readCurrentToken(CommonTokenType.MINUS);
                    this.lexer.readCurrentToken("case");
                    PropertyNamingStrategy.KebabCaseStrategy kc = (PropertyNamingStrategy.KebabCaseStrategy)PropertyNamingStrategy.KEBAB_CASE;
                    String typeName = kc.translate(listDataField.getType().getName());
                    listDataField.setEntryTypeName(typeName.replaceAll("(\\d+)", "-$1"));
                }
                this.readImplicitAndSuppressGenericType(listDataField);
                this.lexer.readCurrentToken(CommonTokenType.CLOSE_BRACKET);
                return listDataField;
            }
            case MAP: {
                if (this.isCompleteMode && this.lexer.isAtEnd()) {
                    this.addSuggestion(new SyntaxSuggestion(null, "(<keyType>, <valueType> [, xml-implicit-collection]) | (<MapEntryTypeName>(<keyType> [<keyName>], <valueType> [<valueName>]))"));
                }
                this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
                this.lexer.readToken();
                int position = this.lexer.getCurrentTokenPosition();
                MapDataField mapDataField = null;
                try {
                    SimpleDataField keyDataField = this.readSimpleDataFieldWithoutPrecision();
                    if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                        throw new Exception();
                    }
                    mapDataField = new MapDataField(keyDataField.getType());
                    position = -1;
                }
                catch (Exception exception) {
                    if (level > 0) {
                        throw this.parserException("Maps with entry type specified allowed at the top level only.");
                    }
                    this.lexer.rewind(position);
                    this.lexer.readToken();
                    if (this.lexer.getCurrentToken().isDelimiter()) {
                        throw this.unexpectedToken();
                    }
                    String entryTypeName = this.lexer.getCurrentToken().getValue();
                    this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
                    this.lexer.readToken();
                    SimpleDataField keyDataField = this.readSimpleDataFieldWithoutPrecision();
                    mapDataField = new MapDataField(keyDataField.getType());
                    mapDataField.setEntryTypeName(entryTypeName);
                    if (!this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                        mapDataField.setKeyName(this.lexer.getCurrentToken().getValue());
                        this.lexer.readToken(CommonTokenType.COMMA);
                    }
                    this.lexer.readToken();
                    mapDataField.setValueField(this.readDataType(level + 1));
                    if (!this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) {
                        mapDataField.setValueName(this.lexer.getCurrentToken().getValue());
                        this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                    }
                    this.lexer.readCurrentToken(CommonTokenType.CLOSE_BRACKET);
                }
                if (position == -1) {
                    this.lexer.readCurrentToken(CommonTokenType.COMMA);
                    mapDataField.setValueField(this.readDataType(level + 1));
                    this.readImplicitAndSuppressGenericType(mapDataField);
                }
                this.lexer.readCurrentToken(CommonTokenType.CLOSE_BRACKET);
                return mapDataField;
            }
        }
        throw this.unexpectedToken();
    }

    private DataField readSimpleDataTypeWithArrays(int level) throws LexerException, ParserException {
        DataField dataField = this.readSimpleDataType(level);
        dataField = this.readArrayModifiers(dataField);
        return dataField;
    }

    private DataField readArrayModifiers(DataField dataField) throws LexerException, ParserException {
        if (this.isCompleteMode && this.lexer.isBufferEnd() && (dataField instanceof SimpleDataField || dataField instanceof EnumDataField)) {
            this.addSuggestion(new SyntaxSuggestion(null, "[<array size>]"));
        }
        if (this.lexer.isCurrentToken(CommonTokenType.OPEN_SQUARE_BRACKET)) {
            if (!(dataField instanceof SimpleDataField) && !(dataField instanceof EnumDataField)) {
                throw this.unexpectedToken();
            }
            if (this.isCompleteMode && this.lexer.isAtEnd()) {
                this.addSuggestion(new SyntaxSuggestion("[", "<array size>]"));
            }
            ListDataField listDataField = new ListDataField(dataField);
            listDataField.setName(dataField.getName());
            listDataField.setIsArray(true);
            listDataField.setLength(this.readInt());
            this.lexer.readToken(CommonTokenType.CLOSE_SQUARE_BRACKET);
            this.lexer.readToken();
            return listDataField;
        }
        return dataField;
    }

    private DataField readSimpleDataType(int level) throws LexerException, ParserException {
        Token token;
        block22: {
            new AbstractParser.PrefixParserCompleter(this).completers(new SdoTypeCompleter(this.context).onlySimple(true).onlySdoTypes(true)).spaceFirst(false).withRead(false).throwException(false).complete();
            token = this.lexer.getCurrentToken();
            if (token.isCommon()) {
                if (!this.lexer.isCurrentToken(CommonTokenType.LITERAL)) {
                    throw this.unexpectedToken();
                }
                try {
                    Type<?> type = TypeFactory.createType(token.getValue(), this.context);
                    if (type == null) {
                        throw this.parserException("Type '" + token.getValue() + "' not found.");
                    }
                    this.lexer.readToken();
                    if (type instanceof EnumType) {
                        return new EnumDataField(type);
                    }
                    return new SimpleDataField(type);
                }
                catch (ClassNotFoundException e) {
                    if (this.isCompleteMode) break block22;
                    throw this.parserException("Type '" + token.getValue() + "' class cannot be loaded.");
                }
            }
        }
        switch ((SdoBodyTokenType)token.getCustomType()) {
            case INT: 
            case INTEGER: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case BYTE: 
            case BIGINT: 
            case BIGINTEGER: {
                SimpleDataField dataField = this.readSimpleDataFieldWithoutPrecision();
                if (this.isCompleteMode && this.lexer.isBufferEnd() && level == 0) {
                    this.addSuggestion(new SyntaxSuggestion(null, "(<precision>)"));
                }
                if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                    if (level > 1) {
                        throw this.parserException("Precision and scale can be specified for first level types only.");
                    }
                    if (this.isCompleteMode && this.lexer.isAtEnd()) {
                        this.addSuggestion(new SyntaxSuggestion("(", "<precision>)"));
                    }
                    dataField.setPrecision(this.readInt());
                    this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                    this.lexer.readToken();
                }
                return dataField;
            }
            case DOUBLE: 
            case BIGDECIMAL: {
                SimpleDataField dataField = this.readSimpleDataFieldWithoutPrecision();
                if (this.isCompleteMode && this.lexer.isBufferEnd() && level == 0) {
                    this.addSuggestion(new SyntaxSuggestion(null, "(<precision>[, <scale])"));
                }
                if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                    if (level > 1) {
                        throw this.parserException("Precision and scale can be specified for first level types only.");
                    }
                    if (this.isCompleteMode && this.lexer.isAtEnd()) {
                        this.addSuggestion(new SyntaxSuggestion("(", "<precision>[, <scale])"));
                    }
                    dataField.setPrecision(this.readInt());
                    this.lexer.readToken();
                    if (this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                        dataField.setScale(this.readInt());
                        this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                    } else if (!this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) {
                        throw this.unexpectedToken(CommonTokenType.COMMA, CommonTokenType.CLOSE_BRACKET);
                    }
                    this.lexer.readToken();
                }
                return dataField;
            }
            case STRING: 
            case BOOLEAN: 
            case CHAR: 
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case OBJECT: 
            case EVENT: {
                return this.readSimpleDataFieldWithoutPrecision();
            }
        }
        throw this.unexpectedToken();
    }

    private SimpleDataField readSimpleDataFieldWithoutPrecision() throws ParserException, LexerException {
        Token token = this.lexer.getCurrentToken();
        SimpleDataField dataField = new SimpleDataField(TypeFactory.getType(((SdoBodyTokenType)token.getCustomType()).getValue()));
        if (dataField.getType() == null) {
            throw this.parserException("Unknown data type '" + ((SdoBodyTokenType)token.getCustomType()).getValue() + "'.");
        }
        this.lexer.readToken();
        if (this.isCompleteMode && this.lexer.isBufferEnd()) {
            this.addSuggestion(new SyntaxSuggestion(null, "(xml-attribute)"));
        }
        if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
            if (this.isCompleteMode && this.lexer.isAtEnd()) {
                this.addSuggestion(new SyntaxSuggestion("(", "xml-attribute)").setOffset(1));
            }
            int pos = this.lexer.getCurrentTokenPosition();
            this.lexer.readToken();
            if (this.lexer.isCurrentToken("xml")) {
                this.readTokenOrComplete("-", "attribute)");
                this.readTokenOrComplete("attribute", ")");
                this.readTokenOrComplete(CommonTokenType.CLOSE_BRACKET);
                this.lexer.readToken();
                dataField.setIsXmlAttribute(true);
            } else {
                this.lexer.rewind(pos);
                this.lexer.readToken();
            }
        }
        return dataField;
    }

    private void readImplicitAndSuppressGenericType(DataField dataField) throws LexerException, ParserException {
        if (this.isCompleteMode && this.lexer.isBufferEnd()) {
            this.addSuggestion(new SyntaxSuggestion(null, ",xml-implicit-collection"));
        }
        boolean implicit = false;
        boolean suppressGenericType = false;
        if (this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
            this.lexer.readToken();
            if (this.lexer.isCurrentToken("xml")) {
                this.readTokenOrComplete(CommonTokenType.MINUS, "implicit-collection");
                this.readTokenOrComplete("implicit", "-collection");
                this.readTokenOrComplete(CommonTokenType.MINUS, "collection");
                this.readTokenOrComplete("collection");
                implicit = true;
                this.lexer.readToken();
                if (this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                    this.lexer.readToken();
                }
            } else if (this.lexer.isCurrentToken("implicit")) {
                implicit = true;
                this.lexer.readToken();
                if (this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                    this.lexer.readToken();
                }
            }
            if (this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) {
                if (!implicit) {
                    throw this.unexpectedToken();
                }
            } else if (this.lexer.isCurrentToken("json")) {
                this.lexer.readToken(CommonTokenType.MINUS);
                this.lexer.readToken("suppress");
                this.lexer.readToken(CommonTokenType.MINUS);
                this.lexer.readToken("generic");
                this.lexer.readToken(CommonTokenType.MINUS);
                this.lexer.readToken("type");
                this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                suppressGenericType = true;
            }
        }
        if (dataField instanceof ListDataField) {
            ((ListDataField)dataField).setImplicit(implicit);
            ((ListDataField)dataField).setSuppressGenericType(suppressGenericType);
        } else {
            ((MapDataField)dataField).setImplicit(implicit);
            ((MapDataField)dataField).setSuppressGenericType(suppressGenericType);
        }
    }

    private void readDefaultValue(DataField dataField) throws LexerException, ParserException {
        if (this.isCompleteMode && !(dataField instanceof MapDataField) && this.lexer.isBufferEnd()) {
            this.addSuggestion(new SyntaxSuggestion(" = ", this.escapeDefaultValueForField(dataField)));
        }
        if (this.lexer.isCurrentToken(CommonTokenType.ASSIGNMENT_OPERAND)) {
            if (dataField instanceof MapDataField) {
                throw this.parserException("Default value cannot be specified for map type.");
            }
            if (this.isComplexList(dataField)) {
                throw this.parserException("Default value can be specified for list with simple or enum element types.");
            }
            if (this.isCompleteMode && this.lexer.isAtEnd()) {
                this.addSuggestion(new SyntaxSuggestion(null, this.escapeDefaultValueForField(dataField)));
            }
            if (dataField instanceof SimpleDataField) {
                ((SimpleDataField)dataField).setDefaultValue(this.readSingleValueForType(dataField.getType()));
            } else if (dataField instanceof EnumDataField) {
                try {
                    ((EnumDataField)dataField).setDefaultValue(this.readSingleValueForType(dataField.getType()));
                }
                catch (EDLException exception) {
                    throw this.parserException(exception.getMessage());
                }
            } else if (dataField instanceof ListDataField) {
                if (this.isComplexList(dataField)) {
                    throw this.parserException("Default value can be specified for list with simple or enum element types.");
                }
                this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
                ((ListDataField)dataField).setDefaultValues(this.readListValueForType(dataField.getType()));
            }
        }
    }

    private String escapeDefaultValueForField(DataField dataField) {
        if (dataField instanceof ListDataField) {
            return "(" + dataField.getType().escapeValue("<default value>") + ", ...)";
        }
        return dataField.getType().escapeValue("<default value>");
    }

    private String readSingleValueForType(Type<?> type) throws ParserException, LexerException {
        this.lexer.readToken();
        return this.readAndValidateValueForType(type);
    }

    private List<String> readListValueForType(Type<?> type) throws LexerException, ParserException {
        this.lexer.readCurrentToken(CommonTokenType.OPEN_BRACKET);
        ArrayList<String> defaultValues = new ArrayList<String>();
        while (true) {
            if (defaultValues.size() > 0 && this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                this.lexer.readToken();
            } else if (this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) break;
            defaultValues.add(this.readAndValidateValueForType(type));
        }
        this.lexer.readToken();
        return defaultValues;
    }

    private List<Map.Entry<String, String>> readListRangeValueForType(Type<?> type) throws LexerException, ParserException {
        this.lexer.readCurrentToken(CommonTokenType.OPEN_BRACKET);
        ArrayList<Map.Entry<String, String>> rangeValues = new ArrayList<Map.Entry<String, String>>();
        while (true) {
            if (rangeValues.size() > 0 && this.lexer.isCurrentToken(CommonTokenType.COMMA)) {
                this.lexer.readToken();
            } else if (this.lexer.isCurrentToken(CommonTokenType.CLOSE_BRACKET)) break;
            rangeValues.add(new AbstractMap.SimpleEntry<String, String>(this.readAndValidateValueForType(type), this.readAndValidateValueForType(type)));
        }
        this.lexer.readToken();
        return rangeValues;
    }

    private String readAndValidateValueForType(Type<?> type) throws ParserException, LexerException {
        Object value = this.lexer.getCurrentToken().getValue();
        switch (type.getType()) {
            case DATE: 
            case STRING: 
            case CHAR: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: {
                if (this.lexer.isCurrentToken(CommonTokenType.STRING_LITERAL)) break;
                throw this.parserException("Invalid default value '" + this.lexer.getCurrentToken().getValue() + "' for type " + type.getName() + ". Should be string literal in quotes.");
            }
            case ENUM: {
                if (!this.lexer.getCurrentToken().getValue().equals(type.getName())) {
                    throw this.parserException("Invalid value '" + this.lexer.getCurrentToken().getValue() + "' for enum type " + type.getName() + ". Should be in format <EnumTypeName>.<Value>.");
                }
                this.lexer.readToken(CommonTokenType.DOT);
                this.lexer.readToken();
                if (this.lexer.isCurrentToken(CommonTokenType.STRING_LITERAL) || this.lexer.getCurrentToken().isDelimiter()) {
                    throw this.parserException("Invalid value '" + this.lexer.getCurrentToken().getValue() + "' for enum type " + type.getName() + ". Should be in format <EnumTypeName>.<Value>.");
                }
                value = type.getName() + "." + this.lexer.getCurrentToken().getValue();
                break;
            }
            case SEMANTIC_TYPE: {
                throw this.parserException("Values not allowed for semantic types.");
            }
            case INT: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case BIGINT: 
            case BIGDECIMAL: {
                if (((String)value).equals("-") || ((String)value).equals("+")) {
                    value = (String)value + this.lexer.readToken().getValue();
                    break;
                }
                if (!TypeFactory.isHex((String)value)) break;
                value = Long.toString(TypeFactory.fromHex((String)value));
                break;
            }
            case BOOLEAN: {
                break;
            }
        }
        try {
            type.convertValue(value, null);
        }
        catch (ValueConversionException e) {
            throw this.parserException("Value '" + (String)value + "' cannot be converted to data type " + type.getName());
        }
        this.lexer.readToken();
        return value;
    }

    private void readModifiers(DataField dataField) throws ParserException, LexerException {
        EnumSet<Modifiers> modifiersSet = EnumSet.noneOf(Modifiers.class);
        while (true) {
            AbstractParser.PrefixParserCompleter completer = null;
            if (this.isCompleteMode) {
                completer = new AbstractParser.PrefixParserCompleter(this).completers(new SdoBodyModifiersCompleter(dataField, modifiersSet)).spaceFirst(true).throwException(false).withRead(false);
                completer.complete();
            }
            if (this.lexer.isCurrentToken(CommonTokenType.SEMICOLON) || this.lexer.isAtEnd()) break;
            if (this.lexer.isCurrentToken("not")) {
                if (!modifiersSet.add(Modifiers.NOT_NULL)) {
                    this.unexpectedToken();
                }
                this.lexer.readToken("null");
                this.lexer.readToken();
                dataField.setNotNull(true);
                modifiersSet.add(Modifiers.NOT_NULL);
                continue;
            }
            if (this.lexer.isCurrentToken("length")) {
                if (!modifiersSet.add(Modifiers.LENGTH)) {
                    this.unexpectedToken();
                }
                this.checkLengthForField(dataField);
                dataField.setLength(this.readInt());
                this.lexer.readToken();
                continue;
            }
            if (this.lexer.isCurrentToken("description")) {
                if (!modifiersSet.add(Modifiers.DESCRIPTION)) {
                    this.unexpectedToken();
                }
                dataField.setDescription(this.lexer.readToken(CommonTokenType.STRING_LITERAL).getValue());
                this.lexer.readToken();
                continue;
            }
            if (this.lexer.isCurrentToken("alias")) {
                if (!modifiersSet.add(Modifiers.ALIAS)) {
                    this.unexpectedToken();
                }
                dataField.setAlias(this.lexer.readToken(CommonTokenType.STRING_LITERAL).getValue());
                this.lexer.readToken();
                continue;
            }
            if (this.lexer.isCurrentToken("strict")) {
                this.readTokenOrComplete(CommonTokenType.MINUS, "case");
                this.readTokenOrComplete("case");
                if (!modifiersSet.add(Modifiers.STRICT_CASE)) {
                    this.unexpectedToken();
                }
                dataField.setStrictCase(true);
                this.lexer.readToken();
                continue;
            }
            if (this.lexer.isCurrentToken("offset")) {
                if (!modifiersSet.add(Modifiers.OFFSET)) {
                    this.unexpectedToken();
                }
                this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
                int begin = this.readInt();
                this.lexer.readToken(CommonTokenType.MINUS);
                int end = this.readInt();
                if (end < begin) {
                    throw this.parserException("End offset should be greater than begin.");
                }
                dataField.setOffset(begin, end);
                this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
                this.lexer.readToken();
                continue;
            }
            if (this.lexer.isCurrentToken("value")) {
                this.lexer.readToken();
                this.readInModifiers(dataField, modifiersSet, completer);
                continue;
            }
            this.readInModifiers(dataField, modifiersSet, completer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readInModifiers(DataField dataField, Set<Modifiers> modifiersSet, AbstractParser.PrefixParserCompleter completer) throws ParserException, LexerException {
        if (this.isComplexList(dataField)) {
            throw this.parserException("Value in domain/range can be specified for simple lists only.");
        }
        if (this.lexer.isCurrentToken("in")) {
            this.lexer.readToken();
            if (this.lexer.isCurrentToken("domain")) {
                if (!modifiersSet.add(Modifiers.IN_DOMAIN)) {
                    this.unexpectedToken();
                }
                this.lexer.readToken();
                if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                    dataField.setDomainValues(this.readListValueForType(dataField.getType()));
                    return;
                } else {
                    dataField.setDomainName(this.validateDomainName());
                }
                return;
            } else if (this.lexer.isCurrentToken("range")) {
                if (!modifiersSet.add(Modifiers.IN_RANGE)) {
                    this.unexpectedToken();
                }
                this.lexer.readToken();
                if (this.lexer.isCurrentToken(CommonTokenType.OPEN_BRACKET)) {
                    dataField.setRangeValues(this.readListRangeValueForType(dataField.getType()));
                    return;
                } else {
                    dataField.setRangeName(this.validateRangeName(dataField.getType()));
                }
                return;
            } else {
                if (!this.lexer.isCurrentToken("enum")) throw this.unexpectedToken();
                if (!modifiersSet.add(Modifiers.IN_ENUM)) {
                    this.unexpectedToken();
                }
                this.lexer.readToken();
                dataField.setEnumName(this.readLiteral());
            }
            return;
        } else {
            if (!this.lexer.isCurrentToken("matches")) throw this.unexpectedToken();
            if (!modifiersSet.add(Modifiers.MATCHES)) {
                this.unexpectedToken();
            }
            this.lexer.readToken(CommonTokenType.OPEN_BRACKET);
            dataField.setRegexp(this.lexer.readToken(CommonTokenType.STRING_LITERAL).getValue());
            this.lexer.readToken(CommonTokenType.CLOSE_BRACKET);
            this.lexer.readToken();
        }
    }

    private String validateDomainName() throws ParserException, LexerException {
        String domainName = this.lexer.getCurrentToken().getValue();
        if (RuntimeContext.getInstance().getModerator().lookupDomainConstraint(domainName) == null && RuntimeContext.getInstance().getModerator().lookupDomainConstraint(domainName) == null) {
            throw this.parserException("Domain constraint'" + domainName + "' doesn't exist.");
        }
        this.lexer.readToken();
        return domainName;
    }

    private String validateRangeName(Type<?> type) throws ParserException, LexerException {
        String rangeName = this.lexer.getCurrentToken().getValue();
        switch (type.getType()) {
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case INT: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case BIGDECIMAL: {
                if (RuntimeContext.getInstance().getModerator().lookupRangeConstraint(rangeName) != null) break;
                throw this.parserException("Range constraint '" + rangeName + "' does not exist.");
            }
            default: {
                throw this.parserException("Range constraint not allowed for type '" + type.getName() + "'.");
            }
        }
        this.lexer.readToken();
        return rangeName;
    }

    private void checkLengthForField(DataField dataField) throws ParserException {
        if (dataField instanceof ListDataField) {
            if (((ListDataField)dataField).isArray()) {
                throw this.parserException("Length cannot be specified for arrays.");
            }
        } else if (dataField instanceof SimpleDataField) {
            if (dataField.getType().getType() != Types.STRING) {
                throw this.parserException("Length cannot be specified for type '" + dataField.getType().getName() + "'.");
            }
        } else if (dataField instanceof EnumDataField) {
            throw this.parserException("Length cannot be specified for enums.");
        }
    }

    boolean isComplexList(DataField field) {
        return field instanceof ListDataField && !((ListDataField)field).isSimpleElementDataField();
    }

    static enum Modifiers {
        NOT_NULL,
        LENGTH,
        DESCRIPTION,
        ALIAS,
        STRICT_CASE,
        OFFSET,
        IN_DOMAIN,
        IN_RANGE,
        IN_ENUM,
        MATCHES;

    }

    class SdoBodyModifiersCompleter
    implements PrefixCompleter {
        private DataField dataField;
        private Set<Modifiers> modifiersSet;

        SdoBodyModifiersCompleter(DataField dataField, Set<Modifiers> modifiersSet) {
            this.dataField = dataField;
            this.modifiersSet = modifiersSet;
        }

        @Override
        public DSLCompletion complete(String prefix) {
            PrefixTree<Object> prefixTree = new PrefixTree<Object>();
            block11: for (Modifiers modifier : Modifiers.values()) {
                if (this.modifiersSet.contains((Object)modifier)) continue;
                switch (modifier.ordinal()) {
                    case 0: {
                        prefixTree.add("not null", new Object());
                        continue block11;
                    }
                    case 1: {
                        if (this.dataField instanceof ListDataField && ((ListDataField)this.dataField).isArray() || this.dataField instanceof SimpleDataField && this.dataField.getType().getType() != Types.STRING || this.dataField instanceof EnumDataField) continue block11;
                        prefixTree.add("length", new SyntaxSuggestion("length", "<length>"));
                        continue block11;
                    }
                    case 2: {
                        prefixTree.add("description", new SyntaxSuggestion("description", "'<description>'"));
                        continue block11;
                    }
                    case 3: {
                        prefixTree.add("alias", new SyntaxSuggestion("alias", "'<alias>'"));
                        continue block11;
                    }
                    case 5: {
                        prefixTree.add("offset", new SyntaxSuggestion("offset", "(<begin>-<end>)"));
                        continue block11;
                    }
                    case 6: {
                        if (SdoBodyParser.this.isComplexList(this.dataField)) continue block11;
                        prefixTree.add("value in domain", new SyntaxSuggestion("value in domain", "{ (" + this.dataField.getType().escapeValue("<value>") + ", ...) | <Domain Name> }"));
                        continue block11;
                    }
                    case 7: {
                        if (SdoBodyParser.this.isComplexList(this.dataField)) continue block11;
                        prefixTree.add("value in range", new SyntaxSuggestion("value in range", "{ (" + this.dataField.getType().escapeValue("<low value>") + " " + this.dataField.getType().escapeValue("<high value>") + ", ...) | <Range Name> }"));
                        continue block11;
                    }
                    case 8: {
                        if (SdoBodyParser.this.isComplexList(this.dataField)) continue block11;
                        prefixTree.add("value in enum", new SyntaxSuggestion("value in enum", "<Enum Name>"));
                        continue block11;
                    }
                    case 9: {
                        if (SdoBodyParser.this.isComplexList(this.dataField)) continue block11;
                        prefixTree.add("value matches", new SyntaxSuggestion("value matches", "(<Regular Epression>)"));
                        continue block11;
                    }
                }
            }
            PrefixTreeCompleter completer = new PrefixTreeCompleter(prefixTree);
            return completer.completeDsl(prefix);
        }
    }
}

