/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.parser;

import com.streamscape.repository.types.Prototype;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import java.util.List;

public class EventIdCompleter
implements PrefixCompleter {
    private FabricContext context;
    private boolean inBrackets = false;
    private boolean events = true;
    private boolean exceptions = true;
    private boolean advisories = true;
    private EventIdFilter filter = null;

    public EventIdCompleter(TriggerFunctionParserContext context) {
        this(context.getFabricContext());
    }

    public EventIdCompleter(FabricContext context) {
        this.context = context;
    }

    public EventIdCompleter setFilter(EventIdFilter filter) {
        this.filter = filter;
        return this;
    }

    public EventIdCompleter inBrackets(boolean inBrackets) {
        this.inBrackets = inBrackets;
        return this;
    }

    public EventIdCompleter onlyEvents() {
        this.events = true;
        this.exceptions = false;
        this.advisories = false;
        return this;
    }

    public EventIdCompleter onlyExceptions() {
        this.events = false;
        this.exceptions = true;
        this.advisories = false;
        return this;
    }

    public EventIdCompleter onlyAdvisories() {
        this.events = false;
        this.exceptions = false;
        this.advisories = true;
        return this;
    }

    public EventIdCompleter withEvents() {
        this.events = true;
        return this;
    }

    public EventIdCompleter withExceptions() {
        this.exceptions = true;
        return this;
    }

    public EventIdCompleter withAdvisories() {
        this.advisories = true;
        return this;
    }

    public EventIdCompleter withAll() {
        this.events = true;
        this.advisories = true;
        this.advisories = true;
        return this;
    }

    public EventIdCompleter none() {
        this.events = false;
        this.advisories = false;
        this.advisories = false;
        return this;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        PrefixTree<Object> prefixTree = new PrefixTree<Object>(true);
        if (this.events) {
            this.addEventsFrom(prefixTree, this.context.getEventDatagramFactory().listEventIds());
            this.addEventsFrom(prefixTree, this.context.getOpaqueDatagramFactory().listEventIds());
        }
        if (this.exceptions) {
            this.addEventsFrom(prefixTree, this.context.getExceptionDatagramFactory().listEventIds());
        }
        if (this.advisories) {
            this.addEventsFrom(prefixTree, this.context.getAdvisoryDatagramFactory().listEventIds());
        }
        return new PrefixTreeCompleter<Object>(prefixTree).completeDsl(prefix);
    }

    private void addEventsFrom(PrefixTree<Object> prefixTree, List<String> eventIds) {
        for (String eventId : eventIds) {
            Prototype prototype;
            if (!AbstractOperation.isUserEvent(eventId) || this.filter != null && !this.filter.accept(prototype = this.context.getDatagramPrototypeCache().lookupPrototype(eventId))) continue;
            prefixTree.add((String)(this.inBrackets ? "[" + eventId + "]" : eventId), (Object)SuggestionGroup.EVENT_ID);
        }
    }

    public static interface EventIdFilter {
        public boolean accept(Prototype var1);
    }
}

