/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.parser;

import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.parser.SdoBodyTokenType;
import com.streamscape.slex.lang.completion.AbstractSuggestion;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionSequence;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.parser.AbstractParser;
import com.streamscape.tools.parser.ParserCompletionException;
import com.streamscape.tools.parser.ParserException;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractSdoParser
extends AbstractParser<SdoBodyTokenType> {
    public AbstractSdoParser() throws ParserException {
        super(SdoBodyTokenType.class);
    }

    public List<DataField> parse(String buffer) throws ParserException {
        this.lexer.reset(buffer);
        ArrayList<DataField> lines = new ArrayList<DataField>();
        try {
            this.readTokenOrComplete(CommonTokenType.OPEN_CURLY_BRACKET);
            this.parseLines(lines);
            if (!this.lexer.isCurrentToken(CommonTokenType.BUFFER_END)) {
                throw this.unexpectedToken(CommonTokenType.BUFFER_END);
            }
        }
        catch (LexerException exception) {
            throw this.parserException(exception.getMessage());
        }
        return lines;
    }

    private void parseLines(List<DataField> lines) throws LexerException, ParserException {
        this.lexer.readIfCurrentToken(CommonTokenType.OPEN_CURLY_BRACKET);
        do {
            this.readLine(lines);
            this.lexer.readCurrentToken(CommonTokenType.SEMICOLON);
        } while (!this.lexer.isCurrentToken(CommonTokenType.CLOSE_CURLY_BRACKET));
        this.lexer.readToken();
    }

    protected abstract void readLine(List<DataField> var1) throws ParserException, LexerException;

    protected String readLiteral() throws LexerException, ParserException {
        Token token = this.lexer.getCurrentToken();
        if (token.isDelimiter()) {
            throw this.unexpectedToken();
        }
        if (token.getValue() == null || token.getValue().equals("")) {
            throw this.unexpectedToken();
        }
        this.lexer.readToken();
        return token.getValue();
    }

    @Override
    protected void onComplete(String buffer) throws ParserException {
        this.parse(buffer);
    }

    protected Token<SdoBodyTokenType> readTokenOrComplete(TokenType tokenType) throws LexerException, ParserCompletionException {
        return this.readTokenOrComplete(tokenType, (Object[])null);
    }

    protected Token<SdoBodyTokenType> readTokenOrComplete(TokenType tokenType, Object ... additionalCompletions) throws LexerException, ParserCompletionException {
        try {
            return this.lexer.readToken(tokenType);
        }
        catch (LexerException exception) {
            if (!this.isCompleteMode) {
                throw exception;
            }
            DSLCompletion completion = this.buildTokenCompletion(tokenType);
            this.appendCompletions(completion, additionalCompletions);
            throw new ParserCompletionException(completion);
        }
    }

    protected void completeThisToken(String tokenType) throws LexerException, ParserCompletionException {
        this.completeThisToken(tokenType, null);
    }

    protected void completeThisToken(String tokenType, Object ... additionalCompletions) throws LexerException, ParserCompletionException {
        if (this.isCompleteMode && (this.lexer.isAtEnd() || this.lexer.isCurrentToken(CommonTokenType.BUFFER_END))) {
            if (this.lexer.isCurrentToken(tokenType)) {
                return;
            }
            DSLCompletion completion = this.buildTokenCompletion(tokenType);
            this.appendCompletions(completion, additionalCompletions);
            throw new ParserCompletionException(completion);
        }
    }

    protected Token<SdoBodyTokenType> readTokenOrComplete(String tokenType) throws LexerException, ParserCompletionException {
        return this.readTokenOrComplete(tokenType, (Object[])null);
    }

    protected Token<SdoBodyTokenType> readTokenOrComplete(String tokenType, Object ... additionalCompletions) throws LexerException, ParserCompletionException {
        try {
            return this.lexer.readToken(tokenType);
        }
        catch (LexerException exception) {
            if (!this.isCompleteMode) {
                throw exception;
            }
            this.completeThisToken(tokenType, additionalCompletions);
            return null;
        }
    }

    private DSLCompletion buildTokenCompletion(Object tokenType) throws LexerException {
        DSLCompletion completion = null;
        if (tokenType instanceof TokenType ? this.lexer.isCurrentToken((TokenType)tokenType) : this.lexer.isCurrentToken(tokenType.toString())) {
            completion = new DSLCompletion();
        } else if (this.lexer.isAtEnd() && !this.lexer.isThereSpaceAfterCurrentToken()) {
            String value;
            String string = value = tokenType instanceof TokenType ? ((TokenType)tokenType).getValue() : tokenType.toString();
            if (value != null) {
                return DSLCompletion.buildPrefixAndCompletion(this.lexer.getCurrentToken().getValue(), value);
            }
        }
        return completion;
    }

    private void appendCompletions(DSLCompletion completion, Object ... additionalCompletions) {
        if (completion != null && completion.getCompletion() != null && additionalCompletions != null) {
            for (Object additionalCompletion : additionalCompletions) {
                SuggestionSequence seq = completion.getCompletion().asSequence();
                if (additionalCompletion instanceof Suggestion) {
                    seq.add((Suggestion)additionalCompletion);
                } else {
                    seq.add(new TokenSuggestion(additionalCompletion.toString()));
                }
                completion.setCompletion(seq);
            }
        }
    }

    protected Suggestion getTokenCompletion(Object tokenType) {
        AbstractSuggestion suggestion = null;
        if (!(tokenType instanceof TokenType)) {
            suggestion = new TokenSuggestion(tokenType.toString());
        } else if (((TokenType)tokenType).getValue() != null) {
            suggestion = new TokenSuggestion(((TokenType)tokenType).getValue());
        } else if (tokenType instanceof CommonTokenType) {
            switch ((CommonTokenType)tokenType) {
                case LITERAL: {
                    suggestion = new SyntaxSuggestion(null, "<literal>");
                    break;
                }
                case STRING_LITERAL: {
                    suggestion = new SyntaxSuggestion(null, "'<literal>'");
                    break;
                }
                case NUMBER: {
                    suggestion = new SyntaxSuggestion(null, "<number>");
                    break;
                }
                case EVENT_ID: {
                    suggestion = new SyntaxSuggestion(null, "[<eventId>]");
                    break;
                }
            }
        }
        return suggestion;
    }
}

