/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.javadoc;

import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.EnumDataField;
import com.streamscape.runtime.mf.operation.edl.ListDataField;
import com.streamscape.runtime.mf.operation.edl.MapDataField;
import com.streamscape.runtime.mf.operation.edl.SimpleDataField;
import com.streamscape.runtime.mf.operation.edl.StaticStringDataField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.sef.evtrigger.function.types.Type;

public class SdoJavaDocGenerator {
    public static JavaDoc createJavaDocForField(SdoField sdoField, DataField dataField) throws EDLException {
        int i;
        JavaDoc.Builder builder = new JavaDoc.Builder();
        if (dataField.getDescription() != null && dataField.getDescription().length() > 0) {
            builder.append(dataField.getDescription()).p().newLine().p().newLine();
        }
        builder.append("Field: ").code(sdoField.getName()).p().newLine();
        builder.append("Type: ").code(SdoJavaDocGenerator.getStringType(dataField)).p().newLine();
        if (dataField instanceof MapDataField) {
            return builder.build();
        }
        Type<?> fieldType = dataField.getType();
        Object defaultValue = null;
        if (dataField instanceof ListDataField) {
            defaultValue = "{";
            for (i = 0; i < ((ListDataField)dataField).getDefaultValues().size(); ++i) {
                if (i > 0) {
                    defaultValue = (String)defaultValue + ",";
                }
                defaultValue = (String)defaultValue + fieldType.escapeValue(((ListDataField)dataField).getDefaultValues().get(i));
            }
            defaultValue = (String)defaultValue + "}";
        }
        if (dataField instanceof SimpleDataField) {
            defaultValue = fieldType.escapeValue(((SimpleDataField)dataField).getDefaultValue());
        }
        if (dataField instanceof StaticStringDataField) {
            defaultValue = fieldType.escapeValue(((StaticStringDataField)dataField).getName());
        }
        if (dataField instanceof EnumDataField) {
            defaultValue = fieldType.escapeValue(((EnumDataField)dataField).getDefaultValue());
        }
        if (defaultValue != null) {
            builder.append("Default value: ").append((String)defaultValue).p().newLine();
        }
        if (dataField.getDomainName() != null) {
            builder.append("Named domain: ").append(dataField.getDomainName()).p().newLine();
        }
        if (dataField.getDomainValues() != null && dataField.getDomainValues().size() > 0) {
            builder.append("In domain: (");
            for (i = 0; i < dataField.getDomainValues().size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(fieldType.escapeValue(dataField.getDomainValues().get(i)));
            }
            builder.append(")").p().newLine();
        }
        if (dataField.getRangeName() != null) {
            builder.append("Named range: ").append(dataField.getRangeName()).p().newLine();
        }
        if (dataField.getRangeValues() != null && dataField.getRangeValues().size() > 0) {
            builder.append("In range: (");
            for (i = 0; i < dataField.getRangeValues().size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(fieldType.escapeValue(dataField.getRangeValues().get(i).getKey())).append(" - ").append(fieldType.escapeValue(dataField.getRangeValues().get(i).getValue()));
            }
            builder.append(")").p().newLine();
        }
        if (dataField.getRegexp() != null) {
            builder.append("Regexp: (").append(dataField.getRegexp()).append(")").p().newLine();
        }
        if (dataField.getLength() != null) {
            builder.append("Maximum length: ").code(dataField.getLength().toString()).p().newLine();
        }
        if (dataField.getBeginOffset() != null && dataField.getEndOffset() != null) {
            builder.append("Offset: ").append(dataField.getBeginOffset().toString() + "-" + dataField.getEndOffset().toString()).p().newLine();
        }
        return builder.build();
    }

    private static String getStringType(DataField dataField) {
        if (dataField instanceof ListDataField) {
            return "java.util.List<" + SdoJavaDocGenerator.getStringType(((ListDataField)dataField).getElementDataField()) + ">";
        }
        if (dataField instanceof MapDataField) {
            return "java.util.Map<" + dataField.getType().getJavaClassName() + ", " + SdoJavaDocGenerator.getStringType(((MapDataField)dataField).getValueField()) + ">";
        }
        return dataField.getType().getJavaClassName();
    }

    public static JavaDoc createJavaDocForClass(String comment) {
        if (comment == null || comment.length() == 0) {
            return null;
        }
        return new JavaDoc.Builder().appendUnformattedJavaDoc(comment).build();
    }

    public static String createJavaDocForGetMethod(DataField dataField) {
        return null;
    }
}

