/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.javadoc;

import com.streamscape.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class JavaDocTextFormatter {
    private BufferedReader reader;
    private boolean insideComment = false;
    private StringBuilder result;

    public String format(String javaDoc) {
        this.reader = new BufferedReader(new StringReader(javaDoc));
        this.result = new StringBuilder();
        this.insideComment = false;
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (this.insideComment) {
                    this.formatLineInsideComment(line);
                    continue;
                }
                this.formatLineOutsideComment(line);
            }
        }
        catch (IOException exception) {
            Trace.logException(this, exception, false);
        }
        return this.result.toString();
    }

    private void formatLineInsideComment(String line) {
        this.formatLineInsideComment(line, 0, true);
    }

    private void formatLineInsideComment(String line, int index, boolean printEmptyLine) {
        String data;
        int afterSpaces = this.skipSpaces(line, index);
        if (afterSpaces == line.length() && printEmptyLine) {
            this.result.append(line).append("\n");
            return;
        }
        if (line.charAt(afterSpaces) == '*') {
            index = this.skipChars(line, afterSpaces, "*");
        }
        if (index == line.length() && printEmptyLine) {
            this.result.append("\n");
            return;
        }
        int endCommentIndex = line.indexOf("*/", index > 0 ? index - 1 : index);
        if (endCommentIndex == -1) {
            this.result.append(line.substring(index)).append("\n");
            return;
        }
        int startEndCommentIndex = endCommentIndex;
        while (startEndCommentIndex - 1 > index && line.charAt(startEndCommentIndex - 1) == '*') {
            --startEndCommentIndex;
        }
        if (index < startEndCommentIndex && (data = line.substring(index, startEndCommentIndex)).trim().length() > 0) {
            this.result.append(data).append("\n");
        }
        this.insideComment = false;
        index = endCommentIndex + 2;
        if (index <= line.length() && printEmptyLine) {
            data = line.substring(index);
            if ((data = data.trim()).length() > 0) {
                this.result.append(data).append("\n");
            }
        }
    }

    private void formatLineOutsideComment(String line) {
        int index = this.skipSpaces(line, 0);
        if (index == line.length()) {
            this.result.append(line).append("\n");
            return;
        }
        int openCommentIndex = line.indexOf("/**", index);
        if (openCommentIndex == -1) {
            this.result.append(line).append("\n");
            return;
        }
        index = openCommentIndex + 3;
        this.insideComment = true;
        if ((index = this.skipChars(line, index - 1, "*")) == line.length()) {
            return;
        }
        this.formatLineInsideComment(line, index - 1, false);
    }

    private int skipSpaces(String line, int startIndex) {
        return this.skipChars(line, startIndex, " \n\t\r");
    }

    private int skipChars(String line, int startIndex, String chars) {
        while (startIndex < line.length()) {
            if (chars.indexOf(line.charAt(startIndex)) == -1) {
                return startIndex;
            }
            ++startIndex;
        }
        return startIndex;
    }
}

