/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.javadoc;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.html.ServiceEventHandlersHtmlTable;
import com.streamscape.sef.network.http.server.html.ServicesHtmlTable;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDocHtmlFormatter
implements JavaDoc.Formatter {
    private static Pattern LINK_PATTERN = Pattern.compile("\\{\\s*@link\\s*([^\\}]*)\\s*\\}");
    private static Pattern LINK_TYPE_PATTERN;
    private static Pattern CODE_PATTERN;
    private static Pattern ANY_TAG_PATTERN;
    private DataspaceType dataspaceType;
    private String dataspaceName;

    public JavaDocHtmlFormatter(DataspaceType dataspaceType, String dataspaceName) {
        this.dataspaceType = dataspaceType;
        this.dataspaceName = dataspaceName;
    }

    @Override
    public String format(JavaDoc javaDoc) {
        String rawJavaDoc = javaDoc.getJavaDoc();
        StringBuffer builder = new StringBuffer(rawJavaDoc);
        builder = this.matchAndReplaceLinks(builder);
        builder = this.matchAndReplaceCode(builder);
        builder = this.matchAndReplaceOtherTags(builder);
        return builder.toString();
    }

    protected StringBuffer matchAndReplaceLinks(StringBuffer builder) {
        Matcher linkMatcher = LINK_PATTERN.matcher(builder);
        if (linkMatcher.find()) {
            builder = new StringBuffer();
            do {
                Object link = "";
                String value = linkMatcher.group(1);
                Matcher linkTypeMatcher = LINK_TYPE_PATTERN.matcher(value);
                if (linkTypeMatcher.find()) {
                    value = linkTypeMatcher.group(2).trim();
                    link = this.makeLink(linkTypeMatcher.group(1), value);
                } else {
                    link = value;
                    if (value.startsWith("www")) {
                        link = "http://" + (String)link;
                    }
                }
                linkMatcher.appendReplacement(builder, Matcher.quoteReplacement(HTTPUtils.getHyperLink(value, (String)link)));
            } while (linkMatcher.find());
            linkMatcher.appendTail(builder);
        }
        return builder;
    }

    private String makeLink(String type, String value) {
        String[] values;
        Object link = type.equals(JavaDoc.Builder.LINK_COLLECTION) ? ((values = value.split("\\.")).length == 3 ? new DataspacesHtmlTable.DataspaceCollectionsHtmlTable.DataspaceCollectionLink(values[0] + "." + values[1], values[2]).getLinkTo() : (values.length == 2 ? new DataspacesHtmlTable.DataspaceCollectionsHtmlTable.DataspaceCollectionLink((this.dataspaceType != null ? this.dataspaceType.name().toLowerCase() : "tspace") + "." + values[0], values[1]).getLinkTo() : (values.length == 1 && this.dataspaceType != null && this.dataspaceType != null ? new DataspacesHtmlTable.DataspaceCollectionsHtmlTable.DataspaceCollectionLink(this.dataspaceType.name().toLowerCase() + "." + this.dataspaceName, values[0]).getLinkTo() : "invalid/collection/name/shouldbe/in/format/<DataspaceType>.<DataspaceName>.<CollectionName>"))) : (type.equals(JavaDoc.Builder.LINK_FUNCTION) ? ((values = value.split("\\.")).length == 3 ? new DataspacesHtmlTable.DataspaceFunctionsHtmlTable.DataspaceFunctionLink(values[0] + "." + values[1], values[2]).getLinkTo() : (values.length == 2 ? new DataspacesHtmlTable.DataspaceFunctionsHtmlTable.DataspaceFunctionLink((this.dataspaceType != null ? this.dataspaceType.name().toLowerCase() : "tspace") + "." + values[0], values[1]).getLinkTo() : (values.length == 1 && this.dataspaceType != null && this.dataspaceType != null ? new DataspacesHtmlTable.DataspaceFunctionsHtmlTable.DataspaceFunctionLink(this.dataspaceType.name().toLowerCase() + "." + this.dataspaceName, values[0]).getLinkTo() : "invalid/function/name/shouldbe/in/format/<DataspaceType>.<DataspaceName>.<FunctionName>"))) : (type.equals(JavaDoc.Builder.LINK_HANDLER) ? ((values = value.split("\\.")).length > 2 ? new ServiceEventHandlersHtmlTable.ServiceEventHandlerLink(values[0], values[1], values[2]).getLinkTo() : "invalid/handler/name/shouldbe/in/format/<ServiceType>.<ServiceName>.<HandlerName>") : (type.equals(JavaDoc.Builder.LINK_PROTOTYPE) ? new EventPrototypesHtmlTable.EventPrototypeLink(value).getLinkTo() : (type.equals(JavaDoc.Builder.LINK_SERVICE) ? new ServicesHtmlTable.ServiceLink(value).getLinkTo() : (type.equals(JavaDoc.Builder.LINK_TYPE) ? new SemanticTypeLink(value).getLinkTo() : "/invalid/link/type/" + type)))));
        return link;
    }

    protected StringBuffer matchAndReplaceCode(StringBuffer builder) {
        Matcher codeMatcher = CODE_PATTERN.matcher(builder);
        if (codeMatcher.find()) {
            builder = new StringBuffer();
            do {
                String code = codeMatcher.group(1);
                codeMatcher.appendReplacement(builder, Matcher.quoteReplacement("<code>" + code + "</code>"));
            } while (codeMatcher.find());
            codeMatcher.appendTail(builder);
        }
        return builder;
    }

    protected StringBuffer matchAndReplaceOtherTags(StringBuffer builder) {
        Matcher tagMatcher = ANY_TAG_PATTERN.matcher(builder);
        if (tagMatcher.find()) {
            OrderedTags orderedTags = new OrderedTags();
            builder = new StringBuffer();
            do {
                orderedTags.addTag(tagMatcher.group(1).trim(), tagMatcher.group(2).trim());
                tagMatcher.appendReplacement(builder, "");
            } while (tagMatcher.find());
            tagMatcher.appendTail(builder);
            builder.append("<dl>\n");
            for (OrderedTags.Tag tag : orderedTags.listOrderedTags()) {
                this.appendTag(builder, tag);
            }
            builder.append("</dl>\n");
        }
        return builder;
    }

    private void appendTag(StringBuffer builder, OrderedTags.Tag tag) {
        if (tag.getName().equalsIgnoreCase(JavaDoc.Builder.TAG_TODO)) {
            builder.append("<hr>");
        }
        builder.append("<dt><b>").append(tag.getPrintName()).append("</b></dt>");
        for (String value : tag.values) {
            value = value.trim();
            if (tag.getName().equalsIgnoreCase(JavaDoc.Builder.TAG_RAISES)) {
                for (String value1 : value.split("\\s")) {
                    if ((value1 = value1.trim()).length() <= 0) continue;
                    String link = this.makeLink(JavaDoc.Builder.LINK_PROTOTYPE, value1);
                    String httpLink = HTTPUtils.getHyperLink(value1, link);
                    builder.append("<dd>").append(httpLink).append("</dd>\n");
                }
                continue;
            }
            for (String value1 : value.split("\n")) {
                if ((value1 = value1.trim()).length() <= 0) continue;
                builder.append("<dd>").append(value1).append("</dd>\n");
            }
        }
    }

    static {
        String pattern = "(" + JavaDoc.Builder.LINK_COLLECTION + "|" + JavaDoc.Builder.LINK_FUNCTION + "|" + JavaDoc.Builder.LINK_HANDLER + "|" + JavaDoc.Builder.LINK_PROTOTYPE + "|" + JavaDoc.Builder.LINK_SERVICE + "|" + JavaDoc.Builder.LINK_TYPE + ")#(.*)$";
        LINK_TYPE_PATTERN = Pattern.compile(pattern);
        CODE_PATTERN = Pattern.compile("\\{\\s*@code\\s*([^\\}]*)\\s*\\}");
        ANY_TAG_PATTERN = Pattern.compile("@([\\w]+)\\s*([^(\\@)$]*)");
    }

    private static class OrderedTags {
        private Map<String, Tag> tags = new HashMap<String, Tag>();
        private int nextOrderIndex = TagUtils.MAX_ORDER_INDEX + 1;

        OrderedTags() {
        }

        void addTag(String name, String value) {
            Tag tag = this.tags.get(name);
            if (tag == null) {
                this.tags.put(name, new Tag(this, name, value));
            } else {
                tag.addValue(value);
            }
        }

        List<Tag> listOrderedTags() {
            ArrayList<Tag> orderedTags = new ArrayList<Tag>(this.tags.values());
            Collections.sort(orderedTags, new Comparator<Tag>(this){

                @Override
                public int compare(Tag o1, Tag o2) {
                    return Integer.compare(o1.order, o2.order);
                }
            });
            return orderedTags;
        }

        class Tag {
            private String name;
            private String printName;
            private List<String> values = new ArrayList<String>();
            private int order;

            Tag(OrderedTags this$0, String name, String value) {
                this.name = name;
                this.values.add(value);
                TagUtils.TagInfo tagInfo = TagUtils.getTagInfo(name);
                if (tagInfo != null) {
                    this.printName = tagInfo.printName;
                    this.order = tagInfo.order;
                } else {
                    this.printName = Character.toUpperCase(name.toLowerCase().charAt(0)) + name.substring(1);
                    this.order = this$0.nextOrderIndex++;
                }
            }

            void addValue(String value) {
                this.values.add(value);
            }

            String getName() {
                return this.name;
            }

            String getPrintName() {
                return this.printName;
            }

            List<String> getValues() {
                return this.values;
            }
        }
    }

    private static class TagUtils {
        private static final Map<String, TagInfo> TAGS = new HashMap<String, TagInfo>();
        private static final int MAX_ORDER_INDEX;

        private TagUtils() {
        }

        private static void indexTag(String name, int orderIndex, String printName) {
            TAGS.put(name, new TagInfo(orderIndex, printName));
        }

        static TagInfo getTagInfo(String name) {
            return TAGS.get(name);
        }

        static {
            TagUtils.indexTag(JavaDoc.Builder.TAG_AUTHOR, 1, "Author");
            TagUtils.indexTag(JavaDoc.Builder.TAG_VERSION, 2, "Version");
            TagUtils.indexTag(JavaDoc.Builder.TAG_COPYRIGHT, 3, "Copyright");
            TagUtils.indexTag(JavaDoc.Builder.TAG_SINCE, 4, "Since");
            TagUtils.indexTag(JavaDoc.Builder.TAG_SEE, 5, "See also");
            TagUtils.indexTag(JavaDoc.Builder.TAG_RAISES, 0x7FFFFFFE, "Raises Events");
            TagUtils.indexTag(JavaDoc.Builder.TAG_TODO, Integer.MAX_VALUE, "Todo");
            MAX_ORDER_INDEX = 5;
        }

        static class TagInfo {
            int order;
            String printName;

            TagInfo(int order, String printName) {
                this.order = order;
                this.printName = printName;
            }
        }
    }
}

