/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.javadoc;

import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDocSourceCodeFormatter;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDocTextFormatter;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.List;

public class JavaDoc {
    public static final String HELP = "Javadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n";
    private String javaDoc;

    JavaDoc(String javaDoc) {
        this.javaDoc = javaDoc;
    }

    public String format(Formatter formatter) {
        return formatter.format(this);
    }

    public String toString() {
        return this.format(new JavaDocSourceCodeFormatter());
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public static interface Formatter {
        public String format(JavaDoc var1);
    }

    public static class Builder {
        public static String LINK_TYPE = "type";
        public static String LINK_PROTOTYPE = "prototype";
        public static String LINK_SERVICE = "service";
        public static String LINK_HANDLER = "handler";
        public static String LINK_COLLECTION = "collection";
        public static String LINK_FUNCTION = "function";
        public static String TAG_CODE = "code";
        public static String TAG_AUTHOR = "author";
        public static String TAG_VERSION = "version";
        public static String TAG_COPYRIGHT = "copyright";
        public static String TAG_SINCE = "since";
        public static String TAG_SEE = "see";
        public static String TAG_RAISES = "raises";
        public static String TAG_TODO = "todo";
        StringBuilder builder = new StringBuilder();

        public Builder linkType(String typeName) {
            return this.link(LINK_TYPE, typeName);
        }

        public Builder linkPrototype(String eventId) {
            return this.link(LINK_PROTOTYPE, eventId);
        }

        public Builder linkService(String serviceName) {
            return this.link(LINK_SERVICE, serviceName);
        }

        public Builder linkHandler(String handlerName) {
            return this.link(LINK_HANDLER, handlerName);
        }

        public Builder linkCollection(String collectionName) {
            return this.link(LINK_COLLECTION, collectionName);
        }

        public Builder linkFunction(String functionName) {
            return this.link(LINK_FUNCTION, functionName);
        }

        private Builder link(String type, String value) {
            return this.append("{@link " + type + "#" + value + "}");
        }

        public Builder appendLine(String line) {
            this.builder.append(line).append("\n");
            return this;
        }

        public Builder append(String line) {
            this.builder.append(line);
            return this;
        }

        public Builder code(String line) {
            this.builder.append("<code>").append(line).append("</code>");
            return this;
        }

        public Builder pre(String line) {
            this.builder.append("<pre>").append(line).append("</pre>");
            return this;
        }

        public Builder author(String author) {
            return this.tag(TAG_AUTHOR, author);
        }

        public Builder version(String version) {
            return this.tag(TAG_VERSION, version);
        }

        public Builder copyright(String copyright) {
            return this.tag(TAG_COPYRIGHT, copyright);
        }

        public Builder since(String since) {
            return this.tag(TAG_SINCE, since);
        }

        public Builder seealso(String see) {
            return this.tag(TAG_SEE, see);
        }

        public Builder todo(String todo) {
            return this.tag(TAG_TODO, todo);
        }

        public Builder raises(String events) {
            return this.tag(TAG_RAISES, events);
        }

        public Builder tag(String tag, String value) {
            this.builder.append("@").append(tag).append(" ").append(value).append("\n");
            return this;
        }

        public Builder p() {
            this.builder.append("<p>");
            return this;
        }

        public Builder br() {
            this.builder.append("<br>");
            return this;
        }

        public Builder newLine() {
            this.builder.append("\n");
            return this;
        }

        public Builder appendUnformattedJavaDoc(String text) {
            String formattedJavaDoc = new JavaDocTextFormatter().format(text);
            if (formattedJavaDoc != null && formattedJavaDoc.length() > 0) {
                this.append(formattedJavaDoc);
            }
            return this;
        }

        public JavaDoc build() {
            return new JavaDoc(this.builder.toString());
        }

        public static JavaDoc extractJavaDoc(String buffer) {
            if (buffer == null) {
                return null;
            }
            List<String> docs = BufferUtils.extractJavaDoc(buffer);
            Builder builder = new Builder();
            for (String doc : docs) {
                if (builder.builder.length() > 0 && builder.builder.lastIndexOf("\n") != builder.builder.length() - 1) {
                    builder.newLine();
                }
                builder.appendUnformattedJavaDoc(doc);
            }
            return builder.build();
        }
    }
}

