/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.Trace;
import com.streamscape.lib.loader.FabricClassLoaderInMemory;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.EnumDataField;
import com.streamscape.runtime.mf.operation.edl.ListDataField;
import com.streamscape.runtime.mf.operation.edl.MapDataField;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.generator.AbstractSdoGenerator;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.sdo.excp.ValidationError;
import com.streamscape.sdo.excp.ValidationException;
import com.streamscape.sdo.validation.FieldValidationException;
import com.streamscape.sdo.validation.ValidationUtils;
import com.streamscape.sdo.validation.Validator;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.evtrigger.function.types.SemanticTypeType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SdoValidatorGenerator
extends AbstractSdoGenerator {
    protected String validatedClassFullName;
    protected SdoMethod validationMethod;
    protected boolean isChoice = false;
    protected List<String> fieldNames = new ArrayList<String>();

    private SdoValidatorGenerator(SdoCompiler compiler, String packageName, String className, String validatedClassFullName) {
        super(compiler, packageName, className);
        this.validatedClassFullName = validatedClassFullName;
        this.getSdoClass().setInterfaces(new String[]{Validator.class.getName()});
        this.addField(new SdoField(ValidationException.class.getName(), "validationException", "null"));
        this.validationMethod = new SdoMethod("void", "validateInternal");
        this.validationMethod.setSynchronized(true);
        this.validationMethod.addArgument(validatedClassFullName, "object");
        this.validationMethod.addThrowsException(ValidationException.class.getName());
        this.validationMethod.appendToBody("if (object == null) return;\n");
        this.validationMethod.appendToBody("validationException = null;\n");
        this.addMethod(this.validationMethod);
    }

    public static SdoValidatorGenerator create(SdoCompiler compiler, String packageName, String className) {
        if (packageName == null) {
            packageName = "";
        }
        Object validatedClassFullName = className;
        if (packageName.length() > 0) {
            validatedClassFullName = packageName + "." + className;
        }
        packageName = SdoUtils.getValidatorPackageName(packageName);
        return new SdoValidatorGenerator(compiler, packageName, className, (String)validatedClassFullName);
    }

    public static SdoValidatorGenerator create(SdoCompiler compiler, String fullClassName) {
        String packageName = "";
        int pos = fullClassName.lastIndexOf(46);
        if (pos != -1) {
            packageName = fullClassName.substring(0, pos);
            fullClassName = fullClassName.substring(pos + 1);
        }
        return SdoValidatorGenerator.create(compiler, packageName, fullClassName);
    }

    public void addField(DataField field) throws EDLException {
        this.fieldNames.add(field.getName());
        if (field.isNotNull()) {
            this.addValidationMethod("validateNotNull(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "());");
        }
        if (field instanceof MapDataField) {
            this.addMapField((MapDataField)field);
        } else if (field instanceof EnumDataField) {
            this.addEnumField((EnumDataField)field);
        } else {
            this.addSimpleField(field);
        }
    }

    public void addSimpleField(DataField field) throws EDLException {
        Type<?> fieldType = field.getType();
        if (fieldType instanceof SemanticTypeType) {
            this.addValidationMethod("validate(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + fieldType.getJavaClassName() + ".class);");
        }
        if (field.getDomainName() != null) {
            this.addValidationMethod("validateInNamedDomain(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), \"" + field.getDomainName() + "\");");
        }
        if (field.getRangeName() != null) {
            this.addValidationMethod("validateInNamedRange(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), \"" + field.getRangeName() + "\");");
        }
        if (field.getDomainValues() != null && field.getDomainValues().size() > 0) {
            String domainValuesName = field.getName() + "DomainValues";
            this.addField(new SdoField("java.util.List", domainValuesName, "new java.util.ArrayList()"));
            for (String string : field.getDomainValues()) {
                String initializer = fieldType.getDefaultObjectInitializer(string);
                if (initializer == null) continue;
                this.getSdoConstructor().appendToBody(domainValuesName + ".add(" + initializer + ");\n");
            }
            this.addValidationMethod("validateInDomain(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + domainValuesName + ");");
        }
        if (field.getRangeValues() != null && field.getRangeValues().size() > 0) {
            String rangeValuesName = field.getName() + "RangeValues";
            this.addField(new SdoField("java.util.List", rangeValuesName, "new java.util.ArrayList()"));
            for (Map.Entry entry : field.getRangeValues()) {
                String initializer1 = fieldType.getDefaultObjectInitializer((String)entry.getKey());
                String initializer2 = fieldType.getDefaultObjectInitializer((String)entry.getValue());
                if (initializer1 == null || initializer2 == null) continue;
                this.getSdoConstructor().appendToBody(rangeValuesName + ".add(new java.util.AbstractMap.SimpleEntry(" + initializer1 + "," + initializer2 + "));\n");
            }
            this.addValidationMethod("validateInRange(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + rangeValuesName + ");");
        }
        if (field.getRegexp() != null) {
            String regexpName = field.getName() + "Regexp";
            this.addField(new SdoField("java.util.regex.Pattern", regexpName));
            this.getSdoConstructor().appendToBody(regexpName + " = java.util.regex.Pattern.compile(\"" + field.getRegexp() + "\");\n");
            this.addValidationMethod("validateRegexp(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + regexpName + ");");
        }
        if (field.getLength() != null) {
            try {
                this.addValidationMethod("validateLength(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + field.getLength() + ");");
            }
            catch (NumberFormatException exception) {
                Trace.logException(this, exception, false);
            }
        }
        this.addPrecisionValidation(field, null);
        if (field instanceof ListDataField) {
            this.addPrecisionValidation(((ListDataField)field).getElementDataField(), field.getName());
        }
        if (field.getEnumName() != null) {
            SemanticType semanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(field.getEnumName());
            if (semanticType == null) {
                throw new EDLException("Semantic type '" + field.getEnumName() + "' not found.");
            }
            this.addValidationMethod("validateEnum(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), " + semanticType.getClassName() + ".class);");
        }
    }

    private void addPrecisionValidation(DataField field, String name) {
        if (field.getPrecision() != null) {
            try {
                Integer scale = field.getScale() != null ? field.getScale() : 0;
                if (name == null) {
                    name = field.getName();
                }
                this.addValidationMethod("validatePrecisionAndScale(\"" + name + "\", object." + SdoValidatorGenerator.getGetterForField(name) + "(), " + field.getPrecision() + ", " + scale + ");");
            }
            catch (NumberFormatException exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    public void addEnumField(EnumDataField field) throws EDLException {
        EnumType fieldType = (EnumType)field.getType();
        if (!fieldType.isUserDefinedEnum()) {
            return;
        }
        this.addValidationMethod("validateEnum(\"" + field.getName() + "\", " + this.getObjectGetterForField(field) + ", " + fieldType.getSemanticTypeClassName() + ".class);");
    }

    public void addMapField(MapDataField field) throws EDLException {
        Type<?> valueFieldType = field.getValueType();
        if (valueFieldType instanceof SemanticTypeType) {
            this.addValidationMethod("validate(\"" + field.getName() + "\", object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "(), null, " + valueFieldType.getJavaClassName() + ".class);");
        }
    }

    protected String getObjectGetterForField(DataField field) {
        return "object." + SdoValidatorGenerator.getGetterForField(field.getName()) + "()";
    }

    public void finish() {
        this.addChoiceValidation();
        this.validationMethod.appendToBody("if (validationException != null) throw validationException;");
        SdoMethod method = new SdoMethod("void", "validate");
        method.setSynchronized(true);
        method.addArgument("Object", "object");
        method.addThrowsException(ValidationException.class.getName());
        method.appendToBody("   if (object == null) return;\n   if (!(object instanceof " + this.validatedClassFullName + "))\n       throw new com.streamscape.sdo.excp.ValidationException(com.streamscape.sdo.ErrorCodes.SDO_VALIDATION_FAILED, \n         \"Wrong class passed for validation, expecting '" + this.validatedClassFullName + "', instead of '\" + object.getClass().getName() + \"'\");\n   validateInternal((" + this.validatedClassFullName + ")object);\n");
        this.addMethod(method);
    }

    public void addChoiceValidation() {
        if (!this.isChoice()) {
            return;
        }
        this.addField(new SdoField(String.class.getName(), "notNullFieldName", "null"));
        for (String fieldName : this.fieldNames) {
            this.validationMethod.appendToBody("if (object." + SdoValidatorGenerator.getGetterForField(fieldName) + "() != null ){\n   if (notNullFieldName == null)\n     notNullFieldName = \"" + fieldName + "\";\n   else\n");
            this.addValidationCode("throw new " + FieldValidationException.class.getName() + "(\"" + fieldName + "\", \"This field cannot be not null because there is already exists not null field '\"+ notNullFieldName + \"'. Choice doesn't allow more then one not null fields.\");");
            this.validationMethod.appendToBody("}\n");
        }
    }

    protected void addValidationMethod(String src) {
        this.addValidationCode(ValidationUtils.class.getName() + "." + src);
    }

    protected void addValidationCode(String src) {
        this.validationMethod.appendToBody("try {" + src + " }catch(Exception e){validationException=" + ValidationUtils.class.getName() + ".mergeExceptions(validationException, e, \"" + this.validatedClassFullName + "\");}\n");
    }

    public void validate(Map<String, byte[]> validatedClasses, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws EDLException {
        block12: {
            feedbackInvoker.addFeedback("Validating SDO...");
            FabricClassLoaderInMemory fabricClassLoader = new FabricClassLoaderInMemory(this.sdoCompiler.getClassLoader());
            try {
                fabricClassLoader.addClasses(validatedClasses);
                fabricClassLoader.addClasses(this.getByteCodeWithClassNames());
                Class validatorClass = ClassUtils.loadClass(this.getSdoClass().getFullClassName(), fabricClassLoader);
                Class validatatedClass = ClassUtils.loadClass(this.validatedClassFullName, fabricClassLoader);
                Object validator = validatorClass.newInstance();
                Object validatated = validatatedClass.newInstance();
                Method validateMethod = validatorClass.getDeclaredMethod("validate", Object.class);
                validateMethod.invoke(validator, validatated);
            }
            catch (InvocationTargetException exception) {
                if (exception.getTargetException() != null) {
                    if (exception.getTargetException() instanceof ValidationException) {
                        ValidationException validationException = (ValidationException)exception.getTargetException();
                        String message = validationException.getMessage() + "\n";
                        for (ValidationError error : validationException.getErrors()) {
                            message = message + error.name + " : " + error.value + "\n";
                        }
                        if (feedbackInvoker != null) {
                            feedbackInvoker.addFeedback(message);
                            break block12;
                        }
                        throw new EDLException(message);
                    }
                    throw new EDLException(exception.getTargetException().getMessage());
                }
                throw new EDLException(exception.getMessage());
            }
            catch (EDLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new EDLException("Compilation failed, internal error: " + exception.toString());
            }
            finally {
                fabricClassLoader.removeClasses(validatedClasses.keySet());
                fabricClassLoader.removeClasses(this.getByteCodeWithClassNames().keySet());
            }
        }
        feedbackInvoker.addOK();
    }

    public boolean isChoice() {
        return this.isChoice;
    }

    public void setIsChoice(boolean isChoice) {
        this.isChoice = isChoice;
    }
}

