/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.runtime.mf.operation.edl.generator.SdoClass;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCommon;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SdoMethod
extends SdoCommon {
    private String returnType;
    private String name;
    private List<Map.Entry<String, String>> arguments;
    private List<String> throwsExceptions;
    private StringBuilder body = new StringBuilder();

    public SdoMethod(String returnType, String name) {
        this(returnType, name, null);
    }

    public SdoMethod(String returnType, String name, List<Map.Entry<String, String>> arguments) {
        this.returnType = returnType;
        this.name = name;
        this.arguments = arguments;
        this.setModifier("public");
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return "{" + this.body.toString() + "}";
    }

    public void addArgument(String type, String name) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Map.Entry<String, String>>();
        }
        this.arguments.add(new AbstractMap.SimpleEntry<String, String>(type, name));
    }

    public List<Map.Entry<String, String>> getArguments() {
        return this.arguments;
    }

    public void appendToBody(String src) {
        this.body.append(src);
    }

    public List<String> getThrowsExceptions() {
        return this.throwsExceptions;
    }

    public void addThrowsException(String exception) {
        if (this.throwsExceptions == null) {
            this.throwsExceptions = new ArrayList<String>();
        }
        this.throwsExceptions.add(exception);
    }

    @Override
    public String getPureCode() {
        return this.getCode(true);
    }

    @Override
    protected String getCode(boolean pure) {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getCode(pure));
        if (this.returnType != null && this.returnType.length() > 0) {
            builder.append(this.returnType).append(" ");
        }
        builder.append(this.name).append("(");
        if (this.arguments != null && this.arguments.size() > 0) {
            for (Map.Entry<String, String> entry : this.arguments) {
                builder.append(entry.getKey()).append(" ").append(entry.getValue()).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        if (this.throwsExceptions != null && this.throwsExceptions.size() > 0) {
            builder.append(" throws ");
            for (String exception : this.throwsExceptions) {
                builder.append(exception).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        if (this.isAbstract()) {
            builder.append(";");
            return builder.toString();
        }
        builder.append("\n{\n");
        SdoClass.allign(builder, "   ", this.body.toString());
        if (builder.charAt(builder.length() - 1) != '\n') {
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getCode(false);
    }
}

