/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.streamscape.Trace;
import com.streamscape.omf.xml.xstream.annotations.XStreamAlias;
import com.streamscape.omf.xml.xstream.annotations.XStreamImplicit;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.EnumDataField;
import com.streamscape.runtime.mf.operation.edl.ListDataField;
import com.streamscape.runtime.mf.operation.edl.MapDataField;
import com.streamscape.runtime.mf.operation.edl.SimpleDataField;
import com.streamscape.runtime.mf.operation.edl.StaticStringDataField;
import com.streamscape.runtime.mf.operation.edl.annotations.Alias;
import com.streamscape.runtime.mf.operation.edl.annotations.Choice;
import com.streamscape.runtime.mf.operation.edl.annotations.Default;
import com.streamscape.runtime.mf.operation.edl.annotations.Description;
import com.streamscape.runtime.mf.operation.edl.annotations.Domain;
import com.streamscape.runtime.mf.operation.edl.annotations.Enum;
import com.streamscape.runtime.mf.operation.edl.annotations.Implicit;
import com.streamscape.runtime.mf.operation.edl.annotations.ImplicitMap;
import com.streamscape.runtime.mf.operation.edl.annotations.Key;
import com.streamscape.runtime.mf.operation.edl.annotations.Length;
import com.streamscape.runtime.mf.operation.edl.annotations.NotNull;
import com.streamscape.runtime.mf.operation.edl.annotations.Offset;
import com.streamscape.runtime.mf.operation.edl.annotations.Precision;
import com.streamscape.runtime.mf.operation.edl.annotations.Range;
import com.streamscape.runtime.mf.operation.edl.annotations.Regexp;
import com.streamscape.runtime.mf.operation.edl.annotations.Scale;
import com.streamscape.runtime.mf.operation.edl.annotations.SuppressGenericType;
import com.streamscape.runtime.mf.operation.edl.annotations.Value;
import com.streamscape.runtime.mf.operation.edl.annotations.XmlAttribute;
import com.streamscape.runtime.mf.operation.edl.generator.AbstractSdoGenerator;
import com.streamscape.runtime.mf.operation.edl.generator.SdoAnnotation;
import com.streamscape.runtime.mf.operation.edl.generator.SdoClass;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoConstructor;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.runtime.mf.operation.edl.generator.SdoNestedClass;
import com.streamscape.runtime.mf.operation.edl.javadoc.SdoJavaDocGenerator;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.evtrigger.function.types.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SdoGenerator
extends AbstractSdoGenerator {
    private SdoMethod cloneMethod;

    private SdoGenerator(SdoCompiler compiler, String packageName, String className, String comment) {
        super(compiler, packageName, className);
        this.getSdoClass().setJavaDoc(SdoJavaDocGenerator.createJavaDocForClass(comment));
        this.addObserver(new JavaDocGeneratorObserver());
    }

    public static SdoGenerator create(SdoCompiler compiler, String packageName, String className, String comment) {
        return new SdoGenerator(compiler, packageName, className, comment);
    }

    public static SdoGenerator create(SdoCompiler compiler, String className, String comment) {
        String packageName = "";
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            packageName = className.substring(0, pos);
            className = className.substring(pos + 1);
        }
        return new SdoGenerator(compiler, packageName, className, comment);
    }

    public void addEnumAnnotation() {
        this.getSdoClass().addAnnotation(new SdoAnnotation(Enum.class.getName()));
    }

    public void setAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            SdoAnnotation annotation = new SdoAnnotation(Alias.class.getName());
            annotation.addValue("alias", alias);
            this.getSdoClass().addAnnotation(annotation);
        }
    }

    public void addChoiceAnnotation() {
        this.getSdoClass().addAnnotation(new SdoAnnotation(Choice.class.getName()));
    }

    public void addField(DataField field) throws EDLException {
        SdoField sdoField;
        if (field instanceof SimpleDataField) {
            sdoField = this.addSimpleField((SimpleDataField)field);
        } else if (field instanceof ListDataField) {
            sdoField = ((ListDataField)field).isArray() ? this.addArrayField((ListDataField)field) : this.addListField((ListDataField)field);
        } else if (field instanceof MapDataField) {
            sdoField = this.addMapField((MapDataField)field);
        } else if (field instanceof StaticStringDataField) {
            sdoField = this.addStaticStringField((StaticStringDataField)field);
        } else if (field instanceof EnumDataField) {
            sdoField = this.addEnumField((EnumDataField)field);
        } else {
            throw new EDLException("Unsupported data field: " + String.valueOf(DataField.class));
        }
        this.addCommonAnnotations(sdoField, field);
    }

    private SdoField addSimpleField(SimpleDataField field) throws EDLException {
        Type<?> fieldType = field.getType();
        this.addSemanticTypeToCompiler(fieldType);
        SdoField sdoField = new SdoField(fieldType.getJavaClassName(), field.getName(), fieldType.getDefaultInitializer(field.getDefaultValue()));
        if (field.getDefaultValue() != null) {
            this.addDefaultValueAnnotationForField(sdoField, field.getDefaultValue());
        }
        if (field.isXmlAttribute()) {
            this.addXmlAttributeAnnotationForField(sdoField);
        }
        this.addField(sdoField, field);
        String initializer = fieldType.getConstructorInitializer(field.getName(), field.getDefaultValue());
        if (initializer != null) {
            this.getSdoConstructor().appendToBody("{" + initializer + "}\n");
        }
        this.generateSetMethod(fieldType.getJavaClassName(), field.getName());
        this.generateGetMethod(fieldType.getJavaClassName(), field.getName());
        this.getCloneMethod().appendToBody(this.createCloneTemplateIfNotNull(field.getName(), "   result." + field.getName() + " = " + this.createSimpleFieldClone(fieldType, "this." + field.getName()) + ";"));
        return sdoField;
    }

    private String getLevelString(int level) {
        return level == 0 ? "" : String.valueOf(level);
    }

    private void addMapFieldAnnotations(SdoField sdoField, MapDataField field, int level) throws EDLException {
        this.addSemanticTypeToCompiler(field.getType());
        this.addSemanticTypeToCompiler(field.getValueType());
        this.addFieldSemanticTypeAnnotation(sdoField, field.getType().getJavaClassName(), null, field.getValueType().getJavaClassName(), level);
        if (level == 0) {
            if (field.isImplicit()) {
                sdoField.addAnnotation(new SdoAnnotation(Implicit.class.getName() + this.getLevelString(level)));
            }
            if (field.isSuppressGenericType()) {
                sdoField.addAnnotation(new SdoAnnotation(SuppressGenericType.class.getName() + this.getLevelString(level)));
            }
        }
    }

    private void addListFieldAnnotations(SdoField sdoField, ListDataField field, int level) throws EDLException {
        this.addSemanticTypeToCompiler(field.getType());
        this.addFieldSemanticTypeAnnotation(sdoField, field.getType().getJavaClassName(), field.getEntryTypeName(), null, level);
        if (level == 0) {
            if (field.isImplicit()) {
                sdoField.addAnnotation(new SdoAnnotation(Implicit.class.getName() + this.getLevelString(level)));
            }
            if (field.isSuppressGenericType()) {
                sdoField.addAnnotation(new SdoAnnotation(SuppressGenericType.class.getName() + this.getLevelString(level)));
            }
        }
    }

    private void addMapOrListFieldAnnotations(SdoField sdoField, DataField field) throws EDLException {
        int level = 0;
        while (true) {
            if (field instanceof MapDataField) {
                this.addMapFieldAnnotations(sdoField, (MapDataField)field, level);
                field = ((MapDataField)field).getValueField();
            } else {
                if (!(field instanceof ListDataField)) break;
                this.addListFieldAnnotations(sdoField, (ListDataField)field, level);
                field = ((ListDataField)field).getElementDataField();
            }
            ++level;
        }
    }

    private SdoField addListField(ListDataField field) throws EDLException {
        SdoField sdoField = new SdoField("java.util.List", field.getName(), "new java.util.ArrayList()");
        this.addMapOrListFieldAnnotations(sdoField, field);
        this.addPrecisionAndScaleAnnotations(sdoField, field.getElementDataField());
        this.addField(sdoField, field);
        Type<?> fieldType = field.getType();
        if (field.getDefaultValues() != null && field.getDefaultValues().size() > 0) {
            this.addDefaultValuesAnnotationForField(sdoField, field.getDefaultValues());
            for (String defaultValue : field.getDefaultValues()) {
                Object initializer = fieldType.getDefaultObjectInitializer(defaultValue);
                if (initializer != null) {
                    initializer = "this." + field.getName() + ".add(" + (String)initializer + ");\n";
                } else {
                    String valueName = field.getName() + "OneValue";
                    initializer = fieldType.getConstructorInitializer(valueName, defaultValue);
                    if (initializer != null) {
                        initializer = fieldType.getJavaClassName() + " " + (String)initializer;
                        initializer = "{" + (String)initializer + ";this." + field.getName() + ".add(" + valueName + ");}\n";
                    }
                }
                this.getSdoConstructor().appendToBody((String)initializer);
            }
        }
        this.generateSetMethod("java.util.List", field.getName());
        this.generateGetMethod("java.util.List", field.getName());
        this.generateAddToMethod(fieldType.getJavaClassName(), field.getName());
        this.generateAddToAtMethod(fieldType.getJavaClassName(), field.getName());
        this.generateRemoveFromMethod(fieldType.getJavaClassName(), field.getName());
        this.generateRemoveFromAtMethod(fieldType.getJavaClassName(), field.getName());
        this.generateGetAtMethod(fieldType.getJavaClassName(), field.getName());
        this.generateIsEmptyMethod(field.getName());
        this.generateIterateMethod(fieldType.getJavaClassName(), field.getName());
        String resultFieldName = "result." + field.getName();
        String thisFieldName = "this." + field.getName();
        String clone = null;
        if (this.isNeedToClone(field.getType())) {
            clone = "   " + resultFieldName + " = new java.util.ArrayList(" + thisFieldName + ".size());\n";
            clone = clone + "   for(int i = 0; i < " + thisFieldName + ".size(); i++){\n      Object value = null;\n      if (" + thisFieldName + ".get(i) != null)\n         value = " + this.createSimpleFieldClone(field.getType(), thisFieldName + ".get(i)") + ";\n      " + resultFieldName + ".add(value);\n   }\n";
        } else {
            clone = "   " + resultFieldName + " = (java.util.ArrayList)((java.util.ArrayList)" + thisFieldName + ").clone();\n";
        }
        this.getCloneMethod().appendToBody(this.createCloneTemplateIfNotNull(field.getName(), clone));
        return sdoField;
    }

    private SdoField addArrayField(ListDataField field) throws EDLException {
        if (field.getLength() == null) {
            throw new EDLException("Length should be specified for ARRAY field '" + field.getName() + "'.");
        }
        if (field.getDefaultValues() != null && field.getDefaultValues().size() > field.getLength()) {
            throw new EDLException("Default values count specified for ARRAY field '" + field.getName() + "' greater than ARRAY length '" + field.getLength() + "'.");
        }
        Type<?> fieldType = field.getType();
        this.addSemanticTypeToCompiler(fieldType);
        String arrayType = fieldType.getJavaClassName() + "[]";
        String initValue = "new " + fieldType.getJavaClassName();
        initValue = initValue.endsWith("[]") ? initValue.substring(0, initValue.length() - 2) + "[" + field.getLength() + "][]" : initValue + "[" + field.getLength() + "]";
        SdoField sdoField = new SdoField(arrayType, field.getName(), initValue);
        this.addField(sdoField, field);
        if (field.getDefaultValues() != null && field.getDefaultValues().size() > 0) {
            this.addDefaultValuesAnnotationForField(sdoField, field.getDefaultValues());
            int i = 0;
            for (String defaultValue : field.getDefaultValues()) {
                Object initializer = fieldType.getDefaultObjectInitializer(defaultValue);
                if (initializer != null) {
                    initializer = "this." + field.getName() + "[" + i++ + "] = " + (String)initializer + ";\n";
                } else {
                    String valueName = field.getName() + "OneValue";
                    initializer = fieldType.getConstructorInitializer(valueName, defaultValue);
                    if (initializer != null) {
                        initializer = fieldType.getJavaClassName() + " " + (String)initializer;
                        initializer = "{" + (String)initializer + ";this." + field.getName() + "[" + i++ + "] = " + valueName + ";}\n";
                    }
                }
                this.getSdoConstructor().appendToBody((String)initializer);
            }
        }
        this.generateSetMethod(arrayType, field.getName());
        this.generateGetMethod(arrayType, field.getName());
        this.generateSetAtMethodForArray(fieldType.getJavaClassName(), field.getName());
        this.generateGetAtMethodForArray(fieldType.getJavaClassName(), field.getName());
        String resultFieldName = "result." + field.getName();
        String thisFieldName = "this." + field.getName();
        String clone = null;
        if (this.isNeedToClone(field.getType())) {
            clone = "   " + resultFieldName + " = new " + fieldType.getJavaClassName() + "[" + thisFieldName + ".length];\n";
            clone = clone + "   for(int i = 0; i < " + thisFieldName + ".length; i++)\n      if (" + thisFieldName + "[i] != null)         " + resultFieldName + "[i] = " + this.createSimpleFieldClone(field.getType(), thisFieldName + "[i]") + ";\n";
        } else {
            clone = "   " + resultFieldName + " = (" + fieldType.getJavaClassName() + "[])" + thisFieldName + ".clone();\n";
        }
        this.getCloneMethod().appendToBody(this.createCloneTemplateIfNotNull(field.getName(), clone));
        return sdoField;
    }

    protected String makeArrayMaxLengthFieldName(ListDataField field) {
        return field.getName().toUpperCase() + "_MAX_LENGTH";
    }

    private SdoField addMapField(MapDataField field) throws EDLException {
        Type<?> keyFieldType = field.getType();
        Type<?> valueFieldType = field.getValueType();
        this.addSemanticTypeToCompiler(keyFieldType);
        this.addSemanticTypeToCompiler(valueFieldType);
        if (field.getEntryTypeName() == null) {
            SdoField sdoField = new SdoField("java.util.Map", field.getName(), "new java.util.HashMap()");
            this.addMapOrListFieldAnnotations(sdoField, field);
            this.addField(sdoField, field);
            this.generateSetMethod("java.util.Map", field.getName());
            this.generateGetMethod("java.util.Map", field.getName());
            this.generatePutToMethod(keyFieldType.getJavaClassName(), valueFieldType.getJavaClassName(), field.getName());
            this.generateGetFromMethod(keyFieldType.getJavaClassName(), valueFieldType.getJavaClassName(), field.getName());
            this.generateRemoveFromMethod(keyFieldType.getJavaClassName(), valueFieldType.getJavaClassName(), field.getName());
            this.generateIsEmptyMethod(field.getName());
            String resultFieldName = "result." + field.getName();
            String thisFieldName = "this." + field.getName();
            String clone = null;
            if (this.isNeedToClone(keyFieldType)) {
                clone = "   " + resultFieldName + " = new java.util.HashMap();\n";
                clone = clone + "   java.util.Iterator iterator = " + thisFieldName + ".entrySet().iterator();\n";
                clone = clone + "   while(iterator.hasNext())\n";
                clone = clone + "   {\n";
                clone = clone + "      java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();\n";
                clone = clone + "      " + keyFieldType.getJavaClassName() + " newKey = entry.getKey();\n";
                clone = clone + "      if (newKey != null)";
                clone = clone + "         newKey = " + this.createSimpleFieldClone(keyFieldType, "newKey") + ";\n";
                clone = clone + "      " + valueFieldType.getJavaClassName() + " newValue = entry.getValue();\n";
                if (this.isNeedToClone(valueFieldType)) {
                    clone = clone + "      if (newValue != null)";
                    clone = clone + "         newValue = " + this.createSimpleFieldClone(valueFieldType, "newValue") + ";\n";
                }
                clone = clone + "      " + resultFieldName + ".put(newKey, newValue);\n";
                clone = clone + "   }\n";
            } else {
                clone = "   " + resultFieldName + " = (java.util.HashMap)((java.util.HashMap)" + thisFieldName + ").clone();\n";
            }
            if (!this.isNeedToClone(keyFieldType) && this.isNeedToClone(valueFieldType)) {
                clone = clone + "   java.util.Iterator iterator = " + resultFieldName + ".entrySet().iterator();\n";
                clone = clone + "   while(iterator.hasNext())\n";
                clone = clone + "   {\n";
                clone = clone + "      java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();\n";
                clone = clone + "      " + valueFieldType.getJavaClassName() + " newValue = entry.getValue();\n";
                clone = clone + "      if (newValue != null)";
                clone = clone + "         newValue = " + this.createSimpleFieldClone(valueFieldType, "newValue") + ";\n";
                clone = clone + "      entry.setValue(newValue);\n";
                clone = clone + "   }\n";
            }
            this.getCloneMethod().appendToBody(this.createCloneTemplateIfNotNull(field.getName(), clone));
            return sdoField;
        }
        SdoNestedClass nestedClass = new SdoNestedClass(field.getEntryTypeName(), this.getSdoClass());
        nestedClass.setSuperclass(CloneableDataObject.class.getName());
        SemanticType semanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(field.getEntryTypeName());
        if (semanticType != null && !semanticType.getClassName().equals(nestedClass.getFullClassName())) {
            throw new EDLException("Failed to create MAP field '" + field.getName() + "'. Cause: semantic type with name '" + semanticType.getTypeName() + "' already exists and refers to another class '" + semanticType.getClassName() + "'. Please drop this semantic type or use another name.");
        }
        SdoField keyField = new SdoField(keyFieldType.getJavaClassName(), field.getKeyName());
        keyField.setModifier("public");
        keyField.addAnnotation(new SdoAnnotation(Key.class.getName()));
        nestedClass.addField(keyField);
        SdoField valueField = new SdoField(valueFieldType.getJavaClassName(), field.getValueName());
        valueField.setModifier("public");
        valueField.addAnnotation(new SdoAnnotation(Value.class.getName()));
        this.addMapOrListFieldAnnotations(valueField, field.getValueField());
        nestedClass.addField(valueField);
        SdoMethod nestedCloneMethod = new SdoMethod("Object", "clone");
        nestedCloneMethod = new SdoMethod("Object", "clone");
        nestedCloneMethod.appendToBody(nestedClass.getFullClassName() + " result = new " + nestedClass.getFullClassName() + "();\n");
        nestedCloneMethod.appendToBody(this.createCloneTemplateIfNotNull(field.getKeyName(), "result." + field.getKeyName() + " = " + this.createSimpleFieldClone(keyFieldType, "this." + field.getKeyName()) + ";"));
        nestedCloneMethod.appendToBody(this.createCloneTemplateIfNotNull(field.getValueName(), "result." + field.getValueName() + " = " + this.createSimpleFieldClone(valueFieldType, "this." + field.getValueName()) + ";"));
        nestedCloneMethod.appendToBody("return result;\n");
        nestedClass.addMethod(nestedCloneMethod);
        nestedClass.addConstructor(new SdoConstructor(nestedClass));
        this.addNestedClass(nestedClass);
        SdoField sdoField = new SdoField("java.util.List", field.getName(), "new java.util.ArrayList()");
        this.addFieldSemanticTypeAnnotation(sdoField, nestedClass.getFullClassName(), null, null);
        sdoField.addAnnotation(new SdoAnnotation(ImplicitMap.class.getName()));
        this.addField(sdoField, field);
        this.generateSetMethodForTypeMap(field, nestedClass.getFullClassName());
        this.generateGetMethodForTypeMap(field, nestedClass.getFullClassName());
        this.generatePutToMethodForTypeMap(field, nestedClass.getFullClassName());
        this.generateGetFromMethodForTypeMap(field, nestedClass.getFullClassName());
        this.generateRemoveFromMethodForTypeMap(field, nestedClass.getFullClassName());
        this.generateIsEmptyMethod(field.getName());
        String resultFieldName = "result." + field.getName();
        String thisFieldName = "this." + field.getName();
        String clone = "   " + resultFieldName + " = new java.util.ArrayList(" + thisFieldName + ".size());\n   for(int i = 0; i < " + thisFieldName + ".size(); i++)\n      " + resultFieldName + ".add(((" + nestedClass.getFullClassName() + ")" + thisFieldName + ".get(i)).clone());\n";
        this.getCloneMethod().appendToBody(this.createCloneTemplateIfNotNull(field.getName(), clone));
        return sdoField;
    }

    private SdoField addStaticStringField(StaticStringDataField field) throws EDLException {
        Type<?> fieldType = field.getType();
        SdoField sdoField = new SdoField(fieldType.getJavaClassName(), field.getName(), fieldType.getDefaultInitializer(field.getName()));
        sdoField.setStatic(true);
        sdoField.setModifier("public");
        this.addField(sdoField, field);
        return sdoField;
    }

    private SdoField addEnumField(EnumDataField field) throws EDLException {
        EnumType fieldType = (EnumType)field.getType();
        this.addSemanticTypeToCompiler(fieldType);
        SdoField sdoField = new SdoField(fieldType.getJavaClassName(), field.getName(), fieldType.getDefaultInitializer(field.getDefaultValue()));
        if (field.getDefaultValue() != null) {
            String defaultValue = field.getDefaultValue();
            if (defaultValue.lastIndexOf(".") != -1) {
                defaultValue = defaultValue.substring(defaultValue.lastIndexOf(".") + 1);
            }
            this.addDefaultValueAnnotationForField(sdoField, defaultValue);
        }
        this.addField(sdoField, field);
        if (!fieldType.isUserDefinedEnum()) {
            this.generateSetMethod(fieldType.getJavaClassName(), field.getName());
        } else {
            this.generateUserDefinedEnumSetMethod(fieldType, field.getName());
        }
        this.generateGetMethod(fieldType.getJavaClassName(), field.getName());
        this.getCloneMethod().appendToBody("   result." + field.getName() + " = this." + field.getName() + ";");
        return sdoField;
    }

    protected void addDefaultValueAnnotationForField(SdoField sdoField, String defaultValue) {
        SdoAnnotation annotation = new SdoAnnotation(Default.class.getName());
        annotation.addValue("value", defaultValue);
        sdoField.addAnnotation(annotation);
    }

    protected void addXmlAttributeAnnotationForField(SdoField sdoField) {
        SdoAnnotation annotation = new SdoAnnotation(XmlAttribute.class.getName());
        sdoField.addAnnotation(annotation);
    }

    protected void addDefaultValuesAnnotationForField(SdoField sdoField, List<String> defaultValues) {
        SdoAnnotation annotation = new SdoAnnotation(Default.class.getName());
        annotation.addValue("values", defaultValues);
        sdoField.addAnnotation(annotation);
    }

    protected void generateUserDefinedEnumSetMethod(EnumType fieldType, String name) {
        SdoMethod method = new SdoMethod("void", "set" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(fieldType.getJavaClassName(), name);
        method.appendToBody("this." + name + " = " + name + ";");
        this.addMethod(method);
    }

    protected void addCommonAnnotations(SdoField sdoField, DataField field) {
        String entryTypeName;
        SdoAnnotation annotation;
        if (field.getBeginOffset() != null && field.getEndOffset() != null) {
            annotation = new SdoAnnotation(Offset.class.getName());
            annotation.addValue("begin", field.getBeginOffset());
            annotation.addValue("end", field.getEndOffset());
            sdoField.addAnnotation(annotation);
        }
        if (field.getDescription() != null) {
            annotation = new SdoAnnotation(Description.class.getName());
            annotation.addValue("value", field.getDescription());
            sdoField.addAnnotation(annotation);
        }
        if (field.getAlias() != null) {
            annotation = new SdoAnnotation(JsonProperty.class.getName());
            annotation.addValue("value", field.getAlias());
            sdoField.addAnnotation(annotation);
            annotation = new SdoAnnotation(XStreamAlias.class.getName());
            annotation.addValue("value", field.getAlias());
            sdoField.addAnnotation(annotation);
        }
        if (field.isStrictCase()) {
            PropertyNamingStrategy.KebabCaseStrategy kc = (PropertyNamingStrategy.KebabCaseStrategy)PropertyNamingStrategy.KEBAB_CASE;
            String kebabName = kc.translate(field.getName());
            kebabName = kebabName.replaceAll("(\\d+)", "-$1");
            SdoAnnotation annotation2 = new SdoAnnotation(JsonAlias.class.getName());
            annotation2.addValue("value", Collections.singletonList(kebabName));
            sdoField.addAnnotation(annotation2);
            if (!sdoField.containsAnnotation(XStreamAlias.class.getName())) {
                annotation2 = new SdoAnnotation(XStreamAlias.class.getName());
                annotation2.addValue("value", kebabName);
                sdoField.addAnnotation(annotation2);
            }
        }
        if (field instanceof ListDataField && ((ListDataField)field).isImplicit() && (entryTypeName = ((ListDataField)field).getEntryTypeName()) != null) {
            SdoAnnotation annotation3 = new SdoAnnotation(XStreamImplicit.class.getName());
            annotation3.addValue("itemFieldName", entryTypeName);
            sdoField.addAnnotation(annotation3);
        }
        if (field.isNotNull()) {
            annotation = new SdoAnnotation(NotNull.class.getName());
            sdoField.addAnnotation(annotation);
        }
        if (field.getDomainName() != null || field.getDomainValues() != null && field.getDomainValues().size() > 0) {
            annotation = new SdoAnnotation(Domain.class.getName());
            if (field.getDomainName() != null) {
                annotation.addValue("name", field.getDomainName());
            }
            if (field.getDomainValues() != null && field.getDomainValues().size() > 0) {
                annotation.addValue("values", field.getDomainValues());
            }
            sdoField.addAnnotation(annotation);
        }
        if (field.getRangeName() != null || field.getRangeValues() != null && field.getRangeValues().size() > 0) {
            annotation = new SdoAnnotation(Range.class.getName());
            if (field.getRangeName() != null) {
                annotation.addValue("name", field.getRangeName());
            }
            if (field.getRangeValues() != null && field.getRangeValues().size() > 0) {
                annotation.addValue("startvalues", field.getRangeValues().stream().map(e -> (String)e.getKey()).collect(Collectors.toList()));
                annotation.addValue("endvalues", field.getRangeValues().stream().map(e -> (String)e.getValue()).collect(Collectors.toList()));
            }
            sdoField.addAnnotation(annotation);
        }
        if (field.getLength() != null) {
            annotation = new SdoAnnotation(Length.class.getName());
            annotation.addValue("value", field.getLength());
            sdoField.addAnnotation(annotation);
        }
        if (field.getRegexp() != null) {
            annotation = new SdoAnnotation(Regexp.class.getName());
            annotation.addValue("value", field.getRegexp());
            sdoField.addAnnotation(annotation);
        }
        this.addPrecisionAndScaleAnnotations(sdoField, field);
    }

    private void addPrecisionAndScaleAnnotations(SdoField sdoField, DataField field) {
        SdoAnnotation annotation;
        if (field.getPrecision() != null) {
            annotation = new SdoAnnotation(Precision.class.getName());
            annotation.addValue("value", field.getPrecision());
            sdoField.addAnnotation(annotation);
        }
        if (field.getScale() != null) {
            annotation = new SdoAnnotation(Scale.class.getName());
            annotation.addValue("value", field.getScale());
            sdoField.addAnnotation(annotation);
        }
    }

    protected void addFieldSemanticTypeAnnotation(SdoField sdoField, String type, String alias, String type1) {
        this.addFieldSemanticTypeAnnotation(sdoField, type, alias, type1, 0);
    }

    protected void addFieldSemanticTypeAnnotation(SdoField sdoField, String type, String alias, String type1, int level) {
        String slevel = level == 0 ? "" : String.valueOf(level);
        SdoAnnotation annotation = new SdoAnnotation(com.streamscape.runtime.mf.operation.edl.annotations.SemanticType.class.getName() + slevel);
        annotation.addValue("type", type);
        if (alias != null) {
            annotation.addValue("alias", alias);
        }
        if (type1 != null) {
            annotation.addValue("type1", type1);
        }
        sdoField.addAnnotation(annotation);
    }

    protected void addSemanticTypeToCompiler(Type<?> fieldType) throws EDLException {
    }

    protected SdoMethod getCloneMethod() {
        if (this.cloneMethod == null) {
            this.getSdoConstructor();
            this.cloneMethod = new SdoMethod("Object", "clone");
            this.cloneMethod.appendToBody(this.getSdoClass().getFullClassName() + " result = new " + this.getSdoClass().getFullClassName() + "();\n");
            this.addMethod(this.cloneMethod);
        }
        return this.cloneMethod;
    }

    public void finish() {
        this.getCloneMethod().appendToBody("return result;\n");
    }

    private boolean isNeedToClone(Type<?> fieldType) {
        switch (fieldType.getType()) {
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case EVENT: 
            case OBJECT: 
            case SEMANTIC_TYPE: 
            case LIST: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    private String createSimpleFieldClone(Type<?> fieldType, String fieldName) {
        switch (fieldType.getType()) {
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case EVENT: {
                return "(" + fieldType.getJavaClassName() + ")((" + fieldType.getJavaClassName() + ")" + fieldName + ").clone()";
            }
            case OBJECT: 
            case SEMANTIC_TYPE: 
            case LIST: 
            case MAP: {
                return "(" + fieldType.getJavaClassName() + ")com.streamscape.runtime.mf.operation.edl.generator.SdoCloneHelper.clone(" + fieldName + ")";
            }
        }
        return fieldName;
    }

    private String createCloneTemplateIfNotNull(String fieldName, String code) {
        return "if (this." + fieldName + " != null)\n{\n" + code + "\n}\nelse\n   result." + fieldName + " = this." + fieldName + ";\n\n";
    }

    protected void generateGetMethod(String type, String name) {
        SdoMethod method = new SdoMethod(type, AbstractSdoGenerator.getGetterForField(name));
        method.appendToBody("return this." + name + ";");
        this.addMethod(method);
    }

    protected void generateSetMethod(String type, String name) {
        SdoMethod method = new SdoMethod("void", AbstractSdoGenerator.getSetterForField(name));
        method.addArgument(type, name);
        method.appendToBody("this." + name + " = " + name + ";");
        this.addMethod(method);
    }

    protected void generateAddToMethod(String type, String name) {
        SdoMethod method = new SdoMethod("void", "addTo" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(type, "value");
        method.appendToBody("this." + name + ".add(value);");
        this.addMethod(method);
    }

    protected void generateAddToAtMethod(String type, String name) {
        SdoMethod method = new SdoMethod("void", "addTo" + AbstractSdoGenerator.methodSuffixForField(name) + "At");
        method.addThrowsException(IndexOutOfBoundsException.class.getName());
        method.addArgument("int", "index");
        method.addArgument(type, "value");
        method.appendToBody("this." + name + ".add(index, value);");
        this.addMethod(method);
    }

    protected void generateRemoveFromMethod(String type, String name) {
        SdoMethod method = new SdoMethod("boolean", "removeFrom" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(type, "value");
        method.appendToBody("return this." + name + ".remove(value);");
        this.addMethod(method);
    }

    protected void generateRemoveFromAtMethod(String type, String name) {
        SdoMethod method = new SdoMethod(type, "removeFrom" + AbstractSdoGenerator.methodSuffixForField(name) + "At");
        method.addThrowsException(IndexOutOfBoundsException.class.getName());
        method.addArgument("int", "index");
        method.appendToBody("return (" + type + ")this." + name + ".remove(index);");
        this.addMethod(method);
    }

    protected void generateGetAtMethod(String type, String name) {
        SdoMethod method = new SdoMethod(type, "get" + AbstractSdoGenerator.methodSuffixForField(name) + "At");
        method.addThrowsException(IndexOutOfBoundsException.class.getName());
        method.addArgument("int", "index");
        method.appendToBody("return (" + type + ")this." + name + ".get(index);");
        this.addMethod(method);
    }

    protected void generateIsEmptyMethod(String name) {
        SdoMethod method = new SdoMethod("boolean", "isEmpty" + AbstractSdoGenerator.methodSuffixForField(name));
        method.appendToBody("if (this." + name + " == null) return true;");
        method.appendToBody("return this." + name + ".isEmpty();");
        this.addMethod(method);
    }

    protected void generateIterateMethod(String type, String name) {
        SdoMethod method = new SdoMethod("java.util.Iterator", "iterate" + AbstractSdoGenerator.methodSuffixForField(name));
        method.appendToBody("return this." + name + ".iterator();");
        this.addMethod(method);
    }

    protected void generateSetAtMethodForArray(String type, String name) {
        SdoMethod method = new SdoMethod("void", "set" + AbstractSdoGenerator.methodSuffixForField(name) + "At");
        method.addThrowsException(IndexOutOfBoundsException.class.getName());
        method.addArgument("int", "index");
        method.addArgument(type, "value");
        method.appendToBody("if (index < 0 || index > this." + name + ".length) throw new IndexOutOfBoundsException(\"Index \" + index + \" is out of range [0..\" + this." + name + ".length + \").\");\n");
        method.appendToBody("this." + name + "[index]= value;");
        this.addMethod(method);
    }

    protected void generateGetAtMethodForArray(String type, String name) {
        SdoMethod method = new SdoMethod(type, "get" + AbstractSdoGenerator.methodSuffixForField(name) + "At");
        method.addThrowsException(IndexOutOfBoundsException.class.getName());
        method.addArgument("int", "index");
        method.appendToBody("if (index < 0 || index > this." + name + ".length) throw new IndexOutOfBoundsException(\"Index \" + index + \" is out of range [0..\" + this." + name + ".length + \").\");\n");
        method.appendToBody("return (" + type + ")this." + name + "[index];");
        this.addMethod(method);
    }

    protected void generatePutToMethod(String keyType, String valueType, String name) {
        SdoMethod method = new SdoMethod(valueType, "putTo" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(keyType, "key");
        method.addArgument(valueType, "value");
        method.appendToBody("return (" + valueType + ")this." + name + ".put(key, value);");
        this.addMethod(method);
    }

    protected void generateGetFromMethod(String keyType, String valueType, String name) {
        SdoMethod method = new SdoMethod(valueType, "getFrom" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(keyType, "key");
        method.appendToBody("return (" + valueType + ")this." + name + ".get(key);");
        this.addMethod(method);
    }

    protected void generateRemoveFromMethod(String keyType, String valueType, String name) {
        SdoMethod method = new SdoMethod(valueType, "removeFrom" + AbstractSdoGenerator.methodSuffixForField(name));
        method.addArgument(keyType, "key");
        method.appendToBody("return (" + valueType + ")this." + name + ".remove(key);");
        this.addMethod(method);
    }

    protected void generateGetMethodForTypeMap(MapDataField field, String entryType) {
        SdoMethod method = new SdoMethod("java.util.Map", "get" + AbstractSdoGenerator.methodSuffixForField(field.getName()));
        method.appendToBody("java.util.Map result = new java.util.HashMap();\n");
        method.appendToBody("java.util.Iterator iterator = " + field.getName() + ".iterator();\n");
        method.appendToBody("while(iterator.hasNext()){\n" + entryType + " entry = (" + entryType + ")iterator.next();\n");
        method.appendToBody("result.put(entry." + field.getKeyName() + ",entry." + field.getValueName() + ");\n}\n");
        method.appendToBody("return result;");
        this.addMethod(method);
    }

    protected void generateSetMethodForTypeMap(MapDataField field, String entryType) throws EDLException {
        SdoMethod method = new SdoMethod("void ", "set" + AbstractSdoGenerator.methodSuffixForField(field.getName()));
        method.addArgument("java.util.Map", field.getName());
        method.appendToBody("this." + field.getName() + "= new java.util.ArrayList();\n");
        method.appendToBody("java.util.Iterator iterator = " + field.getName() + ".entrySet().iterator();\n");
        method.appendToBody("while(iterator.hasNext()){\njava.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();\n");
        method.appendToBody(entryType + " entry1 = new " + entryType + "();\n");
        method.appendToBody("entry1." + field.getKeyName() + " = (" + field.getType().getJavaClassName() + ")entry.getKey();\n");
        method.appendToBody("entry1." + field.getValueName() + " = (" + field.getValueType().getJavaClassName() + ")entry.getValue();\n");
        method.appendToBody("this." + field.getName() + ".add(entry1);\n");
        method.appendToBody("}");
        this.addMethod(method);
    }

    protected void generatePutToMethodForTypeMap(MapDataField field, String entryType) throws EDLException {
        SdoMethod method = new SdoMethod(field.getValueType().getJavaClassName(), "putTo" + AbstractSdoGenerator.methodSuffixForField(field.getName()));
        method.addArgument(field.getType().getJavaClassName(), "key");
        method.addArgument(field.getValueType().getJavaClassName(), "value");
        method.appendToBody("java.util.Iterator iterator = " + field.getName() + ".iterator();\n");
        method.appendToBody("while(iterator.hasNext()){\n" + entryType + " entry = (" + entryType + ")iterator.next();\n");
        method.appendToBody("if (entry." + field.getKeyName() + ".equals(key)) { " + field.getValueType().getJavaClassName() + " oldValue=entry." + field.getValueName() + "; entry." + field.getValueName() + " = value; return oldValue;}\n}\n");
        method.appendToBody(entryType + " entry = new " + entryType + "();\n");
        method.appendToBody("entry." + field.getKeyName() + " = key;\n");
        method.appendToBody("entry." + field.getValueName() + " = value;\n");
        method.appendToBody(field.getName() + ".add(entry);\n");
        method.appendToBody("return null;");
        this.addMethod(method);
    }

    protected void generateGetFromMethodForTypeMap(MapDataField field, String entryType) throws EDLException {
        SdoMethod method = new SdoMethod(field.getValueType().getJavaClassName(), "getFrom" + AbstractSdoGenerator.methodSuffixForField(field.getName()));
        method.addArgument(field.getType().getJavaClassName(), "key");
        method.appendToBody("java.util.Iterator iterator = " + field.getName() + ".iterator();\n");
        method.appendToBody("while(iterator.hasNext()){\n" + entryType + " entry = (" + entryType + ")iterator.next();\n");
        method.appendToBody("if (entry." + field.getKeyName() + ".equals(key)) return entry." + field.getValueName() + ";}\n");
        method.appendToBody("return null;");
        this.addMethod(method);
    }

    protected void generateRemoveFromMethodForTypeMap(MapDataField field, String entryType) throws EDLException {
        SdoMethod method = new SdoMethod(field.getValueType().getJavaClassName(), "removeFrom" + AbstractSdoGenerator.methodSuffixForField(field.getName()));
        method.addArgument(field.getType().getJavaClassName(), "key");
        method.appendToBody("java.util.Iterator iterator = " + field.getName() + ".iterator();\n");
        method.appendToBody("while(iterator.hasNext()){\n" + entryType + " entry = (" + entryType + ")iterator.next();\n");
        method.appendToBody("if (entry." + field.getKeyName() + ".equals(key)) { iterator.remove(); return entry." + field.getValueName() + ";}\n}\n");
        method.appendToBody("return null;");
        this.addMethod(method);
    }

    private static class JavaDocGeneratorObserver
    implements AbstractSdoGenerator.GeneratorObserver {
        private JavaDocGeneratorObserver() {
        }

        @Override
        public void onCreateClass(SdoClass sdoClass) {
        }

        @Override
        public void onCreateConstructor(SdoConstructor sdoConstructor) {
        }

        @Override
        public void onAddField(SdoField sdoField, DataField dataField) {
            try {
                sdoField.setJavaDoc(SdoJavaDocGenerator.createJavaDocForField(sdoField, dataField));
            }
            catch (EDLException exception) {
                Trace.logException(this, exception, false);
            }
        }

        @Override
        public void onAddMethod(SdoMethod field) {
        }
    }
}

