/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.runtime.mf.operation.edl.generator.SdoAnnotation;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import java.util.ArrayList;
import java.util.List;

public class SdoCommon {
    private String modifier;
    private boolean isStatic;
    private boolean isSynchronized;
    private boolean isAbstract;
    private boolean isFinal;
    private List<SdoAnnotation> annotations;
    private JavaDoc javaDoc;

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public List<SdoAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(SdoAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<SdoAnnotation>();
        }
        this.annotations.add(annotation);
    }

    public SdoAnnotation getAnnotation(String type) {
        if (this.annotations == null) {
            return null;
        }
        for (SdoAnnotation annotation : this.annotations) {
            if (!annotation.getType().equals(type)) continue;
            return annotation;
        }
        return null;
    }

    public boolean containsAnnotation(String type) {
        return this.getAnnotation(type) != null;
    }

    public JavaDoc getJavaDoc() {
        return this.javaDoc;
    }

    public void setJavaDoc(JavaDoc javaDoc) {
        this.javaDoc = javaDoc;
    }

    public String getPureCode() {
        return this.getCode(true);
    }

    protected String getCode(boolean pure) {
        StringBuffer builder = new StringBuffer();
        if (!pure) {
            if (this.javaDoc != null) {
                builder.append(this.javaDoc.toString()).append("\n");
            }
            if (this.annotations != null && this.annotations.size() > 0) {
                for (SdoAnnotation annotation : this.annotations) {
                    builder.append(annotation.toString()).append("\n");
                }
            }
        }
        if (this.modifier != null && this.modifier.length() > 0) {
            builder.append(this.modifier).append(" ");
        }
        if (this.isStatic) {
            builder.append("static ");
        }
        if (this.isFinal) {
            builder.append("final ");
        }
        if (this.isSynchronized) {
            builder.append("synchronized ");
        }
        if (this.isAbstract) {
            builder.append("abstract ");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getCode(false);
    }
}

